/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.domain.policy.impl;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.validation.ConstraintViolationException;
import jp.co.ogis_ri.citk.policytool.common.api.OpenAMAccess;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;
import jp.co.ogis_ri.citk.policytool.common.repository.JpaGenericRepository;
import jp.co.ogis_ri.citk.policytool.common.util.ExceptionUtil;
import jp.co.ogis_ri.citk.policytool.domain.policy.PolicyRepository;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JpaPolicyRepositoryImpl
extends JpaGenericRepository<Policy, Long>
implements PolicyRepository {
    private Log logger = LogWrapperFactory.getLog(JpaPolicyRepositoryImpl.class);
    @Autowired(required=false)
    private OpenAMAccess amAccess = null;

    @Override
    public void sync(String realmName) {
        List<Policy> policies = this.findPoliciesByRealmName(realmName);
        for (Policy policy : policies) {
            this.em.remove((Object)policy);
        }
        this.em.flush();
        List<Policy> listPolicies = this.amAccess.getPolicies(realmName, "*");
        for (Policy policy : listPolicies) {
            try {
                this.em.persist((Object)policy);
            }
            catch (ConstraintViolationException e) {
                this.logger.debug((Object)e.getMessage());
                throw ExceptionUtil.convertRuntimeException(e);
            }
        }
        this.em.flush();
    }

    @Override
    public List<Policy> findPoliciesByRealmName(String realmName) {
        return this.em.createQuery("SELECT e FROM Policy e where e.realmName = :RealmName order by e.policyName").setParameter("RealmName", (Object)realmName).getResultList();
    }

    @Override
    public List<Policy> findPolicies(String realmName, String subjectName, String resourceUrl) {
        ParameterExpression p;
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery c = cb.createQuery(Policy.class);
        Root policy = c.from(Policy.class);
        c.select((Selection)policy);
        c.distinct(true);
        Join subject = policy.join("subjects", JoinType.LEFT);
        Join resource = policy.join("resources", JoinType.LEFT);
        c.orderBy(new Order[]{cb.asc((Expression)policy.get("realmName")), cb.asc((Expression)policy.get("policyName"))});
        ArrayList<Predicate> criteria = new ArrayList<Predicate>();
        if (realmName != null) {
            p = cb.parameter(String.class, "realmName");
            criteria.add(cb.equal((Expression)policy.get("realmName"), (Expression)p));
        }
        if (subjectName != null) {
            p = cb.parameter(String.class, "subjectName");
            criteria.add(cb.equal((Expression)subject.get("subjectName"), (Expression)p));
        }
        if (resourceUrl != null) {
            p = cb.parameter(String.class, "resourceUrl");
            criteria.add(cb.like(resource.get("resourceUrl").as(String.class), (Expression)p));
        }
        if (criteria.size() == 1) {
            c.where((Expression)criteria.get(0));
        } else if (criteria.size() > 1) {
            c.where((Expression)cb.and(criteria.toArray(new Predicate[0])));
        }
        TypedQuery q = this.em.createQuery(c);
        if (realmName != null) {
            q.setParameter("realmName", (Object)realmName);
        }
        if (subjectName != null) {
            q.setParameter("subjectName", (Object)subjectName);
        }
        if (resourceUrl != null) {
            resourceUrl = resourceUrl.replaceAll("[%*?_]", "") + "%";
            q.setParameter("resourceUrl", (Object)resourceUrl);
        }
        return q.getResultList();
    }

    @Override
    public void persist(Policy policy) {
        this.em.persist((Object)policy);
        this.amAccess.createPolicy(policy);
    }

    @Override
    public Policy merge(Policy policy) {
        policy = (Policy)this.em.merge((Object)policy);
        this.amAccess.updatePolicy(policy);
        return policy;
    }

    @Override
    public void remove(Policy policy) {
        this.em.remove(this.em.merge((Object)policy));
        this.amAccess.deletePolicy(policy);
    }

    @Override
    public void importPolicies(List<Policy> policies) {
        List existedPolicies = this.findAll();
        for (Policy importedPolicy : policies) {
            boolean importedPolicyExists = false;
            for (Policy existedPolicy : existedPolicies) {
                if (!importedPolicy.getPolicyName().equals(existedPolicy.getPolicyName()) || !importedPolicy.getRealmName().equals(existedPolicy.getRealmName())) continue;
                importedPolicyExists = true;
                break;
            }
            if (importedPolicyExists) {
                this.amAccess.updatePolicy(importedPolicy);
                continue;
            }
            this.amAccess.createPolicy(importedPolicy);
        }
    }
}

