/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.domain.policy.model;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.validation.Valid;
import jp.co.ogis_ri.citk.policytool.common.model.AbstractModel;
import jp.co.ogis_ri.citk.policytool.common.validation.annotation.PolicyName;
import jp.co.ogis_ri.citk.policytool.common.validation.annotation.RealmName;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Permit;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Resource;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Subject;

@Entity
@Table(name="t_policy")
public class Policy
extends AbstractModel<Long> {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue
    private Long id;
    @RealmName
    String realmName = null;
    @PolicyName
    String policyName = null;
    @OneToMany(mappedBy="policy", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="subjectName asc")
    @Valid
    List<Subject> subjects = new ArrayList<Subject>();
    @OneToMany(mappedBy="policy", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="resourceUrl asc")
    @Valid
    List<Resource> resources = new ArrayList<Resource>();

    @Override
    public Long getId() {
        return this.id;
    }

    public List<Subject> getSubjects() {
        return this.subjects;
    }

    public void addSubject(Subject subject) {
        subject.setPolicy(this);
        this.subjects.add(subject);
    }

    public void addSubject(String subjectName, String subjectCode) {
        this.addSubject(new Subject(subjectName, subjectCode));
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void addResource(Resource resource) {
        resource.setPolicy(this);
        this.resources.add(resource);
    }

    public void addResource(String url, Permit get, Permit post) {
        this.addResource(new Resource(url, get, post));
    }

    public void addResource(String url, String getValue, String postValue) {
        this.addResource(new Resource(url, getValue, postValue));
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public Policy() {
    }

    public Policy(String realmName, String policyName) {
        this.realmName = realmName;
        this.policyName = policyName;
    }

    public void resetPermit() {
        for (Resource resource : this.resources) {
            resource.resetPermit();
        }
    }
}

