/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Subject;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleUrlDependOnRealm;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy={Validator.class})
public @interface RuleSubjectDependOnRealm {
    public String message() default "{jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleSubjectDependOnRealm.message.default}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class Validator
    implements ConstraintValidator<RuleSubjectDependOnRealm, PolicyValidModel> {
        public void initialize(RuleSubjectDependOnRealm arg0) {
        }

        public boolean isValid(PolicyValidModel arg0, ConstraintValidatorContext arg1) {
            int i = 0;
            for (Subject subject : arg0.getTarget().getSubjects()) {
                String subjectFullName = subject.getSubjectName() + "(" + subject.getSubjectCode() + ")";
                if (!arg0.getGroups().contains(subjectFullName)) {
                    arg1.disableDefaultConstraintViolation();
                    String messageTemplate = arg1.getDefaultConstraintMessageTemplate();
                    ConstraintValidatorContext.ConstraintViolationBuilder builder = arg1.buildConstraintViolationWithTemplate(messageTemplate + subjectFullName);
                    builder.addNode("policy").addNode("subjects").addNode("subjectName").inIterable().atIndex(Integer.valueOf(i)).addConstraintViolation();
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public RuleUrlDependOnRealm[] value();
    }
}

