/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Resource;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleUrlDependOnRealm;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy={Validator.class})
public @interface RuleUniqueResourceUrl {
    public String message() default "{jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleUniqueResourceUrl.message.default}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class Validator
    implements ConstraintValidator<RuleUniqueResourceUrl, PolicyValidModel> {
        public void initialize(RuleUniqueResourceUrl arg0) {
        }

        public boolean isValid(PolicyValidModel arg0, ConstraintValidatorContext arg1) {
            HashSet<String> resourceUrlSet = new HashSet<String>();
            for (int i = 0; i < arg0.getTarget().getResources().size(); ++i) {
                Resource resource = arg0.getTarget().getResources().get(i);
                boolean addResult = resourceUrlSet.add(resource.getResourceUrl());
                if (addResult) continue;
                arg1.disableDefaultConstraintViolation();
                String messageTemplate = arg1.getDefaultConstraintMessageTemplate();
                ConstraintValidatorContext.ConstraintViolationBuilder builder = arg1.buildConstraintViolationWithTemplate(messageTemplate + resource.getResourceUrl());
                builder.addNode("policy").addNode("resources").addNode("resourcesUrl").inIterable().atIndex(Integer.valueOf(i)).addConstraintViolation();
                return false;
            }
            return true;
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public RuleUrlDependOnRealm[] value();
    }
}

