/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Resource;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy={Validator.class})
public @interface RuleUrlDependOnRealm {
    public String message() default "{jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleUrlDependOnRealm.message.default}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class Validator
    implements ConstraintValidator<RuleUrlDependOnRealm, PolicyValidModel> {
        public void initialize(RuleUrlDependOnRealm arg0) {
        }

        public boolean isValid(PolicyValidModel arg0, ConstraintValidatorContext arg1) {
            int i = 0;
            for (Resource resource : arg0.getTarget().getResources()) {
                boolean contains = false;
                for (String refpolicy : arg0.getRefpolicies()) {
                    Matcher m = Pattern.compile(refpolicy).matcher(resource.getResourceUrl());
                    if (!m.find()) continue;
                    contains = true;
                }
                if (!contains) {
                    arg1.disableDefaultConstraintViolation();
                    String messageTemplate = arg1.getDefaultConstraintMessageTemplate();
                    ConstraintValidatorContext.ConstraintViolationBuilder builder = arg1.buildConstraintViolationWithTemplate(messageTemplate + resource.getResourceUrl());
                    builder.addNode("policy").addNode("resources").addNode("resourceUrl").inIterable().atIndex(Integer.valueOf(i)).addConstraintViolation();
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public RuleUrlDependOnRealm[] value();
    }
}

