/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.domain.realm.impl;

import java.util.List;
import javax.validation.ConstraintViolationException;
import jp.co.ogis_ri.citk.policytool.common.api.OpenAMAccess;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;
import jp.co.ogis_ri.citk.policytool.common.repository.JpaGenericRepository;
import jp.co.ogis_ri.citk.policytool.common.util.ExceptionUtil;
import jp.co.ogis_ri.citk.policytool.domain.realm.RealmRepository;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Group;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Referral;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JpaRealmRepositoryImpl
extends JpaGenericRepository<Realm, Long>
implements RealmRepository {
    private Log logger = LogWrapperFactory.getLog(JpaRealmRepositoryImpl.class);
    @Autowired(required=false)
    private OpenAMAccess amAccess = null;

    @Override
    public void sync() {
        List<Realm> realms = this.amAccess.getRealms("/", "*");
        this.removeAll();
        this.em.flush();
        for (Realm realm : realms) {
            try {
                this.persist(realm);
            }
            catch (ConstraintViolationException e) {
                this.logger.debug((Object)e.getMessage());
                throw ExceptionUtil.convertRuntimeException(e);
            }
        }
        this.em.flush();
    }

    @Override
    public List<String> findGroupNames(Realm realm) {
        String queryString = "SELECT DISTINCT e.groupName FROM Group e";
        if (realm != null) {
            queryString = queryString + " where e.realm.realmName = '" + realm.getRealmName() + "'";
        }
        queryString = queryString + " order by e.groupName";
        return this.em.createQuery(queryString).getResultList();
    }

    @Override
    public List<Referral> findReferrals(Realm realm) {
        String queryString = "SELECT e FROM Referral e";
        if (realm != null) {
            queryString = queryString + " where e.realm.realmName = '" + realm.getRealmName() + "'";
        }
        queryString = queryString + " order by e.refpolicy";
        return this.em.createQuery(queryString).getResultList();
    }

    @Override
    public List<Realm> findAll() {
        return this.em.createQuery("SELECT e FROM Realm e order by e.realmName").getResultList();
    }

    @Override
    public Realm findRealmByName(String realmName) {
        String queryString = "SELECT e FROM Realm e";
        if (realmName != null && realmName.length() > 0) {
            queryString = queryString + " where e.realmName = '" + realmName + "'";
        }
        return (Realm)this.em.createQuery(queryString).getResultList().get(0);
    }

    @Override
    public List<Group> findGroupByRealm(Realm realm) {
        String queryString = "SELECT e FROM Group e";
        if (realm != null) {
            queryString = queryString + " where e.realm.realmName = '" + realm.getRealmName() + "'";
        }
        queryString = queryString + " order by e.groupName";
        return this.em.createQuery(queryString).getResultList();
    }

    @Override
    public Group findGroupByName(Realm realm, String groupName) {
        return (Group)this.em.createQuery("SELECT e FROM Group e where e.realm.realmName = :RealmName AND e.groupName = :GroupName").setParameter("RealmName", (Object)realm.getRealmName()).setParameter("GroupName", (Object)groupName).getResultList().get(0);
    }
}

