/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.domain.realm.model;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.validation.Valid;
import jp.co.ogis_ri.citk.policytool.common.model.AbstractModel;
import jp.co.ogis_ri.citk.policytool.common.validation.annotation.RealmName;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Group;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Referral;

@Entity
@Table(name="t_realm")
public class Realm
extends AbstractModel<Long> {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue
    private Long id;
    @RealmName
    private String realmName;
    @OneToMany(mappedBy="realm", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="refpolicy asc")
    @Valid
    private List<Referral> referrals = new ArrayList<Referral>();
    @OneToMany(mappedBy="realm", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="groupName asc")
    @Valid
    private List<Group> groups = new ArrayList<Group>();

    @Override
    public Long getId() {
        return this.id;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void addReferral(String referral) {
        this.addReferral(new Referral(referral));
    }

    public void addReferral(Referral referral) {
        referral.setRealm(this);
        this.referrals.add(referral);
    }

    public List<Referral> getReferrals() {
        return this.referrals;
    }

    public void addGroup(String groupName, String groupCode) {
        this.addGroup(new Group(groupName, groupCode));
    }

    public void addGroup(Group group) {
        group.setRealm(this);
        this.groups.add(group);
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public Realm() {
    }

    public Realm(String realmName) {
        this.realmName = realmName;
    }
}

