/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.service.common.validation;

import java.util.List;
import jp.co.ogis_ri.citk.policytool.common.util.ApplicationContextUtil;
import jp.co.ogis_ri.citk.policytool.domain.policy.PolicyRepository;
import jp.co.ogis_ri.citk.policytool.domain.policy.impl.JpaPolicyRepositoryImpl;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;
import jp.co.ogis_ri.citk.policytool.domain.realm.RealmRepository;
import jp.co.ogis_ri.citk.policytool.domain.realm.impl.JpaRealmRepositoryImpl;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Group;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Referral;

public class PolicyValidModelFactory {
    public static PolicyValidModel create(Policy policy) {
        PolicyRepository policyRepository = ApplicationContextUtil.getBean(JpaPolicyRepositoryImpl.class);
        RealmRepository realmRepository = ApplicationContextUtil.getBean(JpaRealmRepositoryImpl.class);
        PolicyValidModel model = new PolicyValidModel();
        model.setTarget(policy);
        Realm realm = null;
        List realmList = realmRepository.findAll();
        for (Realm currentRealm : realmList) {
            if (!policy.getRealmName().equals(currentRealm.getRealmName())) continue;
            realm = currentRealm;
            break;
        }
        boolean isExistRealm = realm != null;
        model.setIsExistRealm(isExistRealm);
        if (realm != null) {
            for (Referral referral : realm.getReferrals()) {
                String refpolicy = referral.getRefpolicy();
                model.getRefpolicies().add(refpolicy);
            }
        }
        if (realm != null) {
            for (Group group : realm.getGroups()) {
                String fullGroupName = group.getGroupName() + "(" + group.getGroupCode() + ")";
                model.getGroups().add(fullGroupName);
            }
        }
        List policyList = policyRepository.findAll();
        model.getPolicies().addAll(policyList);
        return model;
    }
}

