/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.service.importpolicy.impl;

import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import jp.co.ogis_ri.citk.policytool.common.excel.ExcelPolicyReader;
import jp.co.ogis_ri.citk.policytool.common.exception.ExcelPolicyImportException;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;
import jp.co.ogis_ri.citk.policytool.common.util.ApplicationContextUtil;
import jp.co.ogis_ri.citk.policytool.domain.policy.PolicyRepository;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;
import jp.co.ogis_ri.citk.policytool.service.common.validation.PolicyValidModelFactory;
import jp.co.ogis_ri.citk.policytool.service.importpolicy.ImportPolicyService;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Service;

@Service
public class ImportPolicyServiceImpl
implements ImportPolicyService {
    private Log logger = LogWrapperFactory.getLog(ImportPolicyServiceImpl.class);
    @Autowired
    ExcelPolicyReader excelPolicyReader;
    @Autowired
    private Validator validator;
    @Autowired
    private PolicyRepository repository;
    private MessageSourceAccessor messageSourceAccessor = null;

    @Override
    public void importPolicy(String fileName) {
        List<Policy> policies = this.excelPolicyReader.read(fileName);
        this.singleValidate(policies, fileName);
        this.interrelateValidate(policies, fileName);
        this.repository.importPolicies(policies);
    }

    private String getMessage(String res, Object ... args) {
        if (this.messageSourceAccessor == null) {
            this.messageSourceAccessor = ApplicationContextUtil.getResources();
        }
        return this.messageSourceAccessor.getMessage(res, args);
    }

    private void singleValidate(List<Policy> policies, String fileName) {
        boolean isBad = false;
        for (Policy policy : policies) {
            this.logger.info((Object)this.getMessage("view.importService.singleValidationLoopStart", policy.getRealmName(), policy.getPolicyName()));
            Set result = this.validator.validate((Object)policy, new Class[0]);
            if (!result.isEmpty()) {
                for (ConstraintViolation violation : result) {
                    this.logger.error((Object)this.getMessage("view.importService.singleValidationError", violation.getMessage(), violation.getInvalidValue(), violation.getPropertyPath()));
                }
                isBad = true;
            } else {
                policy.resetPermit();
            }
            this.logger.info((Object)this.getMessage("view.importService.singleValidationLoopEnd", new Object[0]));
        }
        if (isBad) {
            throw new ExcelPolicyImportException("E-0301", fileName);
        }
    }

    private void interrelateValidate(List<Policy> policies, String fileName) {
        boolean isBad = false;
        for (Policy policy : policies) {
            this.logger.info((Object)this.getMessage("view.importService.interrelateValidationLoopStart", policy.getRealmName(), policy.getPolicyName()));
            PolicyValidModel validModel = PolicyValidModelFactory.create(policy);
            validModel.setTarget(policy);
            Set result = this.validator.validate((Object)validModel, new Class[]{PolicyValidModel.Import.class});
            if (!result.isEmpty()) {
                for (ConstraintViolation violation : result) {
                    this.logger.error((Object)this.getMessage("view.importService.interrelateValidationError", violation.getMessage(), violation.getPropertyPath()));
                }
                isBad = true;
            }
            this.logger.info((Object)this.getMessage("view.importService.interrelateValidationLoopEnd", new Object[0]));
        }
        if (isBad) {
            throw new ExcelPolicyImportException("E-0301", fileName);
        }
    }
}

