/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.service.policylist.impl;

import java.util.List;
import jp.co.ogis_ri.citk.policytool.domain.policy.PolicyRepository;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.realm.RealmRepository;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Referral;
import jp.co.ogis_ri.citk.policytool.service.policylist.PolicyListService;
import jp.co.ogis_ri.citk.policytool.service.policylist.model.PolicyView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class PolicyListServiceImpl
implements PolicyListService {
    @Autowired
    private RealmRepository realmRepository = null;
    @Autowired
    private PolicyRepository policyRepository = null;

    @Override
    public void delete(Policy policy) {
        this.policyRepository.remove(policy);
    }

    @Override
    public void refresh() {
        this.realmRepository.sync();
        this.policyRepository.removeAll();
        for (Realm realm : this.realmRepository.findAll()) {
            this.policyRepository.sync(realm.getRealmName());
        }
    }

    @Override
    public List<Realm> findRealms() {
        return this.realmRepository.findAll();
    }

    @Override
    public List<String> findGroupNames(Realm realm) {
        return this.realmRepository.findGroupNames(realm);
    }

    @Override
    public List<Referral> findReferrals(Realm realm) {
        return this.realmRepository.findReferrals(realm);
    }

    @Override
    public List<PolicyView> findPolicies(String realmName, String groupCode, String resourceUrl) {
        return PolicyView.create(this.policyRepository.findPolicies(realmName, groupCode, resourceUrl));
    }
}

