/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.service.policylist.model;

import java.util.ArrayList;
import java.util.List;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Resource;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Subject;

public class PolicyView {
    private String realmName;
    private String policyName;
    private List<String> resourceUrls;
    private List<String> subjects;
    private Policy policy;

    private PolicyView(Policy policy) {
        this.realmName = policy.getRealmName();
        this.policyName = policy.getPolicyName();
        this.resourceUrls = new ArrayList<String>();
        for (Resource resource : policy.getResources()) {
            this.resourceUrls.add(resource.getResourceUrl());
        }
        this.subjects = new ArrayList<String>();
        for (Subject subject : policy.getSubjects()) {
            this.subjects.add(subject.getSubjectName() + " (" + subject.getSubjectCode() + ")");
        }
        this.policy = policy;
    }

    public static List<PolicyView> create(List<Policy> policies) {
        ArrayList<PolicyView> list = new ArrayList<PolicyView>();
        for (Policy policy : policies) {
            list.add(new PolicyView(policy));
        }
        return list;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String[] getResourceUrls() {
        int size = this.resourceUrls.size();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.resourceUrls.get(i);
        }
        return ret;
    }

    public String[] getSubjects() {
        int size = this.subjects.size();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.subjects.get(i);
        }
        return ret;
    }

    public Policy getPolicy() {
        return this.policy;
    }
}

