/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.service.policyset.impl;

import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import jp.co.ogis_ri.citk.policytool.domain.policy.PolicyRepository;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;
import jp.co.ogis_ri.citk.policytool.domain.realm.RealmRepository;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Group;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Referral;
import jp.co.ogis_ri.citk.policytool.service.common.validation.PolicyValidModelFactory;
import jp.co.ogis_ri.citk.policytool.service.policyset.PolicySetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class PolicySetServiceImpl
implements PolicySetService {
    @Autowired
    private RealmRepository realmRepository = null;
    @Autowired
    private PolicyRepository policyRepository = null;
    @Autowired
    private Validator validator;

    private PolicySetServiceImpl() {
    }

    @Override
    public List<Realm> findRealms() {
        return this.realmRepository.findAll();
    }

    @Override
    public Realm findRealmByName(String realmName) {
        return this.realmRepository.findRealmByName(realmName);
    }

    @Override
    public List<Group> findGroupByRealm(Realm realm) {
        return this.realmRepository.findGroupByRealm(realm);
    }

    @Override
    public List<Referral> findReferrals(Realm realmModel) {
        return this.realmRepository.findReferrals(realmModel);
    }

    @Override
    public ConstraintViolation<?> addPolicy(Policy policy) {
        Set<ConstraintViolation<Policy>> result = this.validatePolicy(policy);
        if (!result.isEmpty()) {
            return result.iterator().next();
        }
        Set<ConstraintViolation<PolicyValidModel>> correlationResult = this.validateCreatePolicyCorrelation(policy);
        if (!correlationResult.isEmpty()) {
            return correlationResult.iterator().next();
        }
        this.policyRepository.persist(policy);
        return null;
    }

    @Override
    public ConstraintViolation<?> modifyPolicy(Policy policy) {
        Set<ConstraintViolation<Policy>> result = this.validatePolicy(policy);
        if (!result.isEmpty()) {
            return result.iterator().next();
        }
        Set<ConstraintViolation<PolicyValidModel>> correlationResult = this.validateUpdatePolicyCorrelation(policy);
        if (!correlationResult.isEmpty()) {
            return correlationResult.iterator().next();
        }
        this.policyRepository.merge(policy);
        return null;
    }

    private Set<ConstraintViolation<Policy>> validatePolicy(Policy target) {
        Set result = this.validator.validate((Object)target, new Class[0]);
        if (!result.isEmpty()) {
            return result;
        }
        return result;
    }

    private Set<ConstraintViolation<PolicyValidModel>> validateCreatePolicyCorrelation(Policy target) {
        PolicyValidModel model = PolicyValidModelFactory.create(target);
        model.setTarget(target);
        Set result = this.validator.validate((Object)model, new Class[]{PolicyValidModel.Create.class});
        if (!result.isEmpty()) {
            return result;
        }
        return result;
    }

    private Set<ConstraintViolation<PolicyValidModel>> validateUpdatePolicyCorrelation(Policy target) {
        PolicyValidModel model = PolicyValidModelFactory.create(target);
        model.setTarget(target);
        Set result = this.validator.validate((Object)model, new Class[]{PolicyValidModel.Update.class});
        if (!result.isEmpty()) {
            return result;
        }
        return result;
    }
}

