/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.view.common;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class ComboBoxTableCellEditor
extends JComboBox
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    private static final int BUTTON_AND_BLANK_WIDTH = 30;
    protected EventListenerList listenerList = new EventListenerList();
    protected ChangeEvent changeEvent = new ChangeEvent(this);

    public ComboBoxTableCellEditor(Object[] items) {
        for (Object item : items) {
            this.addItem(item);
        }
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ComboBoxTableCellEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public void addCellEditorListener(CellEditorListener listener) {
        this.listenerList.add(CellEditorListener.class, listener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
        this.listenerList.remove(CellEditorListener.class, listener);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CellEditorListener.class) continue;
            CellEditorListener listener = (CellEditorListener)listeners[i + 1];
            listener.editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CellEditorListener.class) continue;
            CellEditorListener listener = (CellEditorListener)listeners[i + 1];
            listener.editingCanceled(this.changeEvent);
        }
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.getSelectedItem();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setSelectedItem(value);
        return this;
    }

    public int getAutoCellWidth() {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int maxWidth = -1;
        for (int i = 0; i < this.getItemCount(); ++i) {
            Object item = this.getItemAt(i);
            String string = item.toString();
            int currentWidth = metrics.stringWidth(string);
            maxWidth = Math.max(currentWidth, maxWidth);
        }
        int widthWithButtonAndBlank = maxWidth + 30;
        return widthWithButtonAndBlank;
    }
}

