/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.view.common;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jp.co.ogis_ri.citk.policytool.view.common.ComboBoxTableCellRenderer;

public class JTableColumnWidthCalculator {
    private static final int COMBO_BOX_ADDITIONAL_WIDTH = 28;
    private static final int COLUMN_ADDITIONAL_WIDTH = 3;
    private JTable table;

    public JTableColumnWidthCalculator(JTable table) {
        this.table = table;
    }

    public void setAutomatically() {
        for (int columnIndex = 0; columnIndex < this.table.getColumnCount(); ++columnIndex) {
            this.setAutomatically(columnIndex);
        }
    }

    public void setAutomatically(int columnIndex) {
        this.setAutomatically(columnIndex, new ArrayList<String>());
    }

    public void setAutomatically(int columnIndex, List<String> stringList) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(columnIndex);
        FontMetrics headerFontMetrics = this.table.getFontMetrics(this.table.getTableHeader().getFont());
        String headerString = (String)tableColumn.getHeaderValue();
        int maxWidth = headerFontMetrics.stringWidth(headerString);
        TableCellRenderer renderer = tableColumn.getCellRenderer();
        if (renderer instanceof ComboBoxTableCellRenderer) {
            ComboBoxTableCellRenderer comboBoxTableCellRenderer = (ComboBoxTableCellRenderer)renderer;
            FontMetrics comboBoxFontMetrics = comboBoxTableCellRenderer.getFontMetrics(comboBoxTableCellRenderer.getFont());
            int maxStringWidth = 0;
            for (int i = 0; i < comboBoxTableCellRenderer.getItemCount(); ++i) {
                int stringWidth = comboBoxFontMetrics.stringWidth(comboBoxTableCellRenderer.getItemAt(i).toString());
                maxStringWidth = Math.max(stringWidth, maxStringWidth);
            }
            for (String string : stringList) {
                int width = comboBoxFontMetrics.stringWidth(string);
                maxWidth = Math.max(width, maxWidth);
            }
            maxWidth = maxStringWidth + 28;
        } else {
            TableModel tableModel = this.table.getModel();
            FontMetrics fontMetrics = this.table.getFontMetrics(this.table.getFont());
            for (int rowIndex = 0; rowIndex < this.table.getRowCount(); ++rowIndex) {
                Object value = tableModel.getValueAt(rowIndex, columnIndex);
                if (value instanceof String[]) {
                    String[] strings = (String[])value;
                    for (int i = 0; i < strings.length; ++i) {
                        int width = fontMetrics.stringWidth(strings[i]);
                        maxWidth = Math.max(width, maxWidth);
                    }
                    continue;
                }
                String string = value.toString();
                int width = fontMetrics.stringWidth(string);
                maxWidth = Math.max(width, maxWidth);
            }
            for (String string : stringList) {
                int width = fontMetrics.stringWidth(string);
                maxWidth = Math.max(width, maxWidth);
            }
        }
        if (maxWidth != -1) {
            tableColumn.setPreferredWidth(maxWidth + 3);
        }
    }
}

