/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.view.common;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.validation.ConstraintViolation;
import jp.co.ogis_ri.citk.policytool.common.exception.ApplicationException;
import jp.co.ogis_ri.citk.policytool.common.exception.SystemException;
import jp.co.ogis_ri.citk.policytool.common.util.ApplicationContextUtil;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.NestedRuntimeException;

public class MessageDialog {
    private MessageDialog() {
    }

    public static int showConfirm(Component parent, String code, Object ... args) {
        MessageSourceAccessor message = ApplicationContextUtil.getResources();
        return JOptionPane.showConfirmDialog(parent, message.getMessage(code, args), MessageDialog.getMessageTitle(code), 0, MessageDialog.getMessageType(code));
    }

    public static void showMessage(Component parent, String code, Object ... args) {
        MessageSourceAccessor message = ApplicationContextUtil.getResources();
        JOptionPane.showMessageDialog(parent, message.getMessage(code, args), MessageDialog.getMessageTitle(code), MessageDialog.getMessageType(code));
    }

    public static void showViolationMessage(Component parent, ConstraintViolation<?> violation) {
        MessageSourceAccessor message = ApplicationContextUtil.getResources();
        JOptionPane.showMessageDialog(parent, violation.getMessage(), message.getMessage("common.dialog.title.confirm"), 1);
    }

    public static void showApplicationException(ApplicationException e) {
        String code = e.getMessageInfo().getCode();
        JOptionPane.showMessageDialog(null, e.getMessage(), MessageDialog.getMessageTitle(code), MessageDialog.getMessageType(code));
    }

    public static void showSystemException(SystemException e) {
        MessageSourceAccessor message = ApplicationContextUtil.getResources();
        JOptionPane.showMessageDialog(null, e.getMessage(), message.getMessage("common.dialog.title.error"), 0);
    }

    public static void showNestedRuntimeException(NestedRuntimeException e) {
        JOptionPane.showMessageDialog(null, e.getRootCause(), "ERROR", 0);
    }

    public static void showException(Throwable e) {
        JOptionPane.showMessageDialog(null, e, "ERROR", 0);
    }

    private static String getMessageTitle(String code) {
        MessageSourceAccessor message = ApplicationContextUtil.getResources();
        if (code.startsWith("E")) {
            return message.getMessage("common.dialog.title.error");
        }
        if (code.startsWith("W")) {
            return message.getMessage("common.dialog.title.warn");
        }
        if (code.startsWith("I")) {
            return message.getMessage("common.dialog.title.info");
        }
        if (code.startsWith("C")) {
            return message.getMessage("common.dialog.title.confirm");
        }
        return null;
    }

    private static int getMessageType(String code) {
        if (code.startsWith("E")) {
            return 0;
        }
        if (code.startsWith("W")) {
            return 2;
        }
        if (code.startsWith("I")) {
            return 1;
        }
        if (code.startsWith("C")) {
            return 3;
        }
        return Integer.MIN_VALUE;
    }
}

