/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.view.common;

import jp.co.ogis_ri.citk.policytool.AppLauncher;
import jp.co.ogis_ri.citk.policytool.common.exception.ApplicationException;
import jp.co.ogis_ri.citk.policytool.common.exception.SystemException;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;
import jp.co.ogis_ri.citk.policytool.view.common.MessageDialog;
import org.apache.commons.logging.Log;
import org.springframework.core.NestedRuntimeException;

public class ViewExceptionHandler {
    private static final Log logger = LogWrapperFactory.getLog(AppLauncher.class);

    public void handle(Throwable e) {
        try {
            logger.error((Object)e.getMessage(), e.getCause());
            if (e instanceof ApplicationException) {
                MessageDialog.showApplicationException((ApplicationException)ApplicationException.class.cast(e));
            } else if (e instanceof SystemException) {
                MessageDialog.showSystemException((SystemException)SystemException.class.cast(e));
                System.exit(-1);
            } else if (e instanceof NestedRuntimeException) {
                MessageDialog.showNestedRuntimeException((NestedRuntimeException)NestedRuntimeException.class.cast(e));
                System.exit(-1);
            } else {
                MessageDialog.showException(e);
                System.exit(-1);
            }
        }
        catch (Exception ex) {
            logger.fatal((Object)ex, ex.getCause());
            System.exit(-1);
        }
    }
}

