/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.view.exportpolicy;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.co.ogis_ri.citk.policytool.service.exportpolicy.ExportPolicyService;
import jp.co.ogis_ri.citk.policytool.view.common.MessageDialog;
import jp.co.ogis_ri.citk.policytool.view.common.ViewExceptionHandler;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.MessageSourceAccessor;

public class ExportPolicyView
extends JDialog {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ExportPolicyService service = null;
    private MessageSourceAccessor messages = null;
    private ViewExceptionHandler viewExceptionHandler = new ViewExceptionHandler();
    private JPanel messagePanel;
    private JLabel messageLabel;
    private JPanel conditionPanel;
    private JLabel realmNameTitleLabel;
    private JTextField realmNameTextField;
    private JLabel groupNameTitleLabel;
    private JTextField groupNameTextField;
    private JLabel resourceUrlTitleLabel;
    private JTextField resourceUrlTextField;
    private JPanel fileNamePanel;
    private JLabel fileNameTitleLabel;
    private JTextField fileNameTextField;
    private JButton fileReferenceButton;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;

    public void init() {
        this.setTitle(this.messages.getMessage("view.exportView.title"));
        this.setSize(600, 270);
        this.setMinimumSize(new Dimension(400, 270));
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        this.messagePanel = new JPanel();
        GridBagConstraints gbc_messagePanel = new GridBagConstraints();
        gbc_messagePanel.insets = new Insets(10, 10, 0, 10);
        gbc_messagePanel.gridx = 0;
        gbc_messagePanel.gridy = 0;
        gbc_messagePanel.fill = 1;
        this.getContentPane().add((Component)this.messagePanel, gbc_messagePanel);
        this.messagePanel.setLayout(new FlowLayout(0, 5, 5));
        this.messageLabel = new JLabel(this.messages.getMessage("view.exportView.message"));
        this.messagePanel.add(this.messageLabel);
        this.conditionPanel = new JPanel();
        GridBagConstraints gbc_conditionPanel = new GridBagConstraints();
        gbc_conditionPanel.weightx = 1.0;
        gbc_conditionPanel.weighty = 1.0;
        gbc_conditionPanel.insets = new Insets(5, 10, 0, 10);
        gbc_conditionPanel.gridy = 1;
        gbc_conditionPanel.gridx = 0;
        gbc_conditionPanel.fill = 1;
        this.getContentPane().add((Component)this.conditionPanel, gbc_conditionPanel);
        GridBagLayout gbl_conditionPanel = new GridBagLayout();
        gbl_conditionPanel.columnWidths = new int[]{0, 0};
        gbl_conditionPanel.rowHeights = new int[]{0, 0, 0, 0, 0};
        gbl_conditionPanel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_conditionPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0};
        this.conditionPanel.setLayout(gbl_conditionPanel);
        this.realmNameTitleLabel = new JLabel(this.messages.getMessage("view.exportView.realmTitle"));
        GridBagConstraints gbc_realmNameTitleLabel = new GridBagConstraints();
        gbc_realmNameTitleLabel.weightx = 0.0;
        gbc_realmNameTitleLabel.weighty = 0.0;
        gbc_realmNameTitleLabel.insets = new Insets(0, 0, 0, 5);
        gbc_realmNameTitleLabel.fill = 1;
        gbc_realmNameTitleLabel.gridx = 0;
        gbc_realmNameTitleLabel.gridy = 0;
        this.conditionPanel.add((Component)this.realmNameTitleLabel, gbc_realmNameTitleLabel);
        this.realmNameTextField = new JTextField();
        GridBagConstraints gbc_realmNameTextField = new GridBagConstraints();
        gbc_realmNameTextField.weightx = 1.0;
        gbc_realmNameTextField.weighty = 0.0;
        gbc_realmNameTextField.insets = new Insets(0, 0, 0, 0);
        gbc_realmNameTextField.fill = 1;
        gbc_realmNameTextField.gridx = 1;
        gbc_realmNameTextField.gridy = 0;
        this.conditionPanel.add((Component)this.realmNameTextField, gbc_realmNameTextField);
        this.realmNameTextField.setEditable(false);
        this.groupNameTitleLabel = new JLabel(this.messages.getMessage("view.exportView.groupTitle"));
        GridBagConstraints gbc_groupNameTitleLabel = new GridBagConstraints();
        gbc_groupNameTitleLabel.weightx = 0.0;
        gbc_groupNameTitleLabel.weighty = 0.0;
        gbc_groupNameTitleLabel.insets = new Insets(5, 0, 0, 5);
        gbc_groupNameTitleLabel.fill = 1;
        gbc_groupNameTitleLabel.gridx = 0;
        gbc_groupNameTitleLabel.gridy = 1;
        this.conditionPanel.add((Component)this.groupNameTitleLabel, gbc_groupNameTitleLabel);
        this.groupNameTextField = new JTextField();
        GridBagConstraints gbc_groupNameTextField = new GridBagConstraints();
        gbc_groupNameTextField.weightx = 1.0;
        gbc_groupNameTextField.weighty = 0.0;
        gbc_groupNameTextField.insets = new Insets(5, 0, 0, 0);
        gbc_groupNameTextField.fill = 1;
        gbc_groupNameTextField.gridx = 1;
        gbc_groupNameTextField.gridy = 1;
        this.conditionPanel.add((Component)this.groupNameTextField, gbc_groupNameTextField);
        this.groupNameTextField.setEditable(false);
        this.resourceUrlTitleLabel = new JLabel(this.messages.getMessage("view.exportView.resourceTitle"));
        GridBagConstraints gbc_resourceUrlTitleLabel = new GridBagConstraints();
        gbc_resourceUrlTitleLabel.weightx = 0.0;
        gbc_resourceUrlTitleLabel.weighty = 0.0;
        gbc_resourceUrlTitleLabel.insets = new Insets(5, 0, 0, 5);
        gbc_resourceUrlTitleLabel.fill = 1;
        gbc_resourceUrlTitleLabel.gridx = 0;
        gbc_resourceUrlTitleLabel.gridy = 2;
        this.conditionPanel.add((Component)this.resourceUrlTitleLabel, gbc_resourceUrlTitleLabel);
        this.resourceUrlTextField = new JTextField();
        GridBagConstraints gbc_resourceUrlTextField = new GridBagConstraints();
        gbc_resourceUrlTextField.weightx = 1.0;
        gbc_resourceUrlTextField.weighty = 0.0;
        gbc_resourceUrlTextField.insets = new Insets(5, 0, 0, 0);
        gbc_resourceUrlTextField.fill = 1;
        gbc_resourceUrlTextField.gridx = 1;
        gbc_resourceUrlTextField.gridy = 2;
        this.conditionPanel.add((Component)this.resourceUrlTextField, gbc_resourceUrlTextField);
        this.resourceUrlTextField.setEditable(false);
        this.fileNameTitleLabel = new JLabel(this.messages.getMessage("view.exportView.outputFileNameTitle"));
        GridBagConstraints gbc_fileNameTitleLabel = new GridBagConstraints();
        gbc_fileNameTitleLabel.insets = new Insets(0, 0, 0, 5);
        gbc_fileNameTitleLabel.gridx = 0;
        gbc_fileNameTitleLabel.gridy = 3;
        this.conditionPanel.add((Component)this.fileNameTitleLabel, gbc_fileNameTitleLabel);
        this.fileNamePanel = new JPanel();
        GridBagConstraints gbc_fileNamePanel = new GridBagConstraints();
        gbc_fileNamePanel.weightx = 1.0;
        gbc_fileNamePanel.weighty = 0.0;
        gbc_fileNamePanel.insets = new Insets(5, 0, 5, 0);
        gbc_fileNamePanel.fill = 1;
        gbc_fileNamePanel.gridx = 1;
        gbc_fileNamePanel.gridy = 3;
        this.conditionPanel.add((Component)this.fileNamePanel, gbc_fileNamePanel);
        GridBagLayout gbl_fileNamePanel = new GridBagLayout();
        gbl_fileNamePanel.columnWidths = new int[]{0, 0};
        gbl_fileNamePanel.rowHeights = new int[]{21};
        gbl_fileNamePanel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_fileNamePanel.rowWeights = new double[]{Double.MIN_VALUE};
        this.fileNamePanel.setLayout(gbl_fileNamePanel);
        this.fileNameTextField = new JTextField();
        GridBagConstraints gbc_fileNameTextField = new GridBagConstraints();
        gbc_fileNameTextField.weightx = 1.0;
        gbc_fileNameTextField.fill = 2;
        gbc_fileNameTextField.insets = new Insets(0, 0, 0, 5);
        gbc_fileNameTextField.gridx = 0;
        gbc_fileNameTextField.gridy = 0;
        this.fileNamePanel.add((Component)this.fileNameTextField, gbc_fileNameTextField);
        this.fileReferenceButton = new JButton(this.messages.getMessage("view.exportView.fileReferenceButton"));
        this.fileReferenceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportPolicyView.this.referenceFile();
            }
        });
        GridBagConstraints gbc_fileReferenceButton = new GridBagConstraints();
        gbc_fileReferenceButton.anchor = 18;
        gbc_fileReferenceButton.gridx = 1;
        gbc_fileReferenceButton.gridy = 0;
        this.fileNamePanel.add((Component)this.fileReferenceButton, gbc_fileReferenceButton);
        this.buttonPanel = new JPanel();
        GridBagConstraints gbc_buttonPanel = new GridBagConstraints();
        gbc_buttonPanel.insets = new Insets(0, 10, 10, 10);
        gbc_buttonPanel.fill = 1;
        gbc_buttonPanel.gridy = 2;
        gbc_buttonPanel.gridx = 0;
        this.getContentPane().add((Component)this.buttonPanel, gbc_buttonPanel);
        this.okButton = new JButton(this.messages.getMessage("view.exportView.okButton"));
        this.okButton.setPreferredSize(new Dimension(120, 32));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportPolicyView.this.ok();
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton = new JButton(this.messages.getMessage("view.exportView.cancelButton"));
        this.cancelButton.setPreferredSize(new Dimension(120, 32));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportPolicyView.this.cancel();
            }
        });
        this.buttonPanel.add(this.cancelButton);
    }

    private ExportPolicyView(MessageSourceAccessor mes) {
        this.messages = mes;
        this.init();
    }

    public void initData(String realmName, String groupName, String resourceUrl) {
        this.realmNameTextField.setText(realmName);
        this.groupNameTextField.setText(groupName);
        this.resourceUrlTextField.setText(resourceUrl);
        this.fileNameTextField.setText("");
    }

    private void referenceFile() {
        String fileName = this.fileNameTextField.getText();
        File file = new File(fileName);
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(file);
        fileChooser.setFileSelectionMode(0);
        FileNameExtensionFilter filter = new FileNameExtensionFilter(this.messages.getMessage("common.FileNameExtensionFilter.excel"), "xls");
        fileChooser.setFileFilter(filter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        int selected = fileChooser.showSaveDialog(this);
        if (selected == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            this.fileNameTextField.setText(selectedFile.getAbsolutePath());
        }
    }

    private void ok() {
        boolean mkdirsResult;
        int confirmResult;
        String extensionAppendedFileName;
        File file;
        String resourceUrl;
        String groupName;
        String fileName = this.fileNameTextField.getText();
        if (fileName.length() == 0) {
            MessageDialog.showMessage(this, "I-0401", new Object[0]);
            return;
        }
        String realmName = this.realmNameTextField.getText();
        if (realmName.length() == 0) {
            realmName = null;
        }
        if ((groupName = this.groupNameTextField.getText()).length() == 0) {
            groupName = null;
        }
        if ((resourceUrl = this.resourceUrlTextField.getText()).length() == 0) {
            resourceUrl = null;
        }
        if ((file = new File(extensionAppendedFileName = this.getExtensionAppendedFileName())).exists() && (confirmResult = MessageDialog.showConfirm(this, "C-0402", extensionAppendedFileName)) != 0) {
            return;
        }
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.exists() && !(mkdirsResult = parentFile.mkdirs())) {
            MessageDialog.showMessage(this, "E-0403", new Object[0]);
            return;
        }
        try {
            this.service.exportPolicy(realmName, groupName, resourceUrl, extensionAppendedFileName);
        }
        catch (Throwable e) {
            this.viewExceptionHandler.handle(e);
            return;
        }
        this.setVisible(false);
    }

    private void cancel() {
        this.setVisible(false);
    }

    private String getExtensionAppendedFileName() {
        String baseFileName = this.fileNameTextField.getText();
        String extension = FilenameUtils.getExtension((String)baseFileName);
        if (extension != null && extension.equalsIgnoreCase("xls")) {
            return baseFileName;
        }
        return baseFileName + "." + "xls";
    }
}

