/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.view.importpolicy;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.co.ogis_ri.citk.policytool.service.importpolicy.ImportPolicyService;
import jp.co.ogis_ri.citk.policytool.view.common.ViewExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.MessageSourceAccessor;

public class ImportPolicyView
extends JDialog {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ImportPolicyService service;
    private MessageSourceAccessor messages = null;
    private ViewExceptionHandler viewExceptionHandler = new ViewExceptionHandler();
    private JPanel fileNamePanel;
    private JLabel fileNameTitleLabel;
    private JTextField fileNameTextField;
    private JButton fileReferenceButton;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private boolean result;

    public void init() {
        this.setTitle(this.messages.getMessage("view.importView.title"));
        this.setSize(400, 170);
        this.setMinimumSize(new Dimension(400, 140));
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        this.fileNamePanel = new JPanel();
        GridBagConstraints gbc_fileNamePanel = new GridBagConstraints();
        gbc_fileNamePanel.weighty = 1.0;
        gbc_fileNamePanel.weightx = 1.0;
        gbc_fileNamePanel.insets = new Insets(10, 10, 5, 10);
        gbc_fileNamePanel.fill = 1;
        gbc_fileNamePanel.gridx = 0;
        gbc_fileNamePanel.gridy = 0;
        this.getContentPane().add((Component)this.fileNamePanel, gbc_fileNamePanel);
        GridBagLayout gbl_fileNamePanel = new GridBagLayout();
        gbl_fileNamePanel.columnWidths = new int[]{0, 0, 0, 0};
        gbl_fileNamePanel.rowHeights = new int[]{21, 0};
        gbl_fileNamePanel.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_fileNamePanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.fileNamePanel.setLayout(gbl_fileNamePanel);
        this.fileNameTitleLabel = new JLabel(this.messages.getMessage("view.importView.fileNamePanelLabel"));
        GridBagConstraints gbc_fileNameTitleLabel = new GridBagConstraints();
        gbc_fileNameTitleLabel.insets = new Insets(0, 0, 0, 5);
        gbc_fileNameTitleLabel.gridx = 0;
        gbc_fileNameTitleLabel.gridy = 0;
        this.fileNamePanel.add((Component)this.fileNameTitleLabel, gbc_fileNameTitleLabel);
        this.fileNameTextField = new JTextField();
        GridBagConstraints gbc_fileNameTextField = new GridBagConstraints();
        gbc_fileNameTextField.weightx = 1.0;
        gbc_fileNameTextField.fill = 2;
        gbc_fileNameTextField.insets = new Insets(0, 0, 0, 5);
        gbc_fileNameTextField.gridx = 1;
        gbc_fileNameTextField.gridy = 0;
        this.fileNamePanel.add((Component)this.fileNameTextField, gbc_fileNameTextField);
        this.fileReferenceButton = new JButton(this.messages.getMessage("view.importView.fileReferenceButton"));
        this.fileReferenceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportPolicyView.this.referenceFile();
            }
        });
        GridBagConstraints gbc_fileReferenceButton = new GridBagConstraints();
        gbc_fileReferenceButton.anchor = 18;
        gbc_fileReferenceButton.gridx = 2;
        gbc_fileReferenceButton.gridy = 0;
        this.fileNamePanel.add((Component)this.fileReferenceButton, gbc_fileReferenceButton);
        this.buttonPanel = new JPanel();
        GridBagConstraints gbc_buttonPanel = new GridBagConstraints();
        gbc_buttonPanel.insets = new Insets(0, 10, 10, 10);
        gbc_buttonPanel.fill = 1;
        gbc_buttonPanel.gridy = 1;
        gbc_buttonPanel.gridx = 0;
        this.getContentPane().add((Component)this.buttonPanel, gbc_buttonPanel);
        this.okButton = new JButton(this.messages.getMessage("view.importView.okButton"));
        this.okButton.setPreferredSize(new Dimension(120, 32));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportPolicyView.this.ok();
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton = new JButton(this.messages.getMessage("view.importView.cancelButton"));
        this.cancelButton.setPreferredSize(new Dimension(120, 32));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportPolicyView.this.cancel();
            }
        });
        this.buttonPanel.add(this.cancelButton);
    }

    private ImportPolicyView(MessageSourceAccessor mes) {
        this.messages = mes;
        this.init();
    }

    public void initData() {
        this.result = false;
        this.fileNameTextField.setText("");
    }

    private void referenceFile() {
        String fileName = this.fileNameTextField.getText();
        File file = new File(fileName);
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(file);
        fileChooser.setFileSelectionMode(0);
        FileNameExtensionFilter filter = new FileNameExtensionFilter(this.messages.getMessage("common.FileNameExtensionFilter.excel"), "xls");
        fileChooser.setFileFilter(filter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        int selected = fileChooser.showOpenDialog(this);
        if (selected == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            this.fileNameTextField.setText(selectedFile.getAbsolutePath());
        }
    }

    private void ok() {
        String fileName = this.fileNameTextField.getText() == null ? "" : this.fileNameTextField.getText().trim();
        try {
            this.service.importPolicy(fileName);
        }
        catch (Throwable e) {
            this.viewExceptionHandler.handle(e);
            return;
        }
        this.result = true;
        this.setVisible(false);
    }

    private void cancel() {
        this.result = false;
        this.setVisible(false);
    }

    public boolean isRefresh() {
        return this.result;
    }
}

