/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.view.policylist;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Referral;
import jp.co.ogis_ri.citk.policytool.service.policylist.PolicyListService;
import jp.co.ogis_ri.citk.policytool.service.policylist.model.PolicyView;
import jp.co.ogis_ri.citk.policytool.view.about.AboutView;
import jp.co.ogis_ri.citk.policytool.view.common.AutoCompleteDocumentListener;
import jp.co.ogis_ri.citk.policytool.view.common.JTableColumnWidthCalculator;
import jp.co.ogis_ri.citk.policytool.view.common.JTableUtil;
import jp.co.ogis_ri.citk.policytool.view.common.MessageDialog;
import jp.co.ogis_ri.citk.policytool.view.common.RealmComboBoxItem;
import jp.co.ogis_ri.citk.policytool.view.common.StringArrayTableCellRenderer;
import jp.co.ogis_ri.citk.policytool.view.exportpolicy.ExportPolicyView;
import jp.co.ogis_ri.citk.policytool.view.importpolicy.ImportPolicyView;
import jp.co.ogis_ri.citk.policytool.view.policylist.GroupComboBoxItem;
import jp.co.ogis_ri.citk.policytool.view.policyset.PolicySetView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.MessageSourceAccessor;

public class PolicyListView
extends JFrame {
    private static final long serialVersionUID = 1L;
    private MessageSourceAccessor messages = null;
    @Autowired
    private PolicySetView policySetView = null;
    @Autowired
    private ImportPolicyView importPolicyView = null;
    @Autowired
    private ExportPolicyView exportView = null;
    @Autowired
    private AboutView aboutView = null;
    @Autowired
    private PolicyListService service = null;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu toolMenu;
    private JMenuItem importMenuItem;
    private JMenuItem exportMenuItem;
    private JMenuItem quit;
    private JMenu helpMenu;
    private JMenuItem aboutMenuItem;
    private JPanel mainPanel;
    private JScrollPane policyTableScrollPane;
    private JTable policyTable;
    private JPanel searchPanel;
    private JPanel searchContentPanel;
    private JLabel realmLabel;
    private JComboBox realmComboBox;
    private JLabel groupLabel;
    private JComboBox groupComboBox;
    private JLabel resourceLabel;
    private JComboBox resourceComboBox;
    private JButton searchButton;
    private JLabel searchPanelLabel;
    private JPanel actionButtonsPanel;
    private JButton addButton;
    private JButton modifyButton;
    private JButton deleteButton;
    private JButton refreshButton;
    private TableColumn modelColumn;

    public void init() {
        this.setSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(800, 600));
        this.setLocationRelativeTo(null);
        this.setTitle(this.messages.getMessage("view.policyList.title"));
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                PolicyListView.this.refresh();
                JTableColumnWidthCalculator policyTableCalculator = new JTableColumnWidthCalculator(PolicyListView.this.policyTable);
                policyTableCalculator.setAutomatically();
            }
        });
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{792, 0};
        gridBagLayout.rowHeights = new int[]{30, 544, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu(this.messages.getMessage("view.policyList.fileMenuTitle"));
        this.fileMenu.setMnemonic(70);
        this.quit = new JMenuItem(this.messages.getMessage("view.policyList.quitMenuButton"));
        this.quit.setMnemonic(88);
        this.quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.fileMenu.add(this.quit);
        this.menuBar.add(this.fileMenu);
        this.toolMenu = new JMenu(this.messages.getMessage("view.policyList.toolMenuTitle"));
        this.toolMenu.setMnemonic(84);
        this.importMenuItem = new JMenuItem(this.messages.getMessage("view.policyList.importMenuButton"));
        this.importMenuItem.setMnemonic(73);
        this.importMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyListView.this.importPolicy();
            }
        });
        this.toolMenu.add(this.importMenuItem);
        this.exportMenuItem = new JMenuItem(this.messages.getMessage("view.policyList.exportMenuButton"));
        this.exportMenuItem.setMnemonic(69);
        this.exportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyListView.this.exportPolicy();
            }
        });
        this.toolMenu.add(this.exportMenuItem);
        this.menuBar.add(this.toolMenu);
        this.helpMenu = new JMenu(this.messages.getMessage("view.policyList.helpMenuTitle"));
        this.helpMenu.setMnemonic(72);
        JMenuItem communityMenuItem = new JMenuItem(this.messages.getMessage("view.policyList.communityMenuItem"));
        communityMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(URI.create("http://sourceforge.jp/projects/citk/"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.helpMenu.add(communityMenuItem);
        this.helpMenu.addSeparator();
        this.aboutMenuItem = new JMenuItem(this.messages.getMessage("view.policyList.aboutMenuButton"));
        this.aboutMenuItem.setMnemonic(86);
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyListView.this.about();
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        GridBagConstraints gbc_menuBar = new GridBagConstraints();
        gbc_menuBar.weightx = 1.0;
        gbc_menuBar.fill = 1;
        gbc_menuBar.gridx = 0;
        gbc_menuBar.gridy = 0;
        this.getContentPane().add((Component)this.menuBar, gbc_menuBar);
        this.mainPanel = new JPanel();
        GridBagConstraints gbc_mainPanel = new GridBagConstraints();
        gbc_mainPanel.insets = new Insets(5, 5, 5, 5);
        gbc_mainPanel.fill = 1;
        gbc_mainPanel.weightx = 1.0;
        gbc_mainPanel.weighty = 1.0;
        gbc_mainPanel.gridx = 0;
        gbc_mainPanel.gridy = 1;
        this.getContentPane().add((Component)this.mainPanel, gbc_mainPanel);
        GridBagLayout gbl_mainPanel = new GridBagLayout();
        gbl_mainPanel.columnWidths = new int[]{0, 0};
        gbl_mainPanel.rowHeights = new int[]{0, 0, 0, 0};
        gbl_mainPanel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_mainPanel.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.mainPanel.setLayout(gbl_mainPanel);
        this.policyTableScrollPane = new JScrollPane();
        this.policyTableScrollPane.setViewportBorder(new EtchedBorder(1, null, null));
        this.policyTable = new JTable();
        this.policyTable.setFocusable(false);
        this.policyTable.setFocusTraversalKeysEnabled(false);
        this.policyTable.setBorder(new EtchedBorder(1, null, null));
        this.policyTable.setSelectionMode(0);
        this.policyTable.setModel(new DefaultTableModel(new Object[0][], new String[]{this.messages.getMessage("view.policyList.tableRealmTitle"), this.messages.getMessage("view.policyList.tablePolicyTitle"), this.messages.getMessage("view.policyList.tableResourceTitle"), this.messages.getMessage("view.policyList.tableSubjectTitle"), ""}){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        });
        this.policyTable.setAutoResizeMode(0);
        this.policyTable.getTableHeader().setReorderingAllowed(false);
        TableColumnModel policyTableColumnModel = this.policyTable.getColumnModel();
        TableColumn personColumn = policyTableColumnModel.getColumn(0);
        DefaultTableCellRenderer personColumnCellRenderer = new DefaultTableCellRenderer();
        personColumnCellRenderer.setVerticalAlignment(1);
        personColumn.setCellRenderer(personColumnCellRenderer);
        TableColumn applicationIDColumn = policyTableColumnModel.getColumn(1);
        DefaultTableCellRenderer applicationIDColumnCellRenderer = new DefaultTableCellRenderer();
        applicationIDColumnCellRenderer.setVerticalAlignment(1);
        applicationIDColumn.setCellRenderer(applicationIDColumnCellRenderer);
        TableColumn policyTableUrlColumn = policyTableColumnModel.getColumn(2);
        policyTableUrlColumn.setCellRenderer(new StringArrayTableCellRenderer());
        TableColumn policyTableRoleColumn = policyTableColumnModel.getColumn(3);
        policyTableRoleColumn.setCellRenderer(new StringArrayTableCellRenderer());
        this.modelColumn = policyTableColumnModel.getColumn(4);
        this.policyTable.removeColumn(this.modelColumn);
        this.searchPanel = new JPanel();
        GridBagLayout gbl_policySearchPanel = new GridBagLayout();
        gbl_policySearchPanel.columnWidths = new int[]{0, 0};
        gbl_policySearchPanel.rowHeights = new int[]{0, 0, 0};
        gbl_policySearchPanel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_policySearchPanel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.searchPanel.setLayout(gbl_policySearchPanel);
        this.searchContentPanel = new JPanel();
        this.searchContentPanel.setBorder(new EtchedBorder(1, null, null));
        GridBagLayout gbl_policyListSearch = new GridBagLayout();
        gbl_policyListSearch.columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        gbl_policyListSearch.rowHeights = new int[]{22, 0};
        gbl_policyListSearch.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_policyListSearch.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.searchContentPanel.setLayout(gbl_policyListSearch);
        this.resourceComboBox = new JComboBox();
        this.resourceComboBox.setFont(new Font("MS UI Gothic", 0, 12));
        this.resourceComboBox.setPreferredSize(new Dimension(192, 22));
        this.resourceComboBox.setModel(new DefaultComboBoxModel<String>(new String[0]));
        this.resourceComboBox.setEditable(true);
        JTextField resourceComboBoxTextEditor = (JTextField)this.resourceComboBox.getEditor().getEditorComponent();
        Document resourceComboBoxDocument = resourceComboBoxTextEditor.getDocument();
        this.realmComboBox = new JComboBox();
        this.realmComboBox.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
        this.realmComboBox.setFont(new Font("MS UI Gothic", 0, 12));
        this.realmComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RealmComboBoxItem selectedItem = (RealmComboBoxItem)e.getItem();
                PolicyListView.this.setGroupComboBox(selectedItem);
                PolicyListView.this.setReferralComboBox(selectedItem);
            }
        });
        this.realmLabel = new JLabel(this.messages.getMessage("view.policyList.listRealmTitle"));
        this.realmLabel.setFont(new Font("MS UI Gothic", 0, 12));
        GridBagConstraints gbc_RealmListName = new GridBagConstraints();
        gbc_RealmListName.insets = new Insets(0, 0, 0, 5);
        gbc_RealmListName.gridx = 0;
        gbc_RealmListName.gridy = 0;
        this.searchContentPanel.add((Component)this.realmLabel, gbc_RealmListName);
        GridBagConstraints gbc_realmListComboBox = new GridBagConstraints();
        gbc_realmListComboBox.fill = 2;
        gbc_realmListComboBox.weightx = 0.5;
        gbc_realmListComboBox.insets = new Insets(0, 0, 0, 5);
        gbc_realmListComboBox.gridx = 1;
        gbc_realmListComboBox.gridy = 0;
        this.searchContentPanel.add((Component)this.realmComboBox, gbc_realmListComboBox);
        this.groupLabel = new JLabel(this.messages.getMessage("view.policyList.listGroupTitle"));
        this.groupLabel.setFont(new Font("MS UI Gothic", 0, 12));
        GridBagConstraints gbc_GroupListName = new GridBagConstraints();
        gbc_GroupListName.insets = new Insets(0, 0, 0, 5);
        gbc_GroupListName.gridx = 2;
        gbc_GroupListName.gridy = 0;
        this.searchContentPanel.add((Component)this.groupLabel, gbc_GroupListName);
        this.groupComboBox = new JComboBox();
        this.groupComboBox.setModel(new DefaultComboBoxModel<String>(new String[0]));
        this.groupComboBox.setFont(new Font("MS UI Gothic", 0, 12));
        GridBagConstraints gbc_groupListComboBox = new GridBagConstraints();
        gbc_groupListComboBox.fill = 2;
        gbc_groupListComboBox.weightx = 0.5;
        gbc_groupListComboBox.insets = new Insets(0, 0, 0, 5);
        gbc_groupListComboBox.gridx = 3;
        gbc_groupListComboBox.gridy = 0;
        this.searchContentPanel.add((Component)this.groupComboBox, gbc_groupListComboBox);
        this.resourceLabel = new JLabel(this.messages.getMessage("view.policyList.resourceTitle"));
        this.resourceLabel.setFont(new Font("MS UI Gothic", 0, 12));
        GridBagConstraints gbc_resourceName = new GridBagConstraints();
        gbc_resourceName.insets = new Insets(0, 0, 0, 5);
        gbc_resourceName.gridx = 4;
        gbc_resourceName.gridy = 0;
        this.searchContentPanel.add((Component)this.resourceLabel, gbc_resourceName);
        resourceComboBoxDocument.addDocumentListener(new AutoCompleteDocumentListener(this.resourceComboBox));
        GridBagConstraints gbc_resourceComboBox = new GridBagConstraints();
        gbc_resourceComboBox.fill = 2;
        gbc_resourceComboBox.weightx = 1.0;
        gbc_resourceComboBox.insets = new Insets(0, 0, 0, 5);
        gbc_resourceComboBox.gridx = 5;
        gbc_resourceComboBox.gridy = 0;
        this.searchContentPanel.add((Component)this.resourceComboBox, gbc_resourceComboBox);
        this.searchButton = new JButton(this.messages.getMessage("view.policyList.search"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyListView.this.search();
            }
        });
        this.searchButton.setHorizontalTextPosition(0);
        GridBagConstraints gbc_SearchButton = new GridBagConstraints();
        gbc_SearchButton.insets = new Insets(5, 0, 5, 3);
        gbc_SearchButton.gridx = 6;
        gbc_SearchButton.gridy = 0;
        this.searchContentPanel.add((Component)this.searchButton, gbc_SearchButton);
        this.searchPanelLabel = new JLabel(this.messages.getMessage("view.policyList.searchAreaTitle"));
        this.searchPanelLabel.setAlignmentX(0.5f);
        this.searchPanelLabel.setHorizontalTextPosition(0);
        this.searchPanelLabel.setHorizontalAlignment(0);
        GridBagConstraints gbc_policySearchPanelTitle = new GridBagConstraints();
        gbc_policySearchPanelTitle.weightx = 1.0;
        gbc_policySearchPanelTitle.gridx = 0;
        gbc_policySearchPanelTitle.gridy = 0;
        this.searchPanel.add((Component)this.searchPanelLabel, gbc_policySearchPanelTitle);
        GridBagConstraints gbc_policyListSearch = new GridBagConstraints();
        gbc_policyListSearch.fill = 1;
        gbc_policyListSearch.weightx = 1.0;
        gbc_policyListSearch.gridx = 0;
        gbc_policyListSearch.gridy = 1;
        this.searchPanel.add((Component)this.searchContentPanel, gbc_policyListSearch);
        GridBagConstraints gbc_policySearchPanel = new GridBagConstraints();
        gbc_policySearchPanel.insets = new Insets(0, 0, 5, 0);
        gbc_policySearchPanel.weightx = 1.0;
        gbc_policySearchPanel.fill = 1;
        gbc_policySearchPanel.gridx = 0;
        gbc_policySearchPanel.gridy = 0;
        this.mainPanel.add((Component)this.searchPanel, gbc_policySearchPanel);
        this.policyTableScrollPane.setViewportView(this.policyTable);
        GridBagConstraints gbc_policyListTable = new GridBagConstraints();
        gbc_policyListTable.insets = new Insets(0, 0, 5, 0);
        gbc_policyListTable.weightx = 1.0;
        gbc_policyListTable.weighty = 1.0;
        gbc_policyListTable.fill = 1;
        gbc_policyListTable.gridx = 0;
        gbc_policyListTable.gridy = 1;
        this.mainPanel.add((Component)this.policyTableScrollPane, gbc_policyListTable);
        this.actionButtonsPanel = new JPanel();
        this.actionButtonsPanel.setBorder(null);
        this.addButton = new JButton(this.messages.getMessage("view.policyList.addPolicy"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyListView.this.add();
            }
        });
        this.actionButtonsPanel.add(this.addButton);
        this.modifyButton = new JButton(this.messages.getMessage("view.policyList.modPolicy"));
        this.modifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyListView.this.modify();
            }
        });
        this.actionButtonsPanel.add(this.modifyButton);
        this.deleteButton = new JButton(this.messages.getMessage("view.policyList.delPolicy"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyListView.this.delete();
            }
        });
        this.actionButtonsPanel.add(this.deleteButton);
        this.refreshButton = new JButton(this.messages.getMessage("view.policyList.refresh"));
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyListView.this.wrapRefresh();
            }
        });
        this.actionButtonsPanel.add(this.refreshButton);
        GridBagConstraints gbc_policyListAction = new GridBagConstraints();
        gbc_policyListAction.fill = 1;
        gbc_policyListAction.weightx = 1.0;
        gbc_policyListAction.gridx = 0;
        gbc_policyListAction.gridy = 2;
        this.mainPanel.add((Component)this.actionButtonsPanel, gbc_policyListAction);
    }

    private PolicyListView(MessageSourceAccessor mes) {
        this.messages = mes;
        this.init();
    }

    private void importPolicy() {
        this.importPolicyView.initData();
        this.importPolicyView.setModal(true);
        this.importPolicyView.setVisible(true);
        if (this.importPolicyView.isRefresh()) {
            this.refresh();
        }
    }

    private void exportPolicy() {
        RealmComboBoxItem selectedRealmItem = (RealmComboBoxItem)this.realmComboBox.getSelectedItem();
        GroupComboBoxItem selectedGroupItem = (GroupComboBoxItem)this.groupComboBox.getSelectedItem();
        String selectedResourceItem = (String)this.resourceComboBox.getSelectedItem();
        String selectedRealmName = selectedRealmItem.getRealmModel() == null ? null : selectedRealmItem.getRealmName();
        String selectedGroupName = selectedGroupItem.getGroupName();
        String selectedResourceUrl = selectedResourceItem.trim();
        if (selectedResourceUrl.length() == 0) {
            selectedResourceUrl = null;
        }
        this.exportView.initData(selectedRealmName, selectedGroupName, selectedResourceUrl);
        this.exportView.setModal(true);
        this.exportView.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add() {
        try {
            this.startEvent();
            this.policySetView.initData();
            this.policySetView.setModal(true);
            this.policySetView.setVisible(true);
            if (this.policySetView.getResult()) {
                this.search();
            }
        }
        finally {
            this.endEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modify() {
        try {
            this.startEvent();
            if (this.policyTable.getSelectedRow() == -1) {
                MessageDialog.showMessage(this, "I-0101", new Object[0]);
            } else {
                this.policyTable.addColumn(this.modelColumn);
                Policy selectedPolicy = (Policy)this.policyTable.getValueAt(this.policyTable.getSelectedRow(), 4);
                this.policySetView.initData(selectedPolicy);
                this.policyTable.removeColumn(this.modelColumn);
                this.policySetView.setModal(true);
                this.policySetView.setVisible(true);
                if (this.policySetView.getResult()) {
                    this.search();
                }
            }
        }
        finally {
            this.endEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete() {
        try {
            this.startEvent();
            if (this.policyTable.getSelectedRow() == -1) {
                MessageDialog.showMessage(this, "I-0101", new Object[0]);
            } else {
                this.policyTable.addColumn(this.modelColumn);
                Policy policy = (Policy)this.policyTable.getValueAt(this.policyTable.getSelectedRow(), 4);
                this.policyTable.removeColumn(this.modelColumn);
                Object[] args = new Object[]{policy.getRealmName(), policy.getPolicyName()};
                int confirmResult = MessageDialog.showConfirm(this, "C-0102", args);
                if (confirmResult == 0) {
                    this.service.delete(policy);
                    this.refresh();
                    this.search();
                }
            }
        }
        finally {
            this.endEvent();
        }
    }

    private void about() {
        this.aboutView.setModal(true);
        this.aboutView.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapRefresh() {
        try {
            this.startEvent();
            this.refresh();
        }
        finally {
            this.endEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        try {
            this.service.refresh();
        }
        finally {
            this.setRealmComboBox();
            DefaultTableModel policyTableModel = (DefaultTableModel)this.policyTable.getModel();
            policyTableModel.setRowCount(0);
        }
    }

    private void setRealmComboBox() {
        this.realmComboBox.setVisible(false);
        List<Realm> realms = this.service.findRealms();
        this.realmComboBox.removeAllItems();
        this.realmComboBox.addItem(RealmComboBoxItem.ALL_REALM);
        for (Realm realm : realms) {
            this.realmComboBox.addItem(new RealmComboBoxItem(realm.getRealmName(), realm));
        }
        this.realmComboBox.setSelectedItem(RealmComboBoxItem.ALL_REALM);
        this.realmComboBox.setVisible(true);
    }

    private void setGroupComboBox(RealmComboBoxItem realmItem) {
        this.groupComboBox.setVisible(false);
        List<String> groupList = this.service.findGroupNames(realmItem.getRealmModel());
        this.groupComboBox.removeAllItems();
        this.groupComboBox.addItem(new GroupComboBoxItem(null, null));
        for (String groupName : groupList) {
            GroupComboBoxItem groupItem = new GroupComboBoxItem(groupName, groupName);
            this.groupComboBox.addItem(groupItem);
        }
        this.groupComboBox.setVisible(true);
    }

    private void setReferralComboBox(RealmComboBoxItem realmItem) {
        this.resourceComboBox.setVisible(false);
        List<Referral> referrals = this.service.findReferrals(realmItem.getRealmModel());
        this.resourceComboBox.removeAllItems();
        this.resourceComboBox.addItem("");
        for (Referral referral : referrals) {
            this.resourceComboBox.addItem(referral.getRefpolicy());
        }
        this.resourceComboBox.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search() {
        try {
            this.startEvent();
            RealmComboBoxItem selectedRealmItem = (RealmComboBoxItem)this.realmComboBox.getSelectedItem();
            GroupComboBoxItem selectedGroupItem = (GroupComboBoxItem)this.groupComboBox.getSelectedItem();
            String selectedResourceItem = (String)this.resourceComboBox.getSelectedItem();
            String selectedRealmName = selectedRealmItem.getRealmModel() == null ? null : selectedRealmItem.getRealmName();
            String selectedGroupName = selectedGroupItem.getGroupName();
            String selectedResourceUrl = selectedResourceItem.trim();
            if (selectedResourceUrl.length() == 0) {
                selectedResourceUrl = null;
            }
            List<PolicyView> resultPolicyList = this.service.findPolicies(selectedRealmName, selectedGroupName, selectedResourceUrl);
            this.setDataToPolicyTable(resultPolicyList);
            JTableColumnWidthCalculator policyTableCalculator = new JTableColumnWidthCalculator(this.policyTable);
            policyTableCalculator.setAutomatically();
        }
        finally {
            this.endEvent();
        }
    }

    private void setDataToPolicyTable(List<PolicyView> policyList) {
        this.policyTable.setVisible(false);
        this.policyTable.addColumn(this.modelColumn);
        DefaultTableModel policyTableModel = (DefaultTableModel)this.policyTable.getModel();
        policyTableModel.setRowCount(0);
        for (PolicyView policy : policyList) {
            Object[] rowDataArray = new Object[]{policy.getRealmName(), policy.getPolicyName(), policy.getResourceUrls(), policy.getSubjects(), policy.getPolicy()};
            policyTableModel.addRow(rowDataArray);
        }
        this.policyTable.removeColumn(this.modelColumn);
        JTableUtil.refreshTableRowHeight(this.policyTable);
        this.policyTable.setVisible(true);
    }

    private void startEvent() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.searchButton.setEnabled(false);
        this.addButton.setEnabled(false);
        this.modifyButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
    }

    private void endEvent() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.searchButton.setEnabled(true);
        this.addButton.setEnabled(true);
        this.modifyButton.setEnabled(true);
        this.deleteButton.setEnabled(true);
        this.refreshButton.setEnabled(true);
    }
}

