/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.view.policyset;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import javax.validation.ConstraintViolation;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Resource;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Subject;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Group;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Referral;
import jp.co.ogis_ri.citk.policytool.service.policyset.PolicySetMode;
import jp.co.ogis_ri.citk.policytool.service.policyset.PolicySetService;
import jp.co.ogis_ri.citk.policytool.view.common.AutoCompleteDocumentListener;
import jp.co.ogis_ri.citk.policytool.view.common.ComboBoxTableCellEditor;
import jp.co.ogis_ri.citk.policytool.view.common.ComboBoxTableCellRenderer;
import jp.co.ogis_ri.citk.policytool.view.common.JTableColumnWidthCalculator;
import jp.co.ogis_ri.citk.policytool.view.common.MessageDialog;
import jp.co.ogis_ri.citk.policytool.view.common.RealmComboBoxItem;
import jp.co.ogis_ri.citk.policytool.view.common.ViewExceptionHandler;
import jp.co.ogis_ri.citk.policytool.view.policyset.PermitComboBoxItem;
import jp.co.ogis_ri.citk.policytool.view.policyset.PolicySetViewPermitUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.MessageSourceAccessor;

public class PolicySetView
extends JDialog {
    private static final int INITIAL_WIDTH = 800;
    private static final int INITIAL_HEIGHT = 600;
    private static final int CHECK_BOX_TABLE_COLUMN_WIDTH = 21;
    private static final long serialVersionUID = 1L;
    @Autowired
    private PolicySetService service = null;
    private MessageSourceAccessor messages = null;
    private ViewExceptionHandler viewExceptionHandler = new ViewExceptionHandler();
    private boolean result;
    private JPanel mainPanel;
    private JPanel titlePanel;
    private JLabel titleRealmTitleLabel;
    private JComboBox titleRealmComboBox;
    private JLabel titleRealmNameLabel;
    private JLabel titleRealmDummyLabel;
    private JLabel titlePolicyTitleLabel;
    private JTextField titlePolicyTextField;
    private JLabel titlePolicyNameLabel;
    private JTabbedPane ruleTabbedPane;
    private JPanel ruleListPanel;
    private JPanel ruleListTitlePanel;
    private JPanel ruleAddPanel;
    private JButton ruleRemoveButton;
    private JLabel resourceTitleLabel;
    private JPanel requestPanel;
    private JLabel requestTitleLabel;
    private JLabel getRequestTitleLabel;
    private JComboBox getRequestComboBox;
    private JLabel postRequestTitleLabel;
    private JComboBox postRequestComboBox;
    private JComboBox resourceComboBox;
    private JButton ruleAddButton;
    private JPanel ruleListTablePanel;
    private JLabel ruleListTableTitleLabel;
    private JScrollPane ruleListTableScrollPane;
    private JTable ruleListTable;
    private JPanel ruleModifyPanel;
    private JPanel ruleModifyTablePanel;
    private JLabel ruleModifyTableTitleLabel;
    private JScrollPane ruleModifyTableScrollPane;
    private JTable ruleModifyTable;
    private JPanel groupPanel;
    private JLabel groupTitleLabel;
    private JScrollPane groupScrollPane;
    private JTable groupTable;
    private JPanel actionButtonsPanel;
    private JButton okButton;
    private JButton cancelButton;
    private TableColumn groupModelColumn;
    private PolicySetMode mode;
    private Policy targetPolicy;

    public void init() {
        this.setTitle(this.messages.getMessage("view.policySet.title"));
        this.setSize(800, 600);
        this.setMinimumSize(new Dimension(800, 600));
        this.setLocationRelativeTo(null);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{792, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        this.mainPanel = new JPanel();
        GridBagConstraints gbc_PolicySetRule = new GridBagConstraints();
        gbc_PolicySetRule.insets = new Insets(5, 5, 5, 5);
        gbc_PolicySetRule.weighty = 1.0;
        gbc_PolicySetRule.weightx = 1.0;
        gbc_PolicySetRule.fill = 1;
        gbc_PolicySetRule.gridx = 0;
        gbc_PolicySetRule.gridy = 0;
        this.getContentPane().add((Component)this.mainPanel, gbc_PolicySetRule);
        GridBagLayout gbl_PolicySetRule = new GridBagLayout();
        gbl_PolicySetRule.columnWidths = new int[]{800, 0};
        gbl_PolicySetRule.rowHeights = new int[]{0, 0, 0};
        gbl_PolicySetRule.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_PolicySetRule.rowWeights = new double[]{0.0, 0.0, 0.0};
        this.mainPanel.setLayout(gbl_PolicySetRule);
        this.titlePanel = new JPanel();
        GridBagConstraints gbc_PolicySetTitle = new GridBagConstraints();
        gbc_PolicySetTitle.insets = new Insets(0, 0, 5, 0);
        gbc_PolicySetTitle.weightx = 1.0;
        gbc_PolicySetTitle.fill = 1;
        gbc_PolicySetTitle.gridx = 0;
        gbc_PolicySetTitle.gridy = 0;
        this.mainPanel.add((Component)this.titlePanel, gbc_PolicySetTitle);
        this.titleRealmTitleLabel = new JLabel(this.messages.getMessage("view.policySet.realmTitle"));
        this.titlePanel.add(this.titleRealmTitleLabel);
        this.titleRealmComboBox = new JComboBox();
        this.titleRealmComboBox.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
        this.titleRealmComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RealmComboBoxItem selectedItem = (RealmComboBoxItem)e.getItem();
                PolicySetView.this.wrapSetGroupTable(selectedItem);
                PolicySetView.this.wrapSetResourceComboBox(selectedItem);
                PolicySetView.this.clearRule();
            }
        });
        this.titlePanel.add(this.titleRealmComboBox);
        this.titleRealmNameLabel = new JLabel();
        this.titleRealmNameLabel.setVisible(false);
        this.titlePanel.add(this.titleRealmNameLabel);
        this.titleRealmDummyLabel = new JLabel();
        this.titleRealmDummyLabel.setVisible(false);
        this.titleRealmDummyLabel.setPreferredSize(new Dimension(9, 10));
        this.titlePanel.add(this.titleRealmDummyLabel);
        this.titlePolicyTitleLabel = new JLabel(this.messages.getMessage("view.policySet.policyTitle"));
        this.titlePanel.add(this.titlePolicyTitleLabel);
        this.titlePolicyTextField = new JTextField();
        this.titlePolicyTextField.setText("");
        this.titlePolicyTextField.setColumns(10);
        this.titlePanel.add(this.titlePolicyTextField);
        this.titlePolicyNameLabel = new JLabel();
        this.titlePolicyNameLabel.setVisible(false);
        this.titlePanel.add(this.titlePolicyNameLabel);
        this.ruleTabbedPane = new JTabbedPane(1);
        this.ruleTabbedPane.setToolTipText("");
        this.ruleTabbedPane.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.ruleTabbedPane.setBorder(null);
        GridBagConstraints gbc_RuleTab = new GridBagConstraints();
        gbc_RuleTab.insets = new Insets(0, 0, 5, 0);
        gbc_RuleTab.weightx = 1.0;
        gbc_RuleTab.weighty = 1.0;
        gbc_RuleTab.fill = 1;
        gbc_RuleTab.gridx = 0;
        gbc_RuleTab.gridy = 1;
        this.mainPanel.add((Component)this.ruleTabbedPane, gbc_RuleTab);
        this.ruleListPanel = new JPanel();
        this.ruleTabbedPane.addTab(this.messages.getMessage("view.policySet.policyListTab.title"), null, this.ruleListPanel, null);
        GridBagLayout gbl_RuleListTab = new GridBagLayout();
        gbl_RuleListTab.columnWidths = new int[]{0, 0};
        gbl_RuleListTab.rowHeights = new int[]{0, 0, 0};
        gbl_RuleListTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_RuleListTab.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.ruleListPanel.setLayout(gbl_RuleListTab);
        this.ruleListTitlePanel = new JPanel();
        GridBagConstraints gbc_RuleListTitlePanel = new GridBagConstraints();
        gbc_RuleListTitlePanel.ipadx = 90;
        gbc_RuleListTitlePanel.insets = new Insets(5, 0, 0, 0);
        gbc_RuleListTitlePanel.weightx = 1.0;
        gbc_RuleListTitlePanel.fill = 2;
        gbc_RuleListTitlePanel.gridx = 0;
        gbc_RuleListTitlePanel.gridy = 0;
        this.ruleListPanel.add((Component)this.ruleListTitlePanel, gbc_RuleListTitlePanel);
        GridBagLayout gbl_ruleListTitlePanel = new GridBagLayout();
        gbl_ruleListTitlePanel.columnWidths = new int[]{598, 0, 0};
        gbl_ruleListTitlePanel.rowHeights = new int[]{47, 0};
        gbl_ruleListTitlePanel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_ruleListTitlePanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.ruleListTitlePanel.setLayout(gbl_ruleListTitlePanel);
        this.ruleAddPanel = new JPanel();
        this.ruleAddPanel.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_ruleAddPanel = new GridBagConstraints();
        gbc_ruleAddPanel.fill = 2;
        gbc_ruleAddPanel.weightx = 1.0;
        gbc_ruleAddPanel.insets = new Insets(0, 0, 0, 5);
        gbc_ruleAddPanel.gridx = 0;
        gbc_ruleAddPanel.gridy = 0;
        this.ruleListTitlePanel.add((Component)this.ruleAddPanel, gbc_ruleAddPanel);
        this.ruleRemoveButton = new JButton(this.messages.getMessage("view.policySet.policyListTab.removeButton"));
        this.ruleRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicySetView.this.removeRule();
            }
        });
        GridBagConstraints gbc_ruleRemoveButton = new GridBagConstraints();
        gbc_ruleRemoveButton.insets = new Insets(0, 0, 0, 5);
        gbc_ruleRemoveButton.gridx = 1;
        gbc_ruleRemoveButton.gridy = 0;
        this.ruleListTitlePanel.add((Component)this.ruleRemoveButton, gbc_ruleRemoveButton);
        GridBagLayout gbl_ruleAddPanel = new GridBagLayout();
        gbl_ruleAddPanel.columnWidths = new int[]{36, 0, 0, 0, 0};
        gbl_ruleAddPanel.rowHeights = new int[]{33, 0};
        gbl_ruleAddPanel.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_ruleAddPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.ruleAddPanel.setLayout(gbl_ruleAddPanel);
        this.resourceTitleLabel = new JLabel(this.messages.getMessage("view.policySet.resourceTitle"));
        GridBagConstraints gbc_resourceTitleLabel = new GridBagConstraints();
        gbc_resourceTitleLabel.anchor = 17;
        gbc_resourceTitleLabel.insets = new Insets(0, 0, 0, 5);
        gbc_resourceTitleLabel.gridx = 0;
        gbc_resourceTitleLabel.gridy = 0;
        this.ruleAddPanel.add((Component)this.resourceTitleLabel, gbc_resourceTitleLabel);
        this.resourceComboBox = new JComboBox();
        this.resourceComboBox.setPreferredSize(new Dimension(200, 30));
        this.resourceComboBox.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
        this.resourceComboBox.setEditable(true);
        JTextField resourceComboBoxTextEditor = (JTextField)this.resourceComboBox.getEditor().getEditorComponent();
        Document document = resourceComboBoxTextEditor.getDocument();
        document.addDocumentListener(new AutoCompleteDocumentListener(this.resourceComboBox));
        GridBagConstraints gbc_resourceComboBox = new GridBagConstraints();
        gbc_resourceComboBox.weightx = 1.0;
        gbc_resourceComboBox.fill = 2;
        gbc_resourceComboBox.insets = new Insets(0, 0, 0, 5);
        gbc_resourceComboBox.gridx = 1;
        gbc_resourceComboBox.gridy = 0;
        this.ruleAddPanel.add((Component)this.resourceComboBox, gbc_resourceComboBox);
        this.requestPanel = new JPanel();
        this.requestPanel.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_requestPanel = new GridBagConstraints();
        gbc_requestPanel.insets = new Insets(0, 0, 0, 5);
        gbc_requestPanel.gridx = 2;
        gbc_requestPanel.gridy = 0;
        this.ruleAddPanel.add((Component)this.requestPanel, gbc_requestPanel);
        this.requestTitleLabel = new JLabel();
        this.requestTitleLabel.setText(this.messages.getMessage("view.policySet.policyListTab.methodTitle"));
        this.requestPanel.add(this.requestTitleLabel);
        this.getRequestTitleLabel = new JLabel();
        this.getRequestTitleLabel.setText(this.messages.getMessage("view.policySet.policyListTab.getTitle"));
        this.requestPanel.add(this.getRequestTitleLabel);
        this.getRequestComboBox = new JComboBox();
        this.getRequestComboBox.setModel(new DefaultComboBoxModel<PermitComboBoxItem>(new PermitComboBoxItem[]{new PermitComboBoxItem(PermitComboBoxItem.Type.NONE, this.messages.getMessage("view.policySet.permitComboBox.none")), new PermitComboBoxItem(PermitComboBoxItem.Type.ALLOW, this.messages.getMessage("view.policySet.permitComboBox.allow")), new PermitComboBoxItem(PermitComboBoxItem.Type.DENY, this.messages.getMessage("view.policySet.permitComboBox.deny"))}));
        this.requestPanel.add(this.getRequestComboBox);
        this.postRequestTitleLabel = new JLabel();
        this.postRequestTitleLabel.setText(this.messages.getMessage("view.policySet.policyListTab.postTitle"));
        this.requestPanel.add(this.postRequestTitleLabel);
        this.postRequestComboBox = new JComboBox();
        this.postRequestComboBox.setModel(new DefaultComboBoxModel<PermitComboBoxItem>(new PermitComboBoxItem[]{new PermitComboBoxItem(PermitComboBoxItem.Type.NONE, this.messages.getMessage("view.policySet.permitComboBox.none")), new PermitComboBoxItem(PermitComboBoxItem.Type.ALLOW, this.messages.getMessage("view.policySet.permitComboBox.allow")), new PermitComboBoxItem(PermitComboBoxItem.Type.DENY, this.messages.getMessage("view.policySet.permitComboBox.deny"))}));
        this.requestPanel.add(this.postRequestComboBox);
        this.ruleAddButton = new JButton(this.messages.getMessage("view.policySet.policyListTab.addButton"));
        this.ruleAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicySetView.this.addRule();
            }
        });
        GridBagConstraints gbc_ruleAddButton = new GridBagConstraints();
        gbc_ruleAddButton.insets = new Insets(0, 0, 0, 5);
        gbc_ruleAddButton.gridx = 3;
        gbc_ruleAddButton.gridy = 0;
        this.ruleAddPanel.add((Component)this.ruleAddButton, gbc_ruleAddButton);
        this.ruleListTablePanel = new JPanel();
        GridBagConstraints gbc_RuleSelect = new GridBagConstraints();
        gbc_RuleSelect.weightx = 1.0;
        gbc_RuleSelect.weighty = 1.0;
        gbc_RuleSelect.fill = 1;
        gbc_RuleSelect.gridx = 0;
        gbc_RuleSelect.gridy = 1;
        this.ruleListPanel.add((Component)this.ruleListTablePanel, gbc_RuleSelect);
        GridBagLayout gbl_RuleSelect = new GridBagLayout();
        gbl_RuleSelect.columnWidths = new int[]{771, 0};
        gbl_RuleSelect.rowHeights = new int[]{0, 0, 0};
        gbl_RuleSelect.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_RuleSelect.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.ruleListTablePanel.setLayout(gbl_RuleSelect);
        this.ruleListTableTitleLabel = new JLabel(this.messages.getMessage("view.policySet.policyListTab.tableTitle"));
        this.ruleListTableTitleLabel.setHorizontalAlignment(0);
        GridBagConstraints gbc_label_1 = new GridBagConstraints();
        gbc_label_1.fill = 3;
        gbc_label_1.gridx = 0;
        gbc_label_1.gridy = 0;
        this.ruleListTablePanel.add((Component)this.ruleListTableTitleLabel, gbc_label_1);
        this.ruleListTableScrollPane = new JScrollPane();
        GridBagConstraints gbc_RuleSelList = new GridBagConstraints();
        gbc_RuleSelList.weightx = 1.0;
        gbc_RuleSelList.weighty = 1.0;
        gbc_RuleSelList.fill = 1;
        gbc_RuleSelList.gridx = 0;
        gbc_RuleSelList.gridy = 1;
        this.ruleListTablePanel.add((Component)this.ruleListTableScrollPane, gbc_RuleSelList);
        this.ruleListTableScrollPane.setAutoscrolls(true);
        this.ruleListTable = new JTable();
        this.ruleListTable.setSelectionMode(0);
        this.ruleListTable.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.ruleListTable.setModel(new DefaultTableModel(new Object[0][], new String[]{this.messages.getMessage("view.policySet.policyTab.listTitle.resource"), this.messages.getMessage("view.policySet.policyTab.listTitle.get"), this.messages.getMessage("view.policySet.policyTab.listTitle.post")}){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        });
        this.ruleListTable.getTableHeader().setReorderingAllowed(false);
        this.ruleListTable.setAutoResizeMode(0);
        this.ruleListTableScrollPane.setViewportView(this.ruleListTable);
        this.ruleModifyPanel = new JPanel();
        this.ruleTabbedPane.addTab(this.messages.getMessage("view.policySet.policyModTab.title"), null, this.ruleModifyPanel, null);
        GridBagLayout gbl_RuleModTab = new GridBagLayout();
        gbl_RuleModTab.columnWidths = new int[]{771, 0};
        gbl_RuleModTab.rowHeights = new int[]{0, 0};
        gbl_RuleModTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_RuleModTab.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.ruleModifyPanel.setLayout(gbl_RuleModTab);
        this.ruleModifyTablePanel = new JPanel();
        GridBagConstraints gbc_RuleMod = new GridBagConstraints();
        gbc_RuleMod.weighty = 1.0;
        gbc_RuleMod.weightx = 1.0;
        gbc_RuleMod.fill = 1;
        gbc_RuleMod.gridx = 0;
        gbc_RuleMod.gridy = 0;
        this.ruleModifyPanel.add((Component)this.ruleModifyTablePanel, gbc_RuleMod);
        GridBagLayout gbl_RuleMod = new GridBagLayout();
        gbl_RuleMod.columnWidths = new int[]{777, 0};
        gbl_RuleMod.rowHeights = new int[]{0, 0, 0};
        gbl_RuleMod.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_RuleMod.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.ruleModifyTablePanel.setLayout(gbl_RuleMod);
        this.ruleModifyTableTitleLabel = new JLabel();
        this.ruleModifyTableTitleLabel.setText(this.messages.getMessage("view.policySet.policyModTab.tableTitle"));
        GridBagConstraints gbc_ruleModLabel = new GridBagConstraints();
        gbc_ruleModLabel.weightx = 1.0;
        gbc_ruleModLabel.fill = 3;
        gbc_ruleModLabel.insets = new Insets(0, 0, 5, 0);
        gbc_ruleModLabel.gridx = 0;
        gbc_ruleModLabel.gridy = 0;
        this.ruleModifyTablePanel.add((Component)this.ruleModifyTableTitleLabel, gbc_ruleModLabel);
        this.ruleModifyTableScrollPane = new JScrollPane();
        GridBagConstraints gbc_RuleModList = new GridBagConstraints();
        gbc_RuleModList.weighty = 1.0;
        gbc_RuleModList.weightx = 1.0;
        gbc_RuleModList.insets = new Insets(0, 0, 5, 0);
        gbc_RuleModList.fill = 1;
        gbc_RuleModList.gridx = 0;
        gbc_RuleModList.gridy = 1;
        this.ruleModifyTablePanel.add((Component)this.ruleModifyTableScrollPane, gbc_RuleModList);
        this.ruleModifyTable = new JTable();
        this.ruleModifyTable.setSelectionMode(0);
        this.ruleModifyTable.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.ruleModifyTable.setModel(new DefaultTableModel(new Object[0][], new String[]{this.messages.getMessage("view.policySet.policyTab.listTitle.resource"), this.messages.getMessage("view.policySet.policyTab.listTitle.get"), this.messages.getMessage("view.policySet.policyTab.listTitle.post")}));
        this.ruleModifyTable.putClientProperty("terminateEditOnFocusLost", true);
        TableColumnModel ruleModTableColumnModel = this.ruleModifyTable.getColumnModel();
        this.ruleModifyTable.setAutoResizeMode(0);
        this.ruleModifyTable.setRowHeight(20);
        this.ruleModifyTable.getTableHeader().setReorderingAllowed(false);
        this.ruleModifyTableScrollPane.setViewportView(this.ruleModifyTable);
        TableColumn ruleModTableGetColumn = ruleModTableColumnModel.getColumn(1);
        ruleModTableGetColumn.setCellRenderer(new ComboBoxTableCellRenderer(new Object[]{new PermitComboBoxItem(PermitComboBoxItem.Type.NONE, this.messages.getMessage("view.policySet.permitComboBox.none")), new PermitComboBoxItem(PermitComboBoxItem.Type.ALLOW, this.messages.getMessage("view.policySet.permitComboBox.allow")), new PermitComboBoxItem(PermitComboBoxItem.Type.DENY, this.messages.getMessage("view.policySet.permitComboBox.deny"))}));
        ruleModTableGetColumn.setCellEditor(new ComboBoxTableCellEditor(new Object[]{new PermitComboBoxItem(PermitComboBoxItem.Type.NONE, this.messages.getMessage("view.policySet.permitComboBox.none")), new PermitComboBoxItem(PermitComboBoxItem.Type.ALLOW, this.messages.getMessage("view.policySet.permitComboBox.allow")), new PermitComboBoxItem(PermitComboBoxItem.Type.DENY, this.messages.getMessage("view.policySet.permitComboBox.deny"))}));
        int ruleModTableGetColumnWidth = ((ComboBoxTableCellEditor)ruleModTableGetColumn.getCellEditor()).getAutoCellWidth();
        ruleModTableGetColumn.setPreferredWidth(ruleModTableGetColumnWidth);
        TableColumn ruleModTablePostColumn = ruleModTableColumnModel.getColumn(2);
        ruleModTablePostColumn.setCellRenderer(new ComboBoxTableCellRenderer(new Object[]{new PermitComboBoxItem(PermitComboBoxItem.Type.NONE, this.messages.getMessage("view.policySet.permitComboBox.none")), new PermitComboBoxItem(PermitComboBoxItem.Type.ALLOW, this.messages.getMessage("view.policySet.permitComboBox.allow")), new PermitComboBoxItem(PermitComboBoxItem.Type.DENY, this.messages.getMessage("view.policySet.permitComboBox.deny"))}));
        ruleModTablePostColumn.setCellEditor(new ComboBoxTableCellEditor(new Object[]{new PermitComboBoxItem(PermitComboBoxItem.Type.NONE, this.messages.getMessage("view.policySet.permitComboBox.none")), new PermitComboBoxItem(PermitComboBoxItem.Type.ALLOW, this.messages.getMessage("view.policySet.permitComboBox.allow")), new PermitComboBoxItem(PermitComboBoxItem.Type.DENY, this.messages.getMessage("view.policySet.permitComboBox.deny"))}));
        int ruleModTablePostColumnWidth = ((ComboBoxTableCellEditor)ruleModTablePostColumn.getCellEditor()).getAutoCellWidth();
        ruleModTablePostColumn.setPreferredWidth(ruleModTablePostColumnWidth);
        this.ruleModifyTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                PolicySetView.this.onEdited();
            }
        });
        this.groupPanel = new JPanel();
        GridBagConstraints gbc_PolicySetGroup = new GridBagConstraints();
        gbc_PolicySetGroup.weightx = 1.0;
        gbc_PolicySetGroup.fill = 1;
        gbc_PolicySetGroup.gridx = 0;
        gbc_PolicySetGroup.gridy = 2;
        this.mainPanel.add((Component)this.groupPanel, gbc_PolicySetGroup);
        GridBagLayout gbl_PolicySetGroup = new GridBagLayout();
        gbl_PolicySetGroup.columnWidths = new int[]{0, 0};
        gbl_PolicySetGroup.rowHeights = new int[]{0, 0, 0, 0};
        gbl_PolicySetGroup.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_PolicySetGroup.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.groupPanel.setLayout(gbl_PolicySetGroup);
        this.groupTitleLabel = new JLabel(this.messages.getMessage("view.policySet.groupTableTitle"));
        GridBagConstraints gbc_label = new GridBagConstraints();
        gbc_label.insets = new Insets(0, 0, 5, 0);
        gbc_label.anchor = 10;
        gbc_label.weightx = 1.0;
        gbc_label.fill = 1;
        gbc_label.gridx = 0;
        gbc_label.gridy = 0;
        this.groupPanel.add((Component)this.groupTitleLabel, gbc_label);
        this.groupTitleLabel.setHorizontalAlignment(0);
        this.groupScrollPane = new JScrollPane();
        this.groupScrollPane.setMinimumSize(new Dimension(2, 150));
        this.groupScrollPane.setBorder(new BevelBorder(1, null, null, null, null));
        this.groupScrollPane.setAutoscrolls(true);
        GridBagConstraints gbc_GroupList = new GridBagConstraints();
        gbc_GroupList.insets = new Insets(0, 0, 5, 0);
        gbc_GroupList.weighty = 1.0;
        gbc_GroupList.weightx = 1.0;
        gbc_GroupList.fill = 1;
        gbc_GroupList.gridx = 0;
        gbc_GroupList.gridy = 1;
        this.groupPanel.add((Component)this.groupScrollPane, gbc_GroupList);
        this.groupTable = new JTable();
        this.groupTable.setRowHeight(18);
        this.groupTable.setSelectionMode(2);
        this.groupTable.setBorder(new EtchedBorder(1, null, null));
        this.groupTable.setPreferredScrollableViewportSize(new Dimension(450, 100));
        this.groupTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"", this.messages.getMessage("view.policySet.groupTab.groupTitle"), ""}){
            private static final long serialVersionUID = 1L;

            @Override
            public Class<?> getColumnClass(int column) {
                Object value = this.getValueAt(0, column);
                if (value == null) {
                    return String.class;
                }
                return value.getClass();
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                switch (col) {
                    case 0: {
                        return true;
                    }
                }
                return false;
            }
        });
        this.groupTable.setAutoResizeMode(0);
        this.groupTable.getTableHeader().setReorderingAllowed(false);
        TableColumnModel groupTableColumnModel = this.groupTable.getColumnModel();
        this.groupModelColumn = groupTableColumnModel.getColumn(2);
        this.groupTable.removeColumn(this.groupModelColumn);
        this.groupScrollPane.setViewportView(this.groupTable);
        this.actionButtonsPanel = new JPanel();
        GridBagConstraints gbc_PolicyAction = new GridBagConstraints();
        gbc_PolicyAction.weighty = 1.0;
        gbc_PolicyAction.fill = 2;
        gbc_PolicyAction.gridx = 0;
        gbc_PolicyAction.gridy = 2;
        this.groupPanel.add((Component)this.actionButtonsPanel, gbc_PolicyAction);
        this.okButton = new JButton(this.messages.getMessage("view.policySet.groupTab.okButton"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicySetView.this.ok();
            }
        });
        this.okButton.setPreferredSize(new Dimension(120, 32));
        this.actionButtonsPanel.setLayout(new FlowLayout(1, 5, 5));
        this.actionButtonsPanel.add(this.okButton);
        this.cancelButton = new JButton(this.messages.getMessage("view.policySet.groupTab.cancelButton"));
        this.cancelButton.setPreferredSize(new Dimension(120, 32));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicySetView.this.cancel();
            }
        });
        this.actionButtonsPanel.add(this.cancelButton);
    }

    private PolicySetView(MessageSourceAccessor mes) {
        this.messages = mes;
        this.init();
    }

    private void setVisibles() {
        boolean b = this.mode == PolicySetMode.ADD;
        this.titleRealmComboBox.setVisible(b);
        this.titleRealmNameLabel.setVisible(!b);
        this.titleRealmDummyLabel.setVisible(!b);
        this.titlePolicyTextField.setVisible(b);
        this.titlePolicyNameLabel.setVisible(!b);
    }

    private void initViews() {
        this.setSize(800, 600);
        this.titlePolicyTextField.setText("");
        ((DefaultTableModel)this.ruleListTable.getModel()).setRowCount(0);
        ((DefaultTableModel)this.ruleModifyTable.getModel()).setRowCount(0);
        ((DefaultTableModel)this.groupTable.getModel()).setRowCount(0);
        this.ruleTabbedPane.setSelectedIndex(0);
    }

    public void initData(Policy policy) {
        this.result = false;
        this.mode = PolicySetMode.MODIFY;
        Realm realm = this.service.findRealmByName(policy.getRealmName());
        this.targetPolicy = policy;
        this.initViews();
        this.titleRealmNameLabel.setText(realm.getRealmName());
        this.titlePolicyNameLabel.setText(policy.getPolicyName());
        this.setResourceComboBox(realm);
        this.setResourceTable(policy);
        List<Subject> subjects = policy.getSubjects();
        HashSet<String> groups = new HashSet<String>();
        for (Subject subject : subjects) {
            groups.add(subject.getSubjectName());
        }
        this.setGroupTable(realm, groups);
        this.setVisibles();
    }

    public void initData() {
        this.result = false;
        this.mode = PolicySetMode.ADD;
        this.targetPolicy = null;
        this.initViews();
        this.setRealmComboBox();
        this.setVisibles();
    }

    public boolean getResult() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ok() {
        int i;
        Policy policy;
        boolean validateInputResult = this.validateInput();
        if (!validateInputResult) {
            return;
        }
        ArrayList<Resource> oldResources = null;
        ArrayList<Subject> oldSubjects = null;
        if (this.mode == PolicySetMode.ADD) {
            Realm realm = ((RealmComboBoxItem)this.titleRealmComboBox.getSelectedItem()).getRealmModel();
            String policyName = this.titlePolicyTextField.getText().trim();
            policy = new Policy(realm.getRealmName(), policyName);
        } else {
            policy = this.targetPolicy;
            oldResources = new ArrayList<Resource>(policy.getResources());
            oldSubjects = new ArrayList<Subject>(policy.getSubjects());
            policy.getResources().clear();
            policy.getSubjects().clear();
        }
        for (i = 0; i < this.ruleModifyTable.getRowCount(); ++i) {
            Resource resource = new Resource((String)this.ruleListTable.getValueAt(i, 0), PolicySetViewPermitUtil.getPermitByPermitComboBoxItem((PermitComboBoxItem)this.ruleModifyTable.getValueAt(i, 1)), PolicySetViewPermitUtil.getPermitByPermitComboBoxItem((PermitComboBoxItem)this.ruleModifyTable.getValueAt(i, 2)));
            resource.setPolicy(policy);
            policy.addResource(resource);
        }
        this.groupTable.addColumn(this.groupModelColumn);
        for (i = 0; i < this.groupTable.getRowCount(); ++i) {
            if (!((Boolean)this.groupTable.getValueAt(i, 0)).booleanValue()) continue;
            Group group = (Group)this.groupTable.getValueAt(i, 2);
            Subject subject = new Subject(group.getGroupName(), group.getGroupCode());
            subject.setPolicy(policy);
            policy.addSubject(subject);
        }
        this.groupTable.removeColumn(this.groupModelColumn);
        boolean executeResult = false;
        ConstraintViolation<?> violation = null;
        try {
            violation = this.mode == PolicySetMode.ADD ? this.service.addPolicy(policy) : this.service.modifyPolicy(policy);
            if (violation != null) {
                MessageDialog.showViolationMessage(this, violation);
            }
            executeResult = true;
            this.result = true;
            this.setVisible(false);
        }
        catch (Throwable e) {
            this.viewExceptionHandler.handle(e);
            return;
        }
        finally {
            if (!executeResult && this.mode == PolicySetMode.MODIFY) {
                policy.getResources().clear();
                policy.getSubjects().clear();
                policy.getResources().addAll(oldResources);
                policy.getSubjects().addAll(oldSubjects);
            }
        }
    }

    private void cancel() {
        this.result = false;
        this.setVisible(false);
    }

    private void addRule() {
        String inputResourceUrl = ((String)this.resourceComboBox.getSelectedItem()).trim();
        if (inputResourceUrl.isEmpty()) {
            MessageDialog.showMessage(this, "I-0201", new Object[0]);
            return;
        }
        System.out.println(this.getRequestComboBox.getSelectedIndex());
        System.out.println(this.postRequestComboBox.getSelectedIndex());
        if (this.getRequestComboBox.getSelectedIndex() == 0 || this.postRequestComboBox.getSelectedIndex() == 0) {
            MessageDialog.showMessage(this, "I-0202", new Object[0]);
            return;
        }
        for (int i = 0; i < this.ruleListTable.getRowCount(); ++i) {
            String registeredResourceUrl = (String)this.ruleListTable.getValueAt(i, 0);
            if (!inputResourceUrl.equals(registeredResourceUrl)) continue;
            MessageDialog.showMessage(this, "I-0204", inputResourceUrl);
            return;
        }
        DefaultTableModel ruleModTableModel = (DefaultTableModel)this.ruleModifyTable.getModel();
        PermitComboBoxItem getItem = (PermitComboBoxItem)this.getRequestComboBox.getSelectedItem();
        PermitComboBoxItem postItem = (PermitComboBoxItem)this.postRequestComboBox.getSelectedItem();
        Object[] ruleModRowData = new Object[]{inputResourceUrl, getItem, postItem};
        ruleModTableModel.addRow(ruleModRowData);
    }

    private void removeRule() {
        int selectedRow = this.ruleListTable.getSelectedRow();
        if (selectedRow == -1) {
            MessageDialog.showMessage(this, "I-0203", new Object[0]);
            return;
        }
        DefaultTableModel ruleModTableModel = (DefaultTableModel)this.ruleModifyTable.getModel();
        ruleModTableModel.removeRow(selectedRow);
    }

    private boolean validateInput() {
        if (this.mode == PolicySetMode.ADD) {
            Realm realm = ((RealmComboBoxItem)this.titleRealmComboBox.getSelectedItem()).getRealmModel();
            if (realm == null) {
                MessageDialog.showMessage(this, "I-0205", new Object[0]);
                return false;
            }
            String policyName = this.titlePolicyTextField.getText().trim();
            if (policyName.isEmpty()) {
                MessageDialog.showMessage(this, "I-0206", new Object[0]);
                return false;
            }
        }
        if (this.ruleListTable.getRowCount() == 0) {
            MessageDialog.showMessage(this, "I-0207", new Object[0]);
            return false;
        }
        boolean groupSelectedMoreThanOne = false;
        for (int i = 0; i < this.groupTable.getRowCount(); ++i) {
            if (!((Boolean)this.groupTable.getValueAt(i, 0)).booleanValue()) continue;
            groupSelectedMoreThanOne = true;
        }
        if (!groupSelectedMoreThanOne) {
            MessageDialog.showMessage(this, "I-0208", new Object[0]);
            return false;
        }
        return true;
    }

    private void clearRule() {
        DefaultTableModel ruleModTableModel = (DefaultTableModel)this.ruleModifyTable.getModel();
        ruleModTableModel.setRowCount(0);
    }

    private void onEdited() {
        this.ruleListTable.setVisible(false);
        if (this.ruleListTable.getRowCount() != this.ruleModifyTable.getRowCount()) {
            DefaultTableModel ruleSelTableModel = (DefaultTableModel)this.ruleListTable.getModel();
            ruleSelTableModel.setRowCount(this.ruleModifyTable.getRowCount());
        }
        ArrayList<String> resourceList = new ArrayList<String>();
        for (int rowIndex = 0; rowIndex < this.ruleModifyTable.getRowCount(); ++rowIndex) {
            String resourceUrl = (String)this.ruleModifyTable.getValueAt(rowIndex, 0);
            PermitComboBoxItem getModItem = (PermitComboBoxItem)this.ruleModifyTable.getValueAt(rowIndex, 1);
            PermitComboBoxItem postModItem = (PermitComboBoxItem)this.ruleModifyTable.getValueAt(rowIndex, 2);
            this.ruleListTable.setValueAt(resourceUrl, rowIndex, 0);
            this.ruleListTable.setValueAt(getModItem.toString(), rowIndex, 1);
            this.ruleListTable.setValueAt(postModItem.toString(), rowIndex, 2);
            resourceList.add(resourceUrl);
        }
        JTableColumnWidthCalculator ruleModifyTableCalculator = new JTableColumnWidthCalculator(this.ruleModifyTable);
        ruleModifyTableCalculator.setAutomatically(0, resourceList);
        for (int columnIndex = 1; columnIndex < this.ruleModifyTable.getColumnCount(); ++columnIndex) {
            ruleModifyTableCalculator.setAutomatically(columnIndex);
        }
        JTableColumnWidthCalculator ruleListTableCalculator = new JTableColumnWidthCalculator(this.ruleListTable);
        ruleListTableCalculator.setAutomatically(0, resourceList);
        for (int columnIndex = 1; columnIndex < this.ruleListTable.getColumnCount(); ++columnIndex) {
            ruleListTableCalculator.setAutomatically(columnIndex);
        }
        this.ruleListTable.setVisible(true);
    }

    private void setRealmComboBox() {
        this.titleRealmComboBox.setVisible(false);
        this.titleRealmComboBox.removeAllItems();
        this.titleRealmComboBox.addItem(RealmComboBoxItem.ALL_REALM);
        for (Realm realm : this.service.findRealms()) {
            this.titleRealmComboBox.addItem(new RealmComboBoxItem(realm.getRealmName(), realm));
        }
        this.titleRealmComboBox.setSelectedItem(RealmComboBoxItem.ALL_REALM);
        this.titleRealmComboBox.setVisible(true);
    }

    private void wrapSetResourceComboBox(RealmComboBoxItem realmItem) {
        this.setResourceComboBox(realmItem.getRealmModel());
    }

    private void setResourceComboBox(Realm realm) {
        this.resourceComboBox.setVisible(false);
        this.resourceComboBox.removeAllItems();
        this.resourceComboBox.addItem("");
        this.getRequestComboBox.setSelectedIndex(0);
        this.postRequestComboBox.setSelectedIndex(0);
        if (realm == null) {
            this.resourceComboBox.setVisible(true);
            return;
        }
        List<Referral> referrals = this.service.findReferrals(realm);
        for (Referral referral : referrals) {
            this.resourceComboBox.addItem(referral.getRefpolicy());
        }
        this.resourceComboBox.setVisible(true);
    }

    private void setResourceTable(Policy policy) {
        this.ruleModifyTable.setVisible(false);
        DefaultTableModel ruleModifyTableModel = (DefaultTableModel)this.ruleModifyTable.getModel();
        ruleModifyTableModel.setRowCount(0);
        ArrayList<String> resourceList = new ArrayList<String>();
        List<Resource> resources = policy.getResources();
        for (Resource resource : resources) {
            PermitComboBoxItem getPermitItem = PolicySetViewPermitUtil.getComboBoxItemByPermit(resource.getGetPermit());
            PermitComboBoxItem postPermitItem = PolicySetViewPermitUtil.getComboBoxItemByPermit(resource.getPostPermit());
            ruleModifyTableModel.addRow(new Object[]{resource.getResourceUrl(), getPermitItem, postPermitItem});
            resourceList.add(resource.getResourceUrl());
        }
        this.ruleModifyTable.setVisible(true);
    }

    private void wrapSetGroupTable(RealmComboBoxItem realmItem) {
        this.setGroupTable(realmItem.getRealmModel(), new HashSet<String>());
    }

    private void setGroupTable(Realm realm, Set<String> groupNames) {
        this.groupTable.setVisible(false);
        DefaultTableModel groupTableModel = (DefaultTableModel)this.groupTable.getModel();
        groupTableModel.setRowCount(0);
        if (realm == null) {
            this.groupTable.setVisible(true);
            return;
        }
        this.groupTable.addColumn(this.groupModelColumn);
        List<Group> groups = this.service.findGroupByRealm(realm);
        ArrayList<String> groupStrings = new ArrayList<String>();
        for (Group group : groups) {
            boolean b = groupNames.contains(group.getGroupName());
            String groupString = group.getGroupName() + " (" + group.getGroupCode() + ")";
            groupTableModel.addRow(new Object[]{b, groupString, group});
            groupStrings.add(groupString);
        }
        this.groupTable.removeColumn(this.groupModelColumn);
        JTableColumnWidthCalculator groupTableCalculator = new JTableColumnWidthCalculator(this.groupTable);
        this.groupTable.getColumnModel().getColumn(0).setPreferredWidth(21);
        for (int columnIndex = 1; columnIndex < this.groupTable.getColumnCount(); ++columnIndex) {
            groupTableCalculator.setAutomatically(columnIndex);
        }
        this.groupTable.setVisible(true);
    }
}

