@REM ====
@REM     Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
@REM     The software in this package is published under the terms of the CPAL v1.0
@REM     license, a copy of which has been included with this distribution in the
@REM     LICENSE.txt file.
@REM ====
@REM

@echo off

set ERROR_CODE=0

:init
@REM Decide how to startup depending on the version of windows

@REM -- Win98ME
if NOT "%OS%"=="Windows_NT" goto Win9xArg

@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" @setlocal

@REM -- 4NT shell
if "%eval[2+2]" == "4" goto 4NTArgs

@REM -- Regular WinNT shell
set CMD_LINE_ARGS=%*
goto WinNTGetScriptDir

@REM The 4NT Shell from jp software
:4NTArgs
set CMD_LINE_ARGS=%$
goto WinNTGetScriptDir

:Win9xArg
@REM Slurp the command line arguments.  This loop allows for an unlimited number
@REM of arguments (up to the command line limit, anyway).
set CMD_LINE_ARGS=
:Win9xApp
if %1a==a goto Win9xGetScriptDir
set CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
shift
goto Win9xApp

:Win9xGetScriptDir
set SAVEDIR=%CD%
%0\
cd %0\..\.. 
set BASEDIR=%CD%
cd %SAVEDIR%
set SAVE_DIR=
goto repoSetup

:WinNTGetScriptDir
set BASEDIR=%~dp0\..

:repoSetup


if "%JAVACMD%"=="" set JAVACMD=java

if "%REPO%"=="" set REPO=%BASEDIR%\lib

set CLASSPATH="%BASEDIR%"\conf;"%REPO%"\spring-core-3.1.0.RELEASE.jar;"%REPO%"\spring-asm-3.1.0.RELEASE.jar;"%REPO%"\spring-context-3.1.0.RELEASE.jar;"%REPO%"\spring-expression-3.1.0.RELEASE.jar;"%REPO%"\spring-beans-3.1.0.RELEASE.jar;"%REPO%"\spring-aop-3.1.0.RELEASE.jar;"%REPO%"\aopalliance-1.0.jar;"%REPO%"\spring-context-support-3.1.0.RELEASE.jar;"%REPO%"\spring-tx-3.1.0.RELEASE.jar;"%REPO%"\spring-orm-3.1.0.RELEASE.jar;"%REPO%"\spring-jdbc-3.1.0.RELEASE.jar;"%REPO%"\hibernate-core-4.0.0.Final.jar;"%REPO%"\commons-collections-3.2.1.jar;"%REPO%"\antlr-2.7.7.jar;"%REPO%"\jboss-transaction-api_1.1_spec-1.0.0.Final.jar;"%REPO%"\dom4j-1.6.1.jar;"%REPO%"\xml-apis-1.0.b2.jar;"%REPO%"\jboss-logging-3.1.0.CR2.jar;"%REPO%"\classmate-0.5.4.jar;"%REPO%"\jandex-1.0.3.Final.jar;"%REPO%"\hibernate-commons-annotations-4.0.1.Final.jar;"%REPO%"\javassist-3.12.1.GA.jar;"%REPO%"\hibernate-entitymanager-4.0.0.Final.jar;"%REPO%"\hibernate-validator-4.2.0.Final.jar;"%REPO%"\hibernate-jpa-2.0-api-1.0.1.Final.jar;"%REPO%"\validation-api-1.0.0.GA.jar;"%REPO%"\hsqldb-2.2.6.jar;"%REPO%"\aspectjweaver-1.6.12.jar;"%REPO%"\javassist-3.15.0-GA.jar;"%REPO%"\cglib-2.2.2.jar;"%REPO%"\asm-3.3.1.jar;"%REPO%"\commons-lang3-3.1.jar;"%REPO%"\commons-io-2.0.1.jar;"%REPO%"\commons-dbcp-1.4.jar;"%REPO%"\commons-pool-1.5.4.jar;"%REPO%"\poi-3.7.jar;"%REPO%"\httpclient-4.1.2.jar;"%REPO%"\httpcore-4.1.2.jar;"%REPO%"\commons-codec-1.4.jar;"%REPO%"\jcl-over-slf4j-1.6.4.jar;"%REPO%"\slf4j-api-1.6.4.jar;"%REPO%"\slf4j-log4j12-1.6.4.jar;"%REPO%"\log4j-1.2.16.jar;"%REPO%"\policytool-1.0.0.jar
set EXTRA_JVM_ARGUMENTS=-Xms256m -Xmx512m
goto endInit

@REM Reaching here means variables are defined and arguments have been captured
:endInit

%JAVACMD% %JAVA_OPTS% %EXTRA_JVM_ARGUMENTS% -classpath %CLASSPATH_PREFIX%;%CLASSPATH% -Dapp.name="policytool" -Dapp.repo="%REPO%" -Dbasedir="%BASEDIR%" jp.co.ogis_ri.citk.policytool.AppLauncher %CMD_LINE_ARGS%
if ERRORLEVEL 1 goto error
goto end

:error
if "%OS%"=="Windows_NT" @endlocal
set ERROR_CODE=1

:end
@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" goto endNT

@REM For old DOS remove the set variables from ENV - we assume they were not set
@REM before we started - at least we don't leave any baggage around
set CMD_LINE_ARGS=
goto postExec

:endNT
@REM If error code is set to 1 then the endlocal was done already in :error.
if %ERROR_CODE% EQU 0 @endlocal


:postExec

if "%FORCE_EXIT_ON_ERROR%" == "on" (
  if %ERROR_CODE% NEQ 0 exit %ERROR_CODE%
)

exit /B %ERROR_CODE%
