﻿/*
 Copyright (c) 2009 ToI-Planning, All rights reserved.
 
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 */

CKEDITOR.plugins.add('rewrite',
{
	init : function( editor )
	{
		if (editor.config.rewrite_urls) {
			var rules = {};
			for (var e in editor.config.rewrite_rules) {
				var r = editor.config.rewrite_rules[e];
				var nfuncs = 0;
				for (var a in r) {
					var from = r[a]['from'],
					    to = r[a]['to'],
					    kto = r[a]['to'];

					if (from === false) {
						from = editor.config.rewrite_default_from;
					}
					if (to === false) {
						kto = to = editor.config.rewrite_default_to;
					}
					if (typeof to === 'function') {
						nfuncs++;
						kto = '___function___'+nfuncs;
					}

					var k = ':'+from+':'+kto;
					if (! rules[k]) {
						rules[k] = {
							from: from,
							to: to,
							rules: []
						}
					}
					rules[k]['rules'].push('<'+e+'\\s+[^>]*\s*'+a+'="');
				}
			}

			for (var i = 0; i < editor.config.rewrite_events.length; i++) {
				editor.on(editor.config.rewrite_events[i], function(obj) {
					for (var r in rules) {
						var from = rules[r]['from'];
						var to = rules[r]['to'];
						var rs = rules[r]['rules'];

						var reg1 = new RegExp(
							'('+rs.join('|')+')('+from+')', 'i'
						);
						var reg2 = new RegExp(from, 'i');
						if (typeof obj.data.dataValue !== 'undefined') {
							obj.data.dataValue = obj.data.dataValue.replace(
								reg1, function(whole, f, s) {
									return f + s.replace(reg2, to);
								}
							);
						} else {
							obj.data = obj.data.replace(
								reg1, function(whole, f, s) {
									return f + s.replace(reg2, to);
								}
							);
						}
					}
				});
			}
		}
	}
} );

CKEDITOR.config.rewrite_events = [
	'afterSetDara', 'getData', 'insertHtml'
];

/**
 * Default value of rewrite origin.
 * @type String
 * @default
 * config.rewrite_default_from = document.location.href.
 *     replace(/^(http:\/\/[^\/]*).*$/, '$1').
 *     replace(/^https?/, 'https?');
 * @example
 * config.rewrite_default_from = 'https?://foo.example.com/';
 */
CKEDITOR.config.rewrite_default_from = document.location.href.
	replace(/^(http:\/\/[^\/]*).*/, '$1').
	replace(/^https?/, 'https?');

/**
 * Default value of rewrite ahead.
 * @type String
 * @default ''
 * @example
 * config.rewrite_default_to = 'http://bar.example.com/';
 */
CKEDITOR.config.rewrite_default_to = '';

/**
 * The rewrite definition to be used to apply.
 * @type Object
 * @example
 * config.rewrite_rules = {
 *     a: {
 *         href: {
 *             from: 'http://example.com/',
 *             to: ''
 *         }
 *     },
 *     img: {
 *         src: {
 *             from: 'http://foo.example.com/',
 *             to: 'http://foo.example.com/'
 *         }
 *     }
 * };
 */
CKEDITOR.config.rewrite_rules = {
	a: {
		href: {
			from: false,
			to: false
		}
	},
	img: {
		src: {
			from: false,
			to: false
		}
	}
};

/**
 * Whether to enable the rewrite feature.
 * @type Boolean
 * @default true
 * @example
 * config.rewrite_urls = true;
 */
CKEDITOR.config.rewrite_urls = false;
