// =====================================================================
//  $Id: OFFpure.cc,v 1.3 2003/10/06 16:28:17 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: OFFpure.cc,v $
//  Revision 1.3  2003/10/06 16:28:17  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:15:51  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include <TROOT.h>
#include <TSystem.h>
#include <TApplication.h> 
#include <TStyle.h>
#include <TGraph.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TNtuple.h>
#include <TFile.h>
#include <TPad.h>

#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return -1;
  }
  Tstring ifname = argv[ 1 ];

  TApplication* theApplication = new TApplication( "root-analyser", 0, 0 );
  gROOT -> Reset( 0 );
  gROOT -> Reset( 0 );
  gStyle -> SetStatColor(42);
  gStyle -> SetTitleColor(42);
  gStyle -> SetFrameFillColor( 21 );
  gStyle -> SetFrameFillStyle( 1 );
  gStyle -> SetMarkerStyle( 7 );
  gStyle -> SetFuncColor( 4 );
  gStyle -> SetOptStat( 1111110 );
  gStyle -> SetOptFit( 1111 );
  gStyle -> SetPadGridX( kTRUE );
  gStyle -> SetPadGridY( kTRUE );
  TCanvas cv( "CVfadc", "Pentland MPX201A" );
  TH1D mpx201a( "mpx201a", "nothing to do for data", 400, 0.0, 4096.0 );
  mpx201a.SetFillColor( 45 );


  Tstring fadcidset[ 3 ] = { "EVENT", "ADC", "0" };
  TDataRecord record;
  TInputObjectFile ifile( ifname );
  while ( ( ifile >> record ) != 0 ) {
    TDataElement e;
    if ( record.FindDataElement( fadcidset, e ) ) {
      Tshort* data = e.GetShortData();
      Tint ndata = e.GetNumberOfPrimitives();
      for ( Tint i = 0; i < ndata; i ++ ) {
	mpx201a.Fill( data[ i ] );
      }
    } else {
      continue;
    }
  }

  cv.cd();
  mpx201a.Draw();
  theApplication -> Run();

  return 0;
}
