// =====================================================================
//  $Id: St02RunInformationExtractor.hh,v 1.4 2004/01/19 21:10:29 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: St02RunInformationExtractor.hh,v $
//  Revision 1.4  2004/01/19 21:10:29  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.3  2003/10/06 16:28:19  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:34  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef CLDAQ__ST02RUNINFORMATIONEXTRACTOR_HH
#define CLDAQ__ST02RUNINFORMATIONEXTRACTOR_HH

#include "Tglobals.h"

class St02RunInformationExtractor
{

  private:
    Tstring theRecordPath;
    TstringList theElementTags;
    TstringList theElements;

  public:
    St02RunInformationExtractor( const Tstring& recpath );
    ~St02RunInformationExtractor();

  public:
    friend Tostream& operator<<( Tostream& tos, const St02RunInformationExtractor& right );

  public:
    const Tstring& GetRecordPath() const;
    const TstringList& GetElementTags() const;
    const TstringList& GetElements() const;
    const Tstring& GetElementTag( Tint index ) const;
    const Tstring& GetElement( Tint index ) const;

};

inline const Tstring& St02RunInformationExtractor::GetRecordPath() const
{
  return theRecordPath;
}

inline const TstringList& St02RunInformationExtractor::GetElementTags() const
{
  return theElementTags;
}

inline const TstringList& St02RunInformationExtractor::GetElements() const
{
  return theElements;
}

inline const Tstring& St02RunInformationExtractor::GetElementTag( Tint index ) const
{
  return theElementTags[ index ];
}

inline const Tstring& St02RunInformationExtractor::GetElement( Tint index ) const
{
  return theElements[ index ];
}

#endif
