// =====================================================================
/*!
//
//  \file TAnalyser.hh
//  \brief This file contains the TAnalyser class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TAnalyser.hh,v 1.5 2004/01/19 21:09:38 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: TAnalyser.hh,v $
//  Revision 1.5  2004/01/19 21:09:38  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:10  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:36  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TANALYSER_HH
#define CLDAQ__TANALYSER_HH

#include "Tglobals.h"

class TExtractor;
class TMatrixElement;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TAnalyser
// \brief This is the TAnalyser class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TAnalyser class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup AnalysisCategory
*/
class TAnalyser
{

  protected:
    Tstring theAnalyserID;
    TExtractor** theExtractorList;
    Tint theExtractorListCapacity;
    Tint theNumberOfExtractors;
    Tint theExtractorIndex;

  public:
    TAnalyser( const Tstring& id );
    virtual ~TAnalyser();

  public:
    Tint AddExtractor( TExtractor* extractor );
    Tint RemoveExtractor( Tint index );
    Tvoid ClearExtractorList();
    Tbool ResizeExtractorList( Tint capacity );
    TExtractor* NextExtractor();
    TExtractor* FindExtractor( const Tstring& id );
    TExtractor* GetExtractor( Tint index );
    TExtractor* GetExtractor();
    Tint GetExtractorListCapacity() const;
    Tint GetNumberOfExtractors() const;
    Tint GetExtractorIndex() const;
    Tvoid SetExtractorIndex( Tint index );
    const Tstring& GetAnalyserID() const;
    Tvoid SetAnalyserID( const Tstring& id );

  public:
    virtual Tvoid NotFoundExtractor();

  public:
    virtual Tvoid OpenCanvas( const Tstring& id, const Tstring& title, Tint width = 640, Tint height = 480 ) = 0;
    virtual Tvoid ClearCanvas( const Tstring& id ) = 0;
    virtual Tvoid CloseCanvas( const Tstring& id ) = 0;
    virtual Tvoid Create1DHistogram( const Tstring& id, const Tstring& title, Tint nbin, Tdouble min, Tdouble max ) = 0;
    virtual Tvoid Create2DHistogram( const Tstring& id, const Tstring& title, Tint xbin, Tdouble xmin, Tdouble xmax, Tint ybin, Tdouble ymin, Tdouble ymax ) = 0;
    virtual Tvoid CreateAppendGraph( const Tstring& id, const Tstring& title ) = 0;
    virtual Tvoid CreateSubstituteGraph( const Tstring& id, const Tstring& title ) = 0;
    virtual Tvoid Fill( const TMatrixElement& matrix ) = 0;
    virtual Tvoid Clear( const Tstring& id ) = 0;
    virtual Tvoid Remove( const Tstring& id ) = 0;
    virtual Tvoid Update( const Tstring& id ) = 0;

  protected:
    Tvoid free();
    Tvoid allocate( Tint capacity );

};

inline Tint TAnalyser::GetExtractorListCapacity() const
{
  return theExtractorListCapacity;
}

inline Tint TAnalyser::GetNumberOfExtractors() const
{
  return theNumberOfExtractors;
}

inline Tint TAnalyser::GetExtractorIndex() const
{
  return theExtractorIndex;
}

inline Tvoid TAnalyser::SetExtractorIndex( Tint index )
{
  theExtractorIndex = index;
  return;
}

inline const Tstring& TAnalyser::GetAnalyserID() const
{
  return theAnalyserID;
}

inline Tvoid TAnalyser::SetAnalyserID( const Tstring& id )
{
  theAnalyserID = id;
  return;
}

#endif
