// =====================================================================
/*!
//
//  \file TAnalysisManager.hh
//  \brief This file contains the TAnalysisManager class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TAnalysisManager.hh,v 1.5 2004/01/19 21:09:38 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: TAnalysisManager.hh,v $
//  Revision 1.5  2004/01/19 21:09:38  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:10  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:36  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TANALYSISMANAGER_HH
#define CLDAQ__TANALYSISMANAGER_HH

#include "Tglobals.h"
#include "TAnalyser.hh"
#include "TAnalysisStatusTable.hh"
#include "TAnalysisAction.hh"

class TExtractor;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TAnalysisManager
// \brief This is the TAnalysisManager class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TAnalysisManager class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup AnalysisCategory
*/
class TAnalysisManager
{

  protected:
    static TAnalysisManager* theAnalysisManager;

  protected:
    TAnalysisStatusTable theStatusTable;
    TAnalyser* theAnalyser;
    TAnalysisAction* theAnalysisAction;

  public:
    TAnalysisManager( TAnalyser* analyser = 0 );
    virtual ~TAnalysisManager();

  public:
    virtual Tvoid StartAnalysis( const Tstring& id );
    virtual Tvoid StopAnalysis( const Tstring& id );
    virtual Tvoid UpdateAnalysis( const Tstring& id );
    virtual Tvoid SuspendAnalysis( const Tstring& id );
    virtual Tvoid ResumeAnalysis( const Tstring& id );
    virtual Tvoid StartAnalysis();
    virtual Tvoid StopAnalysis();
    virtual Tvoid UpdateAnalysis();
    virtual Tvoid SuspendAnalysis();
    virtual Tvoid ResumeAnalysis();

  public:
    virtual Tvoid ShowStatus() const;

  public:
    TAnalyser* GetAnalyser() const;
    Tvoid SetAnalyser( TAnalyser* analyser );
    Tvoid SetExtractor( TExtractor* extractor );
    const TAnalysisStatusTable& GetStatusTable() const;
    TAnalysisStatusTable& GetStatusTable();
    Tvoid SetStatusTable( const TAnalysisStatusTable& table );
    TAnalysisAction* GetAnalysisAction() const;
    Tvoid SetAnalysisAction( TAnalysisAction* action );

  public:
    virtual Tvoid GoAnalysisLoop( const Tstring& id );
    virtual Tvoid WaitReturnFromAnalysisLoop( const Tstring& id );

  protected:
    static Tvoid* doAnalysisLoop( Tvoid* arguments );

  public:
    static TAnalysisManager* GetAnalysisManager();

};

inline TAnalysisManager* TAnalysisManager::GetAnalysisManager()
{
  if ( theAnalysisManager == 0 )
    return 0;
  return theAnalysisManager;
}

inline TAnalyser* TAnalysisManager::GetAnalyser() const
{
  return theAnalyser;
}

inline const TAnalysisStatusTable& TAnalysisManager::GetStatusTable() const
{
  return theStatusTable;
}

inline TAnalysisStatusTable& TAnalysisManager::GetStatusTable()
{
  return theStatusTable;
}

inline Tvoid TAnalysisManager::SetStatusTable( const TAnalysisStatusTable& table )
{
  theStatusTable = table;
  return;
}

inline Tvoid TAnalysisManager::SetExtractor( TExtractor* extractor )
{
  if ( theAnalyser != 0 )
    theAnalyser -> AddExtractor( extractor );
  return;
}

inline TAnalysisAction* TAnalysisManager::GetAnalysisAction() const
{
  return theAnalysisAction;
}

#endif
