// =====================================================================
//  $Id: TSetRunIdCommand.cc,v 1.2 2003/10/06 17:02:37 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: TSetRunIdCommand.cc,v $
//  Revision 1.2  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.1  2003/07/30 18:19:17  goiwai
//  TSetRunIdCommand饹ɲäޤ.
//  ˤ,/run/setidޥɤɲäޤ.
//
// =====================================================================
#include "TSetRunIdCommand.hh"
#include "TRunManager.hh"

static const Tstring _name = "/run/setid";
static const Tstring _desc = "set run ID.";

TSetRunIdCommand::TSetRunIdCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TSetRunIdCommand::~TSetRunIdCommand()
{;}

Tvoid TSetRunIdCommand::Execute( const TstringList& arguments )
{
  if ( arguments.empty() ) {
    Tcout << theRunManager -> GetRunID() << Tendl;
  } else {
    Tstring runid = arguments[ 0 ];

    // 012 Ȥ 0x12 ȤݤʤΤǵĤʤ
    if ( runid.size() != 1 && runid[ 0 ] == '0' ) {
      Tcerr << "TSetRunIdCommand::Execute: invalid ID" << Tendl;
      return;
    }

    // Ϥɤå
    for ( Tsize_t i = 0; i < runid.size(); i ++ ) {
      if ( isdigit( runid[ i ] ) == 0 ) {
        // ʳޤФʤ
        Tcerr << "TSetRunIdCommand::Execute: invalid ID" << Tendl;
        return;
      }
    }

    Tint id = strtol( runid.c_str(), 0, 0 );
    theRunManager -> SetRunID( id );
  }
  return;
}
