// =====================================================================
/*!
//
//  \file TReadoutSpecified.hh
//  \brief This file contains the TReadoutSpecified class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TReadoutSpecified.hh,v 1.5 2004/01/19 21:09:42 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: TReadoutSpecified.hh,v $
//  Revision 1.5  2004/01/19 21:09:42  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:14  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:39:00  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TREADOUTSPECIFIED_HH
#define CLDAQ__TREADOUTSPECIFIED_HH

#include "Tglobals.h"

class TReadoutList;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TReadoutSpecified
// \brief This is the TReadoutSpecified class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TReadoutSpecified class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ReadoutCategory
*/
class TReadoutSpecified
{

  private:
    Tstring theListID;
    TReadoutList* theReadoutList;

  public:
    TReadoutSpecified();
    TReadoutSpecified( const Tstring& id, TReadoutList* list );
    TReadoutSpecified( const TReadoutSpecified& right );
    ~TReadoutSpecified();

  public:
    const TReadoutSpecified& operator=( const TReadoutSpecified& right );
    Tbool operator==( const TReadoutSpecified& right ) const;
    Tbool operator!=( const TReadoutSpecified& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TReadoutSpecified& right );

  public:
    const Tstring& GetListID() const;
    Tstring& GetListID();
    TReadoutList* GetReadoutList() const;
    Tvoid SetListID( const Tstring& id );
    Tvoid SetReadoutList( TReadoutList* list );

};

inline const Tstring& TReadoutSpecified::GetListID() const
{
  return theListID;
}

inline Tstring& TReadoutSpecified::GetListID()
{
  return theListID;
}

inline TReadoutList* TReadoutSpecified::GetReadoutList() const
{
  return theReadoutList;
}

inline Tvoid TReadoutSpecified::SetListID( const Tstring& id )
{
  theListID = id;
  return;
}

inline Tvoid TReadoutSpecified::SetReadoutList( TReadoutList* list )
{
  theReadoutList = list;
  return;
}

#endif
