// =====================================================================
/*!
//
//  \file TEnvironmentVariableTable.hh
//  \brief This file contains the TEnvironmentVariableTable class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TEnvironmentVariableTable.hh,v 1.5 2004/01/19 21:09:43 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: TEnvironmentVariableTable.hh,v $
//  Revision 1.5  2004/01/19 21:09:43  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:15  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:37:49  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:21:21  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TENVIRONMENTVARIABLETABLE_HH
#define CLDAQ__TENVIRONMENTVARIABLETABLE_HH

#include "Tglobals.h"

class TOutputHtmlFileStream;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TEnvironmentVariableTable
// \brief This is the TEnvironmentVariableTable class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TEnvironmentVariableTable class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup SystemCategory
*/
class TEnvironmentVariableTable
{

  public:
    enum { tNotFound = -1 };

  private:
    TstringList theItemList;
    TstringList theValueList;
    Tint theNumberOfEnvironments;

  public:
    TEnvironmentVariableTable();
    TEnvironmentVariableTable( const Tstring& rcfile );
    TEnvironmentVariableTable( const TstringList& itemlist );
    TEnvironmentVariableTable( const TstringList& itemlist, const TstringList& valuelist );
    TEnvironmentVariableTable( const TEnvironmentVariableTable& right );
    ~TEnvironmentVariableTable();

  public:
    const TEnvironmentVariableTable& operator=( const TEnvironmentVariableTable& right );
    Tbool operator==( const TEnvironmentVariableTable& right ) const;
    Tbool operator!=( const TEnvironmentVariableTable& right ) const;

  public:
    friend Tostream& operator<<( Tostream& tos, const TEnvironmentVariableTable& right );

  public:
    const TstringList& GetItemList() const;
    const TstringList& GetValueList() const;
    Tint GetNumberOfEnvironments() const;

  public:
    Tstring GetEnvironmentValue( const Tstring& item ) const;
    Tstring GetEnvironmentValue( Tint row ) const;
    Tstring GetEnvironmentItem( Tint row ) const;
    Tint FindEnvironmentItem( const Tstring& item ) const;
    Tint FindEnvironmentValue( const Tstring& value ) const;
    Tbool HasEnvironmentItem( const Tstring& item ) const;
    Tbool HasEnvironmentValue( const Tstring& value ) const;
    Tvoid UnsetEnvironment( const Tstring& item );
    Tvoid UnsetEnvironment( const TstringList& item );
    Tvoid SetEnvironment( const Tstring& item, const Tstring& value );
    Tvoid SetEnvironment( const TstringList& item, const TstringList& value );
    Tvoid SetEnvironment( const Tstring& rcfile );
    Tvoid ClearEnvironment();
    Tvoid ResetEnvironment();
    Tint GetIntegerValue( const Tstring& item ) const;
    Tdouble GetDoubleValue( const Tstring& item ) const;

};

inline const TstringList& TEnvironmentVariableTable::GetItemList() const
{
  return theItemList;
}

inline const TstringList& TEnvironmentVariableTable::GetValueList() const
{
  return theValueList;
}

inline Tint TEnvironmentVariableTable::GetNumberOfEnvironments() const
{
  return theNumberOfEnvironments;
}

#endif
