// =====================================================================
/*!
//
//  \file TOutputHtmlFileStream.hh
//  \brief This file contains the TOutputHtmlFileStream class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TOutputHtmlFileStream.hh,v 1.6 2004/01/19 21:09:43 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: TOutputHtmlFileStream.hh,v $
//  Revision 1.6  2004/01/19 21:09:43  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.5  2003/11/03 08:35:15  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.4  2003/10/06 16:37:49  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/07/30 16:21:21  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TOUTPUTHTMLFILESTREAM_HH
#define CLDAQ__TOUTPUTHTMLFILESTREAM_HH

#include "Tglobals.h"


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TOutputHtmlFileStream
// \brief This is the TOutputHtmlFileStream class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TOutputHtmlFileStream class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup SystemCategory
*/
class TOutputHtmlFileStream
  : public Tofstream
{

  public:
    enum {
      fopen = 0x01,
      fclose = 0x02,
      otable = 0x04, 
      ctable = 0x08, 
      wheader = 0x10, 
      wfooter = 0x20,
      title = 0x40
    };

  protected:
    Tint theStatus;
    Tstring theTitle;
    Tstring theFileName;

  public:
    TOutputHtmlFileStream();
    TOutputHtmlFileStream( const Tstring& filename );
    TOutputHtmlFileStream( const Tstring& filename, const Tstring& title );
    ~TOutputHtmlFileStream();

  public:
    virtual TOutputHtmlFileStream& WriteHeader();
    virtual TOutputHtmlFileStream& WriteFooter();
    virtual TOutputHtmlFileStream& OpenTable();
    virtual TOutputHtmlFileStream& CloseTable();

  public:
    Tbool IsOpen() const;
    Tbool IsClose() const;
    Tbool IsOpenTable() const;
    Tbool IsCloseTable() const;
    Tbool IsWrittenHeader() const;
    Tbool IsWrittenFooter() const;
    Tbool HasTitle() const;

  public:
    const Tstring& GetTitle() const;
    Tint GetStatus() const;
    const Tstring& GetFileName() const;
    Tvoid SetTitle( const Tstring& title );
    Tvoid SetStatus( Tint status );

  public:
    Tvoid Open( const Tstring& filename );
    Tvoid Open( const Tstring& filename, const Tstring& title );
    Tvoid Close();

  protected:
    Tint setStatusBit( Tint status );
    Tint clearStatusBit( Tint status );

};

inline const Tstring& TOutputHtmlFileStream::GetTitle() const
{
  return theTitle;
}

inline Tint TOutputHtmlFileStream::GetStatus() const
{
  return theStatus;
}

inline const Tstring& TOutputHtmlFileStream::GetFileName() const
{
  return theFileName;
}

inline Tvoid TOutputHtmlFileStream::SetTitle( const Tstring& title )
{
  theTitle = title;
  setStatusBit( TOutputHtmlFileStream::title );
  return;
}

inline Tvoid TOutputHtmlFileStream::SetStatus( Tint status )
{
  theStatus = status;
  return;
}

inline Tint TOutputHtmlFileStream::setStatusBit( Tint status )
{
  return theStatus |= status;
}

inline Tint TOutputHtmlFileStream::clearStatusBit( Tint status )
{
  return theStatus &= ~status;
}

inline Tbool TOutputHtmlFileStream::IsOpen() const
{
  return (Tbool)( theStatus & TOutputHtmlFileStream::fopen );
}

inline Tbool TOutputHtmlFileStream::IsClose() const
{
  return (Tbool)( theStatus & TOutputHtmlFileStream::fclose );
}

inline Tbool TOutputHtmlFileStream::IsOpenTable() const
{
  return (Tbool)( theStatus & TOutputHtmlFileStream::otable );
}

inline Tbool TOutputHtmlFileStream::IsCloseTable() const
{
  return (Tbool)( theStatus & TOutputHtmlFileStream::ctable );
}

inline Tbool TOutputHtmlFileStream::IsWrittenHeader() const
{
  return (Tbool)( theStatus & TOutputHtmlFileStream::wheader );
}

inline Tbool TOutputHtmlFileStream::IsWrittenFooter() const
{
  return (Tbool)( theStatus & TOutputHtmlFileStream::wfooter );
}

inline Tbool TOutputHtmlFileStream::HasTitle() const
{
  return (Tbool)( theStatus & TOutputHtmlFileStream::title );
}

#endif
