// =====================================================================
//  $Id: deserialize.cc,v 1.1 2003/12/06 11:08:15 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: deserialize.cc,v $
//  Revision 1.1  2003/12/06 11:08:15  goiwai
//  ǥꥢ饤Υå.
//  ǥꥢ饤ǡ쥳ɤΥǡ쥳ɤå
//  Ƥޤ.
//
// =====================================================================
#include "TOutputObjectFile.hh"
#include "TInputObjectFile.hh"
#include "TBenchmark.hh"
#include "TDataRecord.hh"
#include "TOption.hh"
#include "TOptionTable.hh"
#include "TArgument.hh"

int main( int argc, char** argv, char** envv )
{

  TArgument arg( argc, argv );
  if ( arg.GetNumberOfElements() != 1 || !isexist( arg[ 0 ] ) ) {
    arg.ShowUsage();
  }
  const Tstring filename = arg[ 0 ];
 
  TInputObjectFile ifile( filename );

  const Tint buflen = 0x100000;
  Tbyte buffer[ buflen ]; 

  TDataRecord record;
  TBenchmark bench;
  bench.Start();
  while ( ifile.Read( record ) ) {
    record.Serialize( buffer );
    TDataRecord rev;
    rev.Deserialize( buffer );
    Tcout << "RECORD MATCH: " << ( rev == record ) << Tendl;
    Tcout << "RECORD UNMATCH: " << ( rev != record ) << Tendl;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  return 0;
}
