package jp.ac.osaka_u.ist.sel.y_yuuki.cn.analyze;

import jp.ac.osaka_u.ist.sel.y_yuuki.cn.Logger;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Project;

/**
 * <p>\[XR[h̓NX</p>
 * @author y-yuuki
 *
 */
public class AnalyzeManager {
	
	/**
	 * <p>CCFinderX𗘗pāCN[擾</p>
	 * @param project@ProjectIuWFNg
	 * @return <ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 		@@  </ul>
	 */
	public static boolean getCloneInf(Project project){
		
		CCFXController controller = new CCFXController(project);		
		
		if(!controller.execute()){
			Logger.write("Error: Can't execute CCFinder.");
			return false;
		}
		
		
		if(!controller.readCloneDataFile()){
			Logger.write("Error: Can't read clone data file.");
			return false;
		}	
		
		try {
			if(!controller.readPrepFile()){
				Logger.write("Error: Can't read preprocess files.");
				return false;
			}
		} catch (Exception e) {
			Logger.write("Error: Can't read preprocess files.");
			return false;
		}
		
		if(!controller.getCloneMetrics()){
			Logger.write("Error: Can't read clone metrics file.");
			return false;
		}
		
		return true;	
		
	}
	
	/**
	 * <p>N[Zbg/N[ύX𕪗ނ</p>
	 * @param project vWFNgIuWFNg
	 * @return <ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 		@@  </ul>
	 */
	public static boolean categorizeClone(Project project){

		if(!DiffDetector.getDiff(project.getFileList())){
			Logger.write("Error: Can't get diff of source code.");
			return false;
		}
		
		CloneCategorizer.categorizeClone(project.getFileList());
		CloneSetCategorizer.categorizeClone(project.getCloneSetList());		
		
		return true;
		
	}

}
