package jp.ac.osaka_u.ist.sel.y_yuuki.cn.analyze;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

import jp.ac.osaka_u.ist.sel.y_yuuki.cn.Def;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.SourceFile;

/**
 * <p>DiffoNX</p>
 *
 */
public class DiffDetector {
	
	/**
	 * <p>\[Xt@CԂdiff̎擾</p>
	 * @param fileList
	 * @return <ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 		   </ul>
	 */
	public static boolean  getDiff(ArrayList<SourceFile> fileList){	
		for(SourceFile file: fileList){
			if(file.getState() == SourceFile.NORMAL && !(file.getNewCloneList().isEmpty() && !file.getOldCloneList().isEmpty()))
				if(!executeDiff(file))
					return false;
		}
		return true;
	}	

	/**
	 * <p>diff̎s</p>
	 * @param file
	 * @return@<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 		   </ul>
	 */
	private static boolean executeDiff(SourceFile file){	
		try{		
			String[] cmdArray = {Def.DIFF_PATH, file.getOldPath(), file.getNewPath()};
			ProcessBuilder pb = new ProcessBuilder(cmdArray);		
			Process p = pb.start();
			BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));	
			String line;
			
		    while((line=reader.readLine())!=null) {
		    	if(Character.isDigit(line.charAt(0))){	    	
		    		
		    		//ǉR[h
		    		if(line.contains("a")){
		    			int startLine,endLine;		    			
		    			String[] str1 = line.split("a"); String[] str2 = str1[1].split(",");
		    			if(str2.length==1){
		    				startLine = Integer.valueOf(str2[0]); endLine = Integer.valueOf(str2[0]);		    				
		    			}else{
		    				startLine = Integer.valueOf(str2[0]); endLine = Integer.valueOf(str2[1]);	
		    			}
		    			
		    			for(int i=startLine; i<=endLine; i++)
		    				file.getAddedCodeList().add(i);
		    		
		    			
		    		//폜R[h
		    		}else if(line.contains("d")){
		    			int startLine,endLine;
		    			String[] str1 = line.split("d"); String[] str2 = str1[0].split(",");
		    			if(str2.length==1){
		    				startLine = Integer.valueOf(str2[0]); endLine = Integer.valueOf(str2[0]);		    				
		    			}else{
		    				startLine = Integer.valueOf(str2[0]); endLine = Integer.valueOf(str2[1]);	
		    			}
		    			
		    			for(int i=startLine; i<=endLine; i++)
		    				file.getDeletedCodeList().add(i);
		    			
		    		//ύXR[h	
		    		}else if(line.contains("c")){
		    			int startLine,endLine;
		    			String[] str1 = line.split("c"); String[] str2 = str1[0].split(","); String[] str3 = str1[1].split(",");
		    			if(str2.length==1){
		    				startLine = Integer.valueOf(str2[0]); endLine = Integer.valueOf(str2[0]);		    				
		    			}else{
		    				startLine = Integer.valueOf(str2[0]); endLine = Integer.valueOf(str2[1]);	
		    			}
		    			for(int i=startLine; i<=endLine; i++)
		    				file.getDeletedCodeList().add(i);
		    			
		    			if(str3.length==1){
		    				startLine = Integer.valueOf(str3[0]); endLine = Integer.valueOf(str3[0]);		    				
		    			}else{
		    				startLine = Integer.valueOf(str3[0]); endLine = Integer.valueOf(str3[1]);	
		    			}
		    			for(int i=startLine; i<=endLine; i++)
		    				file.getAddedCodeList().add(i);		
		    		}
		    	}
		     }
		}catch (IOException e){
			return false;
		}			
		return true;
	}


}
