package jp.ac.osaka_u.ist.sel.y_yuuki.cn.data;

/**
 * <p>N[f[^NX</p>
 * @author y-yuuki
 */

public class Clone {
	
	private int id = NULL;
	private int outputId = NULL;
	private int startLine = NULL;
	private int startColumn = NULL;
	private int startToken = NULL;
	private int endLine = NULL;
	private int endColumn = NULL;
	private int endToken = NULL;
	private Clone parentClone = null;
	private Clone childClone = null;
	private int category = NULL;
	private CloneSet cloneSet = null;
	private SourceFile file =null;

	/** <p></p> */
	public final static int NULL = -1;
	
	/** <p>Stable Clone</p> */
	public final static int STABLE = 0;
	
	/** <p>Modified Clone</p> */
	public final static int MODIFIED = 1;
	
	/** <p>Moved Clone</p> */
	public final static int MOVED = 2;
	
	/** <p>Added Clone</p> */
	public final static int ADDED = 3;
	
	/** <p>Deleted Clone</p> */ 
	public final static int DELETED = 4;
	
	/**
	 * <p>N[ID̎擾</p>
	 * @return N[ID
	 */
	public int getId() {
		return id;
	}

	/**
	 * <p>N[ZbgID̎擾</p>
	 * @param id@N[ID
	 */
	public void setId(int id) {
		this.id = id;
	}

	/** <p>N[Jns̎擾</p>
	 * @return Jns
	 */
	public int getStartLine() {
		return startLine;
	}

	/**
	 * <p>N[Jns̐ݒ</p>
	 * @param startLine Jns
	 */
	public void setStartLine(int startLine) {
		this.startLine = startLine;
	}

	/**
	 * <p>N[Jn̎擾</p>
	 * @return Jn
	 */
	public int getStartColumn() {
		return startColumn;
	}

	/**
	 * <p>N[Jn̐ݒ</p>
	 * @param startColumn Jn
	 */
	public void setStartColumn(int startColumn) {
		this.startColumn = startColumn;
	}

	/**
	 * <p>N[Jng[N̎擾</p>
	 * @return Jng[N
	 */
	public int getStartToken() {
		return startToken;
	}

	/**
	 * <p>N[Jng[N̐ݒ</p>
	 * @param startToken Jng[N
	 */
	public void setStartToken(int startToken) {
		this.startToken = startToken;
	}

	/**
	 * <p>N[Is̎擾</p>
	 * @return Is
	 */
	public int getEndLine() {
		return endLine;
	}

	/**
	 * <p>N[Is̐ݒ</p>
	 * @param endLine Is
	 */
	public void setEndLine(int endLine) {
		this.endLine = endLine;
	}

	/**
	 * <p>N[I̎擾</p>
	 * @return I
	 */
	public int getEndColumn() {
		return endColumn;
	}

	/**
	 * <p>N[I̐ݒ</p>
	 * @param endColumn I
	 */
	public void setEndColumn(int endColumn) {
		this.endColumn = endColumn;
	}

	/**
	 * <p>N[Ig[N̎擾</p>
	 * @return Ig[N
	 */
	public int getEndToken() {
		return endToken;
	}

	/**
	 * <p>N[Ig[N̐ݒ</p>
	 * @param endToken
	 */
	public void setEndToken(int endToken) {
		this.endToken = endToken;
	}

	/**
	 * <p>eN[̎擾</p>
	 * @return eN[IuWFNg
	 */
	public Clone getParentClone() {
		return parentClone;
	}

	/**
	 * <p>eN[̐ݒ</p>
	 * @param parentClone eN[IuWFNg
	 */
	public void setParentClone(Clone parentClone) {
		this.parentClone = parentClone;
	}

	/**
	 * <p>qN[̎擾</p>
	 * @return qN[IuWFNg
	 */
	public Clone getChildClone() {
		return childClone;
	}
	
	/**
	 * <p>qN[̐ݒ</p>
	 * @param childClone qN[IuWFNg
	 */
	public void setChildClone(Clone childClone) {
		this.childClone = childClone;
	}

	/**
	 * <p>N[ނ̎擾</p>
	 * @return ޏ
	 */
	public int getCategory() {
		return category;
	}

	/**
	 *  <p>N[ނ̎擾</p>
	 * @return ޏ
	 */
	public String getCategoryString(){
		switch(category){
			case ADDED: return "ADDED";
			case DELETED: return "DELETED";
			case MODIFIED: return "MODIFIED";
			case MOVED: return "MOVED";
			case STABLE: return "STABLE";
			default: return null;
		}
	}
	
	/**
	 * <p>N[ނ̐ݒ</p>
	 * @param category ޏ
	 */
	public void setCategory(int category) {
		this.category = category;
	}	
	
	/**
	 * <p>N[N[Zbg̎擾</p>
	 * @return CloneSetIuWFNg
	 */
	public CloneSet getCloneSet() {
		return cloneSet;
	}

	/**
	 * <p>N[N[Zbg̐ݒ</p>
	 * @param cloneSet CloneSetIuWFNg
	 */
	public void setCloneSet(CloneSet cloneSet) {
		this.cloneSet = cloneSet;
	}

	
	/**
	 * <p>N[\[Xt@C̎擾</p>
	 * @return SourceFileIuWFNg
	 */
	public SourceFile getFile() {
		return file;
	}

	/**
	 * <p>N[\[Xt@C̐ݒ</p>
	 * @param file SourceFileIuWFNg
	 */
	public void setFile(SourceFile file) {
		this.file = file;
	}

	/**
	 * <p>o͗pID̎擾</p>	
	 * @return o͗pID
	 */
	public int getOutputId() {
		return outputId;
	}

	/**
	 * <p>o͗pID̐ݒ</p>
	 * @param outputId o͗pID
	 */
	public void setOutputId(int outputId) {
		this.outputId = outputId;
	}

	/**
	 * <p>IuWFNg̓̔</p>
	 */
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Clone other = (Clone) obj;
		if (endToken != other.endToken)
			return false;
		if (file != other.file)
			return false;
		if (startToken != other.startToken)
			return false;
		return true;
	}


}
