package jp.ac.osaka_u.ist.sel.y_yuuki.cn.data;

import java.util.ArrayList;

/**
 * <p>N[Zbgf[^NX</p>
 * @author y-yuuki 
 */
public class CloneSet {
	

	private ArrayList<Clone> newCloneList = new ArrayList<Clone>() ;
	private ArrayList<Clone> oldCloneList = new ArrayList<Clone>() ;
	private int outputId;
	private int id = NULL;
	private int category = NULL;
	
	//gNX
	private int LEN = NULL;
	private int POP = NULL;
	private int NIF = NULL;
	private int RAD = NULL;
	private double RNR = NULL;
	private int TKS = NULL;
	private int LOOP = NULL;
	private int COND = NULL;
	private int McCabe = NULL;

	/** <p></p> */
	public final static int NULL = -1;
	
	/** <p>Stable Clone Set</p> */
	public final static int STABLE = 3;
	
	/** <p>Changed Clone Set</p> */
	public final static int CHANGED = 1;
	
	/** <p>Deleted Clone</p> */
	public final static int DELETED = 2;
	
	/** <p>New Clone</p> */
	public final static int NEW = 0;

	/**
	 * <p>Vo[W̃N[Xg̎擾</p>
	 * @return N[Xg
	 */
	public ArrayList<Clone> getNewCloneList() {
		return newCloneList;
	}

	/**
	 * <p>o[W̃N[Xg̎擾</p>
	 * @return N[Xg
	 */
	public ArrayList<Clone> getOldCloneList() {
		return oldCloneList;
	}

	/**
	 * <p>N[ZbgID̎擾</p>
	 * @return N[ZbgID
	 */
	public int getId() {
		return id;
	}

	/**
	 * <p>N[ZbgID̐ݒ</p>
	 * @param id@N[ZbgID
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * <p>N[Zbgނ̎擾</p>
	 * @return ޏ
	 */
	public int getCategory() {
		return category;
	}
	
	/**
	 *  <p>N[ނ̎擾</p>
	 * @return ޏ
	 */
	public String getCategoryString(){
		switch(category){
			case NEW: return "NEW";
			case DELETED: return "DELETED";
			case CHANGED: return "CHANGED";
			case STABLE: return "STABLE";
			default: return null;
		}
	}

	/**
	 * <p>N[Zbgނ̐ݒ</p>
	 * @param category ޏ
	 */
	public void setCategory(int category) {
		this.category = category;
	}
	
	/**
	 * <p>o͗pID̎擾</p>	
	 * @return o͗pID
	 */
	public int getOutputId() {
		return outputId;
	}

	/**
	 * <p>o͗pID̐ݒ</p>
	 * @param outputId o͗pID
	 */
	public void setOutputId(int outputId) {
		this.outputId = outputId;
	}

	/**
	 * <p>LENgNXl̎擾</p>
	 * @return LENgNXl
	 */
	public int getLEN() {
		return LEN;
	}

	/**
	 * <p>LENgNXl̐ݒ</p>
	 * @param len LENgNXl
	 */
	public void setLEN(int LEN) {
		this.LEN = LEN;
	}	

	/**
	 * <p>POPgNXl̎擾</p>
	 * @return POPgNXl
	 */
	public int getPOP() {
		return POP;
	}

	/**
	 * <p>POPgNXl̐ݒ</p>
	 * @param pOP POPgNXl
	 */
	public void setPOP(int pOP) {
		POP = pOP;
	}

	/**
	 * <p>NIFgNXl̎擾</p>
	 * @return NIFgNXl
	 */
	public int getNIF() {
		return NIF;
	}

	/**
	 * <p>NIFgNXl̐ݒ</p>
	 * @param nIF NIFgNXl
	 */
	public void setNIF(int nIF) {
		NIF = nIF;
	}

	/**
	 * <p>RADgNXl̎擾</p>
	 * @return RADgNXl
	 */
	public int getRAD() {
		return RAD;
	}

	/**
	 * <p>RADgNXl̐ݒ</p>
	 * @param rAD RADgNXl
	 */
	public void setRAD(int rAD) {
		RAD = rAD;
	}

	/**
	 * <p>RNRgNXl̎擾</p>
	 * @return RNRgNXl
	 */
	public double getRNR() {
		return RNR;
	}
	
	/**
	 * <p>RNRgNXl̐ݒ</p>
	 * @param rNR RNRgNXl
	 */
	public void setRNR(double rNR) {
		RNR = rNR;
	}

	/**
	 * <p>TKSgNXl̎擾</p>
	 * @return TKSgNXl
	 */
	public int getTKS() {
		return TKS;
	}

	/**
	 * <p>TKSgNXl̐ݒ</p>
	 * @param tKS TKSgNXl
	 */
	public void setTKS(int tKS) {
		TKS = tKS;
	}
	
	/**
	 * <p>LOOPgNXl̎擾</p>
	 * @return LOOPgNXl
	 */
	public int getLOOP() {
		return LOOP;
	}

	/**
	 * <p>LOOPl̐ݒ</p>
	 * @param lOOP LOOPgNXl
	 */
	public void setLOOP(int lOOP) {
		LOOP = lOOP;
	}

	/**
	 * <p>CONDgNXl̎擾</p>
	 * @return CONDgNXl
	 */
	public int getCOND() {
		return COND;
	}

	/**
	 * <p>CONDgNXl̐ݒ</p>
	 * @param cOND CONDgNXl
	 */
	public void setCOND(int cOND) {
		COND = cOND;
	}

	/**
	 * <p>McCabegNXl̎擾</p>
	 * @return McCabegNXl
	 */
	public int getMcCabe() {
		return McCabe;
	}


	/**
	 * <p>McCabegNXl̐ݒ</p>
	 * @param mcCabe McCabegNXl
	 */
	public void setMcCabe(int mcCabe) {
		McCabe = mcCabe;
	}


	/**
	 * <p>Deleted Clone/Moved Clone܂܂邩</p>
	 * @return	<ul>
	 * 				<li>܂܂ꍇ - true</li>
	 *				<li>܂܂Ȃꍇ - false</li>
	 * 			</ul>
	 */
	public boolean containsOldClone() {		
		for(Clone clone: oldCloneList){
			if(clone.getCategory()==Clone.MOVED||clone.getCategory()==Clone.DELETED)
				return true;
		}
		return false;
	}
	
}
