package jp.ac.osaka_u.ist.sel.y_yuuki.cn.generate;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Clone;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.CloneSet;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Project;

/**
 * <p>CSVo̓NX</p>
 * @author y-yuuki
 */
public class CSVGenerator {	

	private static PrintWriter writer=null;

	/**
	 * <p>CSVt@C</p>
	 * @param generator OutputGeneratorIuWFNg
	 * @param project ProjectIuWFNg
	 * @return	<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	public static boolean generateCSVFile(OutputGenerator generator, Project project){
		try{	
			writer = new PrintWriter(new BufferedWriter(new FileWriter(project.getGenerateCSVDir()+"//"+ project.getGenerateCSVFileName())));
			writer.print("\"ID\",");
			writer.print("\"CATEGORY\",");
			writer.print("\"LEN\",");
			writer.print("\"POP\",");
			writer.print("\"NIF\",");
			writer.print("\"RAD\",");
			writer.print("\"RNR\",");
			writer.print("\"TKS\",");
			writer.print("\"LOOP\",");
			writer.print("\"COND\",");
			writer.print("\"McCabe\",");
			writer.println();
			for(CloneSet cloneSet: project.getCloneSetList()){
				writer.print("\"");
				writer.print(cloneSet.getOutputId());
				writer.print("\",\"");
				writer.print(cloneSet.getCategoryString());
				writer.print("\",\"");
				writer.print(cloneSet.getLEN());
				writer.print("\",\"");
				writer.print(cloneSet.getPOP());
				writer.print("\",\"");
				writer.print(cloneSet.getNIF());
				writer.print("\",\"");
				writer.print(cloneSet.getRAD());
				writer.print("\",\"");
				writer.print(cloneSet.getRNR());
				writer.print("\",\"");
				writer.print(cloneSet.getTKS());
				writer.print("\",\"");
				writer.print(cloneSet.getLOOP());
				writer.print("\",\"");
				writer.print(cloneSet.getCOND());
				writer.print("\",\"");
				writer.print(cloneSet.getMcCabe());
				writer.println("\"");
			}			
			writer.flush();
			writer.close();
		}catch (IOException e) {
			return false;
		}

		
		return true;
	}
			
			
	/**
	 * <p>CSVt@C</p>
	 * @param generator OutputGeneratorIuWFNg
	 * @param project ProjectIuWFNg
	 * @return	<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	public static boolean generateCSVFile2(OutputGenerator generator, Project project){
		try{	
			writer = new PrintWriter(new BufferedWriter(new FileWriter(project.getGenerateCSVDir()+"//"+ project.getGenerateCSVFileName())));
			writer.print("\"CLONESET_ID\",");
			writer.print("\"CLONE_ID\",");
			writer.print("\"CLONESET_CATEGORY\",");
			writer.print("\"CLONE_CATEGORY\",");		
			writer.print("\"FILE_NAME\",");
			writer.print("\"LOCATION\",");			
			writer.print("\"LEN\",");
			writer.print("\"POP\",");
			writer.print("\"NIF\",");
			writer.print("\"RAD\",");
			writer.print("\"RNR\",");
			writer.print("\"TKS\",");
			writer.print("\"LOOP\",");
			writer.print("\"COND\",");
			writer.print("\"McCabe\",");
			writer.println();
			for(CloneSet cloneSet: project.getCloneSetList()){
				for(Clone clone: cloneSet.getNewCloneList()){					
					writer.print("\"");
					writer.print(cloneSet.getOutputId());
					writer.print("\",\"");
					writer.print(clone.getOutputId());
					writer.print("\",\"");
					writer.print(cloneSet.getCategoryString());
					writer.print("\",\"");
					writer.print(clone.getCategoryString());
					writer.print("\",\"");
					writer.print(clone.getFile().getName());
					writer.print("\",\"");
					writer.printf("%d.%d-%d.%d",clone.getStartLine(),clone.getStartColumn(),clone.getEndLine(),clone.getEndColumn ());
					writer.print("\",\"");
					writer.print(cloneSet.getLEN());
					writer.print("\",\"");
					writer.print(cloneSet.getPOP());
					writer.print("\",\"");
					writer.print(cloneSet.getNIF());
					writer.print("\",\"");
					writer.print(cloneSet.getRAD());
					writer.print("\",\"");
					writer.print(cloneSet.getRNR());
					writer.print("\",\"");
					writer.print(cloneSet.getTKS());
					writer.print("\",\"");
					writer.print(cloneSet.getLOOP());
					writer.print("\",\"");
					writer.print(cloneSet.getCOND());
					writer.print("\",\"");
					writer.print(cloneSet.getMcCabe());
					writer.println("\"");
				}
				for(Clone clone: cloneSet.getOldCloneList()){
					if(clone.getCategory()==Clone.DELETED){
						writer.print("\"");
						writer.print(cloneSet.getOutputId());
						writer.print("\",\"");
						writer.print(clone.getOutputId());
						writer.print("\",\"");
						writer.print(cloneSet.getCategoryString());
						writer.print("\",\"");
						writer.print(clone.getCategoryString());
						writer.print("\",\"");
						writer.print(clone.getFile().getName());
						writer.print("\",\"");
						writer.printf("%d.%d-%d.%d",clone.getStartLine(),clone.getStartColumn(),clone.getEndLine(),clone.getEndColumn ());
						writer.print("\",\"");
						writer.print(cloneSet.getLEN());
						writer.print("\",\"");
						writer.print(cloneSet.getPOP());
						writer.print("\",\"");
						writer.print(cloneSet.getNIF());
						writer.print("\",\"");
						writer.print(cloneSet.getRAD());
						writer.print("\",\"");
						writer.print(cloneSet.getRNR());
						writer.print("\",\"");
						writer.print(cloneSet.getTKS());
						writer.print("\",\"");
						writer.print(cloneSet.getLOOP());
						writer.print("\",\"");
						writer.print(cloneSet.getCOND());
						writer.print("\",\"");
						writer.print(cloneSet.getMcCabe());
						writer.println("\"");
					}
				}	
			}
			writer.flush();
			writer.close();
		}catch (IOException e) {
			return false;
		}

		
		return true;
	}
	

}
