package jp.ac.osaka_u.ist.sel.y_yuuki.cn.generate;

import java.io.File;
import java.util.Calendar;

import jp.ac.osaka_u.ist.sel.y_yuuki.cn.Logger;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Clone;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.CloneSet;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Project;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.SourceFile;

/**
 * <p>ތʏo̓NX</p>
 * @author y-yuuki</p>
 */

public class OutputGenerator{
	
	//vWFNg
	private int fileNum=0;
	private int addedFileNum=0;
	private int deletedFileNum=0;
	private int cloneFileNum=0;
	
	//N[
	private int cloneSetNum=0;
	private int stableCloneNum=0;
	private int addedCloneNum=0;
	private int deletedCloneNum=0;
	private int modifiedCloneNum=0;
	private int movedCloneNum=0;
	
	//N[Zbg
	private int cloneNum=0;
	private int stableCloneSetNum=0;
	private int newCloneSetNum=0;
	private int deletedCloneSetNum=0;
	private int changedCloneSetNum=0;	
	
	// ttB[h
	private String year;
	private String month;
	private String day;

	private Project project = null;
	
	/**
	 * <p>RXgN^</p>
	 * @param project ProjectIuWFNg
	 */
	public OutputGenerator(Project project){
		this.project = project;	
		
		//\[g
		project.sortCloneSetListbyLEN();
		project.sortCloneSetListbyCategory();
		
		//oIDt
		int cloneSetId=0;
		for(CloneSet cloneSet: project.getCloneSetList()){
			cloneSet.setOutputId(cloneSetId++);
			int cloneId=0;
			for(Clone clone: cloneSet.getNewCloneList()){
				clone.setOutputId(cloneId++);
			}	
			for(Clone clone: cloneSet.getOldCloneList()){
				if(clone.getCategory() == Clone.DELETED)  
					clone.setOutputId(cloneId++);;
			}
			
		}
		
		//t@ČvZ
		for(SourceFile file:project.getFileList()){
			switch(file.getState()){
				case SourceFile.ADDED: 		addedFileNum++; fileNum++; break;
				case SourceFile.DELETED:	deletedFileNum++; break;
				case SourceFile.NORMAL:		fileNum++;
			}				
			if(!file.getNewCloneList().isEmpty())
				cloneFileNum++;				
		}
		
	
		//N[/N[ZbǧvZ
		for(CloneSet cloneSet: project.getCloneSetList()){
			switch(cloneSet.getCategory()){
				case CloneSet.STABLE:  	stableCloneSetNum++;  	cloneSetNum++; break;
				case CloneSet.CHANGED:  changedCloneSetNum++; 	cloneSetNum++; break;
				case CloneSet.NEW:  	newCloneSetNum++;  		cloneSetNum++; break;
				case CloneSet.DELETED:  deletedCloneSetNum++; break;
			}
		
			for(Clone clone: cloneSet.getNewCloneList()){
				cloneNum++;
				switch(clone.getCategory()){
					case Clone.STABLE:  	stableCloneNum++; break;
					case Clone.MODIFIED:  	modifiedCloneNum++; break;
					case Clone.MOVED: 	 	movedCloneNum++; break;
					case Clone.ADDED:  		addedCloneNum++; break;
				}
			}	
			for(Clone clone: cloneSet.getOldCloneList()){
				if(clone.getCategory() == Clone.DELETED)  deletedCloneNum++;
			}
		}		
		
		//tݒ
		Calendar now = Calendar.getInstance(); 
		year = Integer.toString(now.get(Calendar.YEAR));
		month = Integer.toString(now.get(Calendar.MONTH)+1);
		if(month.length()==1) month = "0"+month;
		day = Integer.toString(now.get(Calendar.DATE));
		if(day.length()==1) day = "0"+day;
				
	}
	
	/**
	 * <p>eLXgt@C</p>
	 * @return	<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	public boolean generateTextFile(){		
		project.setGenerateTextFileName(project.getName()+year+month+day+".txt");
		File file = new File(project.getGenerateTextDir());		
		if(!file.exists())	file.mkdirs();			
		if(!TextFileGenerator.generateTextFile(this,project)){
			Logger.write("Error: Can't generate text file.");
			return false;
		}
		Logger.write("Success: Generate text file.");
		return true;			
	}
	
	/**
	 * <p>CSVt@C</p>
	 * @return <ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	public boolean generateCSVFile(){		
		project.setGenerateCSVFileName(project.getName()+year+month+day+".csv");
		File file = new File(project.getGenerateCSVDir());		
		if(!file.exists())	file.mkdirs();			
		if(!CSVGenerator.generateCSVFile(this,project)){
			Logger.write("Error: Can't generate CSV file.");
			return false;
		}
		Logger.write("Success: Generate CSV file.");
		return true;	
	}
	
	/**
	 * <p>HTMLt@C</p>
	 * @return <ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	public boolean generateHTMLFile(){	
		File file = new File(project.getGenerateHTMLDir());		
		if(!file.exists())	file.mkdirs();	
		if(!HTMLFileGenerater.generateHTMLFile(this, project)){
			Logger.write("Error: Can't generate HTML files.");
			return false;
		}
		Logger.write("Success: Generate HTML files.");
		return true;	
	}			
	
	/**
	 * <p>t@C̎擾<p>
	 * @return
	 */
	public int getFileNum() {
		return fileNum;
	}

	/**
	 * <p>ǉt@C̎擾<p>
	 * @return
	 */
	public int getAddedFileNum() {
		return addedFileNum;
	}

	/**
	 * <p>폜t@C̎擾<p>
	 * @return
	 */
	public int getDeletedFileNum() {
		return deletedFileNum;
	}

	/**
	 * <p>N[t@C̎擾</p>
	 * @return
	 */
	public int getCloneFileNum() {
		return cloneFileNum;
	}

	/**
	 * <p>Stable Clone ̎擾</p>
	 * @return
	 */
	public int getStableCloneNum() {
		return stableCloneNum;
	}

	/**
	 * <p>Added Clone ̎擾</p>
	 * @return
	 */
	public int getAddedCloneNum() {
		return addedCloneNum;
	}

	/**
	 * <p>Deleted Clone ̎擾</p>
	 * @return
	 */
	public int getDeletedCloneNum() {
		return deletedCloneNum;
	}

	/**
	 * <p>Modified Clone ̎擾</p>
	 * @return
	 */
	public int getModifiedCloneNum() {
		return modifiedCloneNum;
	}

	/**
	 * <p>Moved Clone ̎擾</p>
	 * @return
	 */
	public int getMovedCloneNum() {
		return movedCloneNum;
	}

	/**
	 * <p>N[̎擾</p>
	 * @return
	 */
	public int getCloneNum() {
		return cloneNum;
	}

	/**
	 * <p>Stable CloneSet ̎擾</p>
	 * @return
	 */
	public int getStableCloneSetNum() {
		return stableCloneSetNum;
	}

	/**
	 * <p>New CloneSet ̎擾</p>
	 * @return
	 */
	public int getNewCloneSetNum() {
		return newCloneSetNum;
	}

	/**
	 * <p>Deleted CloneSet ̎擾</p>
	 * @return
	 */
	public int getDeletedCloneSetNum() {
		return deletedCloneSetNum;
	}

	/**
	 * <p>Changed CloneSet ̎擾</p>
	 * @return
	 */
	public int getChangedCloneSetNum() {
		return changedCloneSetNum;
	}

	/**
	 * <p>N[Zbg̎擾</p>
	 * @return
	 */
	public int getCloneSetNum() {
		return cloneSetNum;
	}
	
	/**
	 * <p>N̎擾</p>
	 * @return
	 */
	public String getYear() {
		return year;
	}

	/**
	 * <p>̎擾</p>
	 * @return
	 */
	public String getMonth() {
		return month;
	}

	/**
	 * <p>̎擾</p>
	 * @return
	 */
	public String getDay() {
		return day;
	}
	
}
