package jp.ac.osaka_u.ist.sel.y_yuuki.cn.generate;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Clone;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.CloneSet;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Project;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.SourceFile;

/**
 * <p>eLXgt@Co̓NX</p>
 * @author y-yuuki
 */
public class TextFileGenerator{


	private static PrintWriter writer=null;
	private static int EXTRA_LINE = 3; 

	/**
	 * <p>eLXgt@C</p>
	 * @param generator OutputGeneratorIuWFNg
	 * @param project ProjectIuWFNg
	 * @return	<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	public static boolean generateTextFile(OutputGenerator generator, Project project){
		
		try {
			
			writer = new PrintWriter(new BufferedWriter(new FileWriter(project.getGenerateTextDir()+"//"+ project.getGenerateTextFileName())));
			
			//vWFNg^Cg
			writer.println("###################################################################"); 
			writer.println("\tvWFNg: "+project.getName());
			writer.println("\tF "+ project.getLang());
			writer.println("###################################################################");
			
			writer.println();
			
			
			writer.println("t@C ");
			writer.printf("\t-t@CF%d\r\n",generator.getFileNum());
			writer.printf("\t-ǉt@CF%d\r\n",generator.getAddedFileNum());
			writer.printf("\t-폜t@CF%d\r\n",generator.getDeletedFileNum());
			writer.printf("\t-N[܂ރt@CF%d\r\n",generator.getCloneFileNum());
			writer.println();
			
			writer.println("N[Zbgސ");
			writer.printf("\t-STABLE Clone SetF%d\r\n",generator.getStableCloneSetNum());
			writer.printf("\t-CHANGED Clone SetF%d\r\n",generator.getChangedCloneSetNum());
			writer.printf("\t-NEW Clone SetF%d\r\n",generator.getNewCloneSetNum());
			writer.printf("\t-DELETED Clone SetF%d\r\n",generator.getDeletedCloneSetNum());	
			writer.println();
			

			writer.println("N[");
			writer.printf("\t-STABLE CloneF%d\r\n",generator.getStableCloneNum());
			writer.printf("\t-MODIFIED Clone:%d\r\n",generator.getModifiedCloneNum());
			writer.printf("\t-MOVED CloneF%d\r\n",generator.getMovedCloneNum());
			writer.printf("\t-ADDED CloneF%d\r\n",generator.getAddedCloneNum());
			writer.printf("\t-DELETED CloneF%d\r\n",generator.getDeletedCloneNum());		
			writer.println();			
			
			
			//New N[Zbg
			writer.println("###################################################################");
			writer.println("    New Clone Set ꗗ");
			writer.println("###################################################################");
			
			if(generator.getNewCloneSetNum()>0){
				for(CloneSet cloneSet: project.getCloneSetList()){
					if(cloneSet.getCategory()==CloneSet.NEW)
						outputCloneSet(cloneSet);									
				}
			}else{
				writer.println("New Clone Set ͌o܂ł");
				writer.println();
			}
			
			//Changed N[Zbg
			writer.println("###################################################################");
			writer.println("    Changed Clone Set ꗗ");
			writer.println("###################################################################");
			
			if(generator.getChangedCloneSetNum()>0){
				for(CloneSet cloneSet: project.getCloneSetList()){
					if(cloneSet.getCategory()==CloneSet.CHANGED)
						outputCloneSet(cloneSet);									
				}
			}else{
					writer.println("Changed Clone Set ͌o܂ł");
					writer.println();
			}
		
			//Deleted N[Zbg
			writer.println("###################################################################");
			writer.println("    Deleted Clone Set ꗗ");
			writer.println("###################################################################");
			if(generator.getDeletedCloneSetNum()>0){
				for(CloneSet cloneSet: project.getCloneSetList()){
					if(cloneSet.getCategory()==CloneSet.DELETED)
						outputCloneSet(cloneSet);									
				}
			}else{
				writer.println("Deleted Clone Set ͌o܂ł");
				writer.println();
			}
				
			return true;
		} catch (IOException e) {
			return false;
		}finally{
			if(writer!=null){
				writer.flush(); 
				writer.close();
			}
		}
	}
	
	/**
	 * <p>N[Zbg̏o</p>
	 * @param cloneSet CloneSetIuWFNg
	 * @throws IOException 
	 */
	private static void outputCloneSet(CloneSet cloneSet) throws IOException{
	
		//wb_o
		writer.printf("*************************************************************\r\n");
		writer.printf("  @CloneSet%d\r\n",cloneSet.getOutputId());
		writer.printf("*************************************************************\r\n");
		
		//N[Xg̏o
		for(Clone clone: cloneSet.getNewCloneList()){
			writer.printf("@%d.%d",clone.getCloneSet().getOutputId(),clone.getOutputId());
			writer.printf("\t%s\t%s\t%d.%d-%d.%d\r\n",
					clone.getCategoryString(),
					clone.getFile().getName(),
					clone.getStartLine(),
					clone.getStartColumn(),
					clone.getEndLine(),
					clone.getEndColumn());
		}	
		
		if(!cloneSet.containsOldClone())
			writer.println("----Previous Version----");
		for(Clone clone: cloneSet.getOldCloneList()){
			if(clone.getCategory()==Clone.MOVED||clone.getCategory()==Clone.DELETED){
				if(clone.getCategory()==Clone.MOVED) 
					clone = clone.getChildClone();				
				writer.printf("@%d.%d",clone.getCloneSet().getOutputId(),clone.getOutputId());
				writer.printf("\t%s\t%s\t%d.%d-%d.%d\r\n",
						clone.getCategoryString(),
						clone.getFile().getName(),
						clone.getStartLine(),
						clone.getStartColumn(),
						clone.getEndLine(),
						clone.getEndColumn());	
			}
		}
		
		//N[R[h̏o
		boolean stableFlg=true;
		for(Clone clone: cloneSet.getNewCloneList()){
			writer.println("-------------------------------------------------");				
			if(clone.getCategory()==Clone.STABLE){
				writer.println("Stable Clone ̃Tv"); 
				stableFlg=false;				
			}
			writer.printf("@%d.%d\r\n",clone.getCloneSet().getOutputId(),clone.getOutputId());
			writer.printf("%s\r\n",clone.getFile().getName());
			outputCloneCode(clone);
			if(stableFlg==false) 
				break;
		}
		
		for(Clone clone: cloneSet.getOldCloneList()){
			if(clone.getCategory()==Clone.MOVED) 
				clone = clone.getChildClone();	
			writer.println("-------------------------------------------------");	
			writer.printf("@%d.%d\r\n",clone.getCloneSet().getOutputId(),clone.getOutputId());
			writer.printf("%s\r\n",clone.getFile().getName());
			outputCloneCode(clone);
		}		
		writer.println();
	}
	
	/**
	 * <p>R[hЂ̏o</p>
	 * @param clone - o̓N[
	 * @throws IOException 
	 */
	private static void outputCloneCode(Clone clone) throws IOException {

		/*
		 * ǉt@C̏ꍇ
		 */
		if(clone.getFile().getState()==SourceFile.ADDED){			
			BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(clone.getFile().getNewPath())));
			int lineNum = 0; 
			String line;
			while((line = reader.readLine())!=null){
				lineNum++;				
				if( clone.getStartLine() == lineNum) 
					outputCloneStartSign(clone);		
				if(lineNum >= clone.getStartLine()-EXTRA_LINE && lineNum <= clone.getEndLine()+EXTRA_LINE){
						writer.printf("%-4d",lineNum);
						writer.println("+ "+line);
				}
				if(clone.getEndLine() == lineNum) 
					outputCloneEndSign();						
			}
			reader.close();
			
		/*
		 * 폜t@C
		 */
		}else if(clone.getFile().getState()==SourceFile.DELETED){			
			BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(clone.getFile().getOldPath())));
			int lineNum = 0; 
			String line;
			while((line = reader.readLine())!=null){
				lineNum++;				
				if( clone.getStartLine() == lineNum)	outputCloneStartSign(clone);				
				if(lineNum >= clone.getStartLine()-EXTRA_LINE && lineNum <= clone.getEndLine()+EXTRA_LINE){
						writer.printf("%-4d",lineNum);	
						writer.println("- "+line);
					}
				if(clone.getEndLine() == lineNum) 
					outputCloneEndSign();						
			}
			reader.close();
			
		/*
		 * t@C 
		 */			
		}else{
			
			int addCodeId = 0, deleteCodeId = 0;
			int lineNumA=0,lineNumB=0;
			String lineA,lineB;
	
			BufferedReader readerA = new BufferedReader(new InputStreamReader(new FileInputStream(clone.getFile().getNewPath())));
			BufferedReader readerB = new BufferedReader(new InputStreamReader(new FileInputStream(clone.getFile().getOldPath())));
			
			int outputStart = clone.getStartLine() - EXTRA_LINE;
			int outputEnd = clone.getEndLine() + EXTRA_LINE;			
			boolean cloneFlg=false;
			
			/*
			 * DeletedClonełȂꍇ
			 */
			if(clone.getCategory()!=Clone.DELETED){
				
				while(true){				
					if((lineA = readerA.readLine())!=null)	lineNumA++;				
					if((lineB = readerB.readLine())!=null)	lineNumB++;				
					if(lineA==null && lineB==null)	break;
									
					//ǉs̏ꍇ
					while(addCodeId < clone.getFile().getAddedCodeList().size() && lineNumA == clone.getFile().getAddedCodeList().get(addCodeId)){					
						addCodeId++;	
						if((lineNumA >= outputStart && lineNumA <= outputEnd) && lineA!=null) {cloneFlg = true;}
						else if(lineNumA>outputEnd) {cloneFlg = false; break;}					
						if(cloneFlg){
							if(clone.getStartLine() == lineNumA)	
								outputCloneStartSign(clone);
							writer.printf("%-4d",lineNumA);	
							writer.println("+ "+lineA);
							if(clone.getEndLine() == lineNumA) 
								outputCloneEndSign();											
						}					
						if((lineA = readerA.readLine())!=null) 
							lineNumA++;					
					}
						
					//폜s̏ꍇ
					while(deleteCodeId < clone.getFile().getDeletedCodeList().size() &&lineNumB == clone.getFile().getDeletedCodeList().get(deleteCodeId)){
						deleteCodeId++;
						if(cloneFlg){	writer.printf("%-4s"," ");	writer.println("- "+lineB); };
						if((lineB = readerB.readLine())!=null) lineNumB++;	
					}
					
					//ʏR[h̏ꍇ
					if(lineNumA >= outputStart && lineNumA <= outputEnd && lineA!=null) {cloneFlg = true;}
					else if(lineNumA>outputEnd) {cloneFlg = false; break;}				
					if(cloneFlg){
						if(clone.getStartLine() == lineNumA)	
							outputCloneStartSign(clone);
						writer.printf("%-4d",lineNumA);	
						writer.println("@ "+lineA);
						if(clone.getEndLine() == lineNumA) 
							outputCloneEndSign();											
					}										
				}				
			}
			
			/*
			 * DeletedClonȅꍇ
			 */
			if(clone.getCategory()==Clone.DELETED){
				
				while(true){				
					if((lineA = readerA.readLine())!=null)	lineNumA++;				
					if((lineB = readerB.readLine())!=null)	lineNumB++;				
					if(lineA==null && lineB==null)	break;
					
					//ǉs̏ꍇ
					while(addCodeId < clone.getFile().getAddedCodeList().size() && lineNumA == clone.getFile().getAddedCodeList().get(addCodeId)){					
						addCodeId++;	
						if(cloneFlg) {writer.printf("%-4s"," ");	
						writer.println("+ "+lineA);}
						if((lineA = readerA.readLine())!=null) 
							lineNumA++;					
					}
						
					//폜s̏ꍇ
					while(deleteCodeId < clone.getFile().getDeletedCodeList().size() && lineNumB == clone.getFile().getDeletedCodeList().get(deleteCodeId)){
						deleteCodeId++;	
						if(lineNumB >= outputStart && lineNumB <= outputEnd && lineB!=null) {cloneFlg = true;}
						else if(lineNumB>outputEnd) {cloneFlg = false; break;}					
						if(cloneFlg){
							if(clone.getStartLine() == lineNumB)	
								outputCloneStartSign(clone);
							writer.printf("%-4d",lineNumB);	
							writer.println("- "+lineB);
							if(clone.getEndLine() == lineNumB) 
								outputCloneEndSign();											
						}					
						if((lineB = readerB.readLine())!=null) 
							lineNumB++;	
					}
					
					//ʏR[h̏ꍇ
					if(lineNumB >= outputStart && lineNumB <= outputEnd && lineB!=null) {cloneFlg = true;}
					else if(lineNumB>outputEnd) {cloneFlg = false; break;}					
					if(cloneFlg){
						if(clone.getStartLine() == lineNumB)	
							outputCloneStartSign(clone);
						writer.printf("%-4d",lineNumB);	
						writer.println("  "+lineB);
						if(clone.getEndLine() == lineNumB) 
							outputCloneEndSign();											
					}										
				}				
			}	
			readerA.close();
			readerB.close();
		}	
	}
	
	/**
	 * <p>N[JnTC̏o</p>
	 */	
	private static void outputCloneStartSign(Clone clone){		
		writer.println("    <START "+ clone.getCategoryString()+"Clone>");	
	}	
	
	/**
	 * <p>N[ITC̏o</p>
	 */	
	private static void outputCloneEndSign(){		
		writer.println("    <END>");
	}

}
