package jp.ac.osaka_u.ist.sel.y_yuuki.cn.mail;

import java.util.Properties;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.*;
import javax.mail.internet.*;

import jp.ac.osaka_u.ist.sel.y_yuuki.cn.Logger;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Account;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Project;

/**
 * <p>dq[MNX</p>
 * @author y-yuuki
 *
 */
public class MailSender {

	/**
	 * <p>[M</p>
	 * @param project ProjectIuWFNg
	 * @return	<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	public static boolean sendMail(Project project){
		
		try{ 			
			
			Properties props = new Properties();
			props.put("mail.smtp.host",project.getHost());
			props.put("mail.smtp.auth","true");
			props.put("mail.smtp.port", String.valueOf(project.getPort()));
		
			if(project.getSsl()==2)
				props.put("mail.smtp.starttls.enable","true");
			else if(project.getSsl()==1)
				props.put("mail.smtp.ssl.enable","true");
						
			//AJEg/pX[h̕
			Decoder dec = new Decoder();
			final Account account = dec.decode(project.getKeyFile(),project.getAccountFile());		
			Session session = Session.getInstance(props, new Authenticator() {
            protected PasswordAuthentication getPasswordAuthentication() {
            		return new PasswordAuthentication(account.getName(),account.getPass());
            	}
			});	
			
		
			//bZ[W쐬
			MimeMessage msg = new MimeMessage(session);
			msg.setFrom(new InternetAddress(project.getFrom(),"Clone Notifier","iso-2022-jp"));
					
			Multipart mp = new MimeMultipart();		
			MimeBodyPart mbp = new MimeBodyPart();
			FileDataSource fds = new FileDataSource(project.getGenerateTextDir()+"//"+project.getGenerateTextFileName());
			mbp.setDataHandler(new DataHandler(fds));
			mbp.setFileName(MimeUtility.encodeWord(fds.getName()));
			mp.addBodyPart(mbp);

			msg.setSubject("Notification of Changed Clone Information","iso-2022-jp");					
			msg.setContent(mp);
			
			for(String to:project.getToList())
				sendmail(msg,to);						
				
		}catch(Exception e){
			Logger.write("Error: Can't send mail.");
			return false;
		}		
		return true;
	}

	/**
	 * <p>[M</p>
	 * @param msg
	 * @param to
	 */
	private static void sendmail(MimeMessage msg, String to) {
		if(!to.equals("NULL")){		      
		   	try {
				msg.setRecipients(Message.RecipientType.TO,to);
				Transport.send(msg);
				Logger.write("Success: Send mail to " + to);
			} catch (MessagingException e) {
				e.printStackTrace();
				Logger.write("Error: Can't send mail to " + to);
			}
		}
	}

}
