/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.clonedetector;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.ac.osaka_u.ist.sel.clonedetector.CloneJudgement;
import jp.ac.osaka_u.ist.sel.clonedetector.Config;
import jp.ac.osaka_u.ist.sel.clonedetector.LSHController;
import jp.ac.osaka_u.ist.sel.clonedetector.VectorCalculator;
import jp.ac.osaka_u.ist.sel.clonedetector.analyze.CAnalyzer;
import jp.ac.osaka_u.ist.sel.clonedetector.analyze.JavaAnalyzer;
import jp.ac.osaka_u.ist.sel.clonedetector.data.ClonePair;
import jp.ac.osaka_u.ist.sel.clonedetector.data.CloneSet;
import jp.ac.osaka_u.ist.sel.clonedetector.data.Function;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import output.CSVGenerator;
import output.TXTGenerator;

public class CloneDetector {
    public static ArrayList<Function> functionList = new ArrayList();
    public static Map<String, Integer> wordMap = new HashMap<String, Integer>();

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("display help");
        options.addOption(OptionBuilder.create("h"));
        OptionBuilder.withLongOpt("dir");
        OptionBuilder.withDescription("select directory for clone detection");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("dirname");
        options.addOption(OptionBuilder.create("d"));
        OptionBuilder.withLongOpt("lang");
        OptionBuilder.withDescription("select language from following ( default: java )\r\n  * java\r\n  * c");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("lang");
        options.addOption(OptionBuilder.create("l"));
        OptionBuilder.withLongOpt("param");
        OptionBuilder.withDescription("select parameter file for LSH execution");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("*.param");
        options.addOption(OptionBuilder.create("p"));
        OptionBuilder.withLongOpt("outputcsv");
        OptionBuilder.withDescription("select csv file name for output ( default: result.csv )");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("*.csv");
        options.addOption(OptionBuilder.create("oc"));
        OptionBuilder.withLongOpt("outputtxt");
        OptionBuilder.withDescription("select text file name for output ( default: result.txt )");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("*.txt");
        options.addOption(OptionBuilder.create("ot"));
        OptionBuilder.withLongOpt("sim");
        OptionBuilder.withDescription("set threshold of similarity for clone detection ( 0.0<=sim<=1.0 ) ( default: 0.9 )");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("value");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("size");
        OptionBuilder.withDescription("set threshold of size for clone detection  ( 0<=size ) ( default: 50 )");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("value");
        options.addOption(OptionBuilder.create());
        CommandLine cl = null;
        try {
            BasicParser parser = new BasicParser();
            cl = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println("Error: can't read options.");
            System.exit(1);
        }
        if (cl.hasOption("help") || args.length == 0) {
            HelpFormatter f = new HelpFormatter();
            f.printHelp("-d [dirname] -l [lang] <*options>", options);
            System.exit(0);
        }
        if (cl.hasOption("dir")) {
            Config.target = cl.getOptionValue("dir");
        }
        if (Config.target == null) {
            System.err.println("Usage Error: please select target directory for clone detection.");
            System.exit(1);
        }
        if (cl.hasOption("lang")) {
            if (cl.getOptionValue("lang").equals("java") || cl.getOptionValue("lang").equals("Java")) {
                Config.lang = 0;
            }
            if (cl.getOptionValue("lang").equals("c") || cl.getOptionValue("lang").equals("C")) {
                Config.lang = 1;
            }
        }
        if (cl.hasOption("param")) {
            Config.paramFile = cl.getOptionValue("param");
            Config.paramFlg = false;
        }
        if (cl.hasOption("outputcsv")) {
            Config.resultCSV = cl.getOptionValue("outputcsv");
        }
        if (cl.hasOption("outputtxt")) {
            Config.resultTXT = cl.getOptionValue("outputtxt");
        }
        if (cl.hasOption("sim")) {
            try {
                Config.simTh = Double.parseDouble(cl.getOptionValue("sim"));
                if (0.0 > Config.simTh || 1.0 < Config.simTh) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                System.err.println("Usage Error: can't set similarity threshold.");
                System.exit(1);
            }
        }
        if (cl.hasOption("size")) {
            try {
                Config.sizeTh = Integer.parseInt(cl.getOptionValue("size"));
                if (Config.sizeTh < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                System.err.println("Usage Error: can't set size threshold.");
                System.exit(1);
            }
        }
        System.out.println("Extract word in source code ...");
        switch (Config.lang) {
            case 1: {
                CAnalyzer canalyzer = new CAnalyzer();
                canalyzer.searchFile(new File(Config.target));
                break;
            }
            case 0: {
                JavaAnalyzer javaanalyzer = new JavaAnalyzer();
                javaanalyzer.searchFile(new File(Config.target));
            }
        }
        System.out.println("Calculate vector of each function ...");
        VectorCalculator calculator = new VectorCalculator();
        calculator.filterFunction();
        calculator.calculateVector();
        System.out.println("Cluster vector of each function ...");
        if (Config.paramFlg) {
            LSHController.computeParam();
        } else {
            LSHController.reuseParam();
        }
        LSHController.execute();
        System.out.println("Judgement of clone pair ...");
        ArrayList<ClonePair> clonePairList = CloneJudgement.getClonePairList();
        ArrayList<CloneSet> cloneSetList = CloneJudgement.getCloneSetList(clonePairList);
        switch (Config.lang) {
            case 1: {
                CSVGenerator.outputC(clonePairList);
                TXTGenerator.outputC(cloneSetList);
                break;
            }
            case 0: {
                CSVGenerator.outputJava(clonePairList);
                TXTGenerator.outputJava(cloneSetList);
            }
        }
        System.out.println("Success: output result files!!");
    }
}

