/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.clonedetector;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jp.ac.osaka_u.ist.sel.clonedetector.CloneDetector;
import jp.ac.osaka_u.ist.sel.clonedetector.Config;
import jp.ac.osaka_u.ist.sel.clonedetector.data.ClonePair;
import jp.ac.osaka_u.ist.sel.clonedetector.data.CloneSet;
import jp.ac.osaka_u.ist.sel.clonedetector.data.Function;

public class CloneJudgement {
    public static ArrayList<ClonePair> getClonePairList() {
        ArrayList<ClonePair> clonePairList = new ArrayList<ClonePair>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("lsh_result.txt")));
            String line = null;
            int i = 0;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("Query point")) continue;
                while (!(line = reader.readLine()).contains("Total time") && !line.contains("Mean query time")) {
                    int methodId = Integer.valueOf(line.split("\t")[0]);
                    if (i >= methodId) continue;
                    ClonePair pair = new ClonePair();
                    pair.setCloneA(CloneDetector.functionList.get(i));
                    pair.setCloneB(CloneDetector.functionList.get(methodId));
                    pair.setSim(CloneJudgement.scalar(pair.getCloneA().getVector(), pair.getCloneB().getVector()) / (pair.getCloneA().getLen() * pair.getCloneB().getLen()));
                    if (!(pair.getSim() >= Config.simTh) || Math.abs(pair.getCloneA().getSize() - pair.getCloneB().getSize()) >= 30 || !(Math.abs(pair.getCloneA().getLen() - pair.getCloneA().getLen()) < 0.2)) continue;
                    clonePairList.add(pair);
                }
                ++i;
            }
            reader.close();
        }
        catch (IOException e) {
            System.err.println("Error: can't read LSH result file.");
            System.exit(1);
        }
        return clonePairList;
    }

    private static double scalar(double[] v1, double[] v2) {
        double s = 0.0;
        int i = 0;
        while (i < v1.length) {
            s += v1[i] * v2[i];
            ++i;
        }
        return s;
    }

    public static ArrayList<CloneSet> getCloneSetList(ArrayList<ClonePair> clonePairList) {
        Collections.sort(clonePairList, new Comparator<ClonePair>(){

            @Override
            public int compare(ClonePair a, ClonePair b) {
                int no2;
                int no1 = a.getCloneB().getId();
                if (no1 > (no2 = b.getCloneB().getId())) {
                    return 1;
                }
                if (no1 == no2) {
                    return 0;
                }
                return -1;
            }
        });
        Collections.sort(clonePairList, new Comparator<ClonePair>(){

            @Override
            public int compare(ClonePair a, ClonePair b) {
                int no2;
                int no1 = a.getCloneA().getId();
                if (no1 > (no2 = b.getCloneA().getId())) {
                    return 1;
                }
                if (no1 == no2) {
                    return 0;
                }
                return -1;
            }
        });
        ArrayList<CloneSet> cloneSetList = new ArrayList<CloneSet>();
        for (ClonePair pair : clonePairList) {
            CloneSet set2;
            boolean addFlg = false;
            for (CloneSet set2 : cloneSetList) {
                boolean contA = false;
                boolean contB = false;
                for (Function clone : set2.getCloneList()) {
                    if (clone.getFileName().equals(pair.getCloneA().getFileName()) && clone.getStartLine() == pair.getCloneA().getStartLine()) {
                        contA = true;
                    }
                    if (!clone.getFileName().equals(pair.getCloneB().getFileName()) || clone.getStartLine() != pair.getCloneB().getStartLine()) continue;
                    contB = true;
                }
                if (contA && contB) {
                    addFlg = true;
                    break;
                }
                if (contA && !contB) {
                    addFlg = true;
                    set2.getCloneList().add(pair.getCloneB());
                    break;
                }
                if (contA || !contB) continue;
                addFlg = true;
                set2.getCloneList().add(pair.getCloneA());
                break;
            }
            if (addFlg) continue;
            set2 = new CloneSet();
            set2.getCloneList().add(pair.getCloneA());
            set2.getCloneList().add(pair.getCloneB());
            cloneSetList.add(set2);
        }
        for (CloneSet set : cloneSetList) {
            set.calculateMetric();
        }
        return cloneSetList;
    }
}

