/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.clonedetector;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import jp.ac.osaka_u.ist.sel.clonedetector.CloneDetector;
import jp.ac.osaka_u.ist.sel.clonedetector.Config;

public class LSHController {
    private static final String LSH_PATH = "LSH\\LSHMain.exe";

    public static void computeParam() {
        String[] fromArray = new String[]{LSH_PATH, Integer.toString(CloneDetector.functionList.size()), Integer.toString(CloneDetector.functionList.size()), Integer.toString(CloneDetector.wordMap.size()), Double.toString(0.9), Double.toString(1.0), "dataset.txt", "dataset.txt", "3978000000", "-c"};
        ProcessBuilder pb = new ProcessBuilder(fromArray);
        try {
            int c;
            PrintWriter writer = new PrintWriter(new FileOutputStream(Config.paramFile));
            Process p = pb.start();
            InputStream errIn = p.getErrorStream();
            InputStream stdIn = p.getInputStream();
            while ((c = stdIn.read()) != -1) {
                writer.print((char)c);
            }
            stdIn.close();
            while ((c = errIn.read()) != -1) {
            }
            errIn.close();
            p.waitFor();
            writer.close();
        }
        catch (IOException | InterruptedException e) {
            System.err.println("Error: can't calculate params for LSH.");
            System.exit(1);
        }
    }

    public static void reuseParam() {
        ArrayList<String> paramList = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(Config.paramFile)));
            String line = null;
            while ((line = reader.readLine()) != null) {
                paramList.add(line);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: can't load param file for LSH.");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Error: can't load param file for LSH.");
            System.exit(1);
        }
        try {
            PrintWriter writer = new PrintWriter(new FileOutputStream(Config.paramFile));
            boolean noFlg = false;
            for (String param : paramList) {
                if (!noFlg) {
                    writer.println(param);
                } else {
                    noFlg = false;
                }
                if (param.equals("Dimension")) {
                    noFlg = true;
                    writer.println(CloneDetector.wordMap.size());
                    continue;
                }
                if (!param.equals("T")) continue;
                noFlg = true;
                writer.println(CloneDetector.functionList.size());
            }
            writer.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: can't upate params for LSH.");
            System.exit(1);
        }
    }

    public static void execute() {
        String[] fromArray = new String[]{LSH_PATH, Integer.toString(CloneDetector.functionList.size()), Integer.toString(CloneDetector.functionList.size()), Integer.toString(CloneDetector.wordMap.size()), Double.toString(0.9), Double.toString(1.0), "dataset.txt", "dataset.txt", "3978000000", "-p", Config.paramFile};
        ProcessBuilder pb = new ProcessBuilder(fromArray);
        try {
            int c;
            PrintWriter writer = new PrintWriter(new FileOutputStream("lsh_result.txt"));
            Process p = pb.start();
            InputStream errIn = p.getErrorStream();
            InputStream stdIn = p.getInputStream();
            while ((c = stdIn.read()) != -1) {
                writer.print((char)c);
            }
            stdIn.close();
            while ((c = errIn.read()) != -1) {
            }
            errIn.close();
            p.waitFor();
            writer.close();
        }
        catch (IOException | InterruptedException e) {
            System.err.println("Error: can't execute LSH.");
            System.exit(1);
        }
    }
}

