/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.clonedetector.analyze;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import jp.ac.osaka_u.ist.sel.clonedetector.CloneDetector;
import jp.ac.osaka_u.ist.sel.clonedetector.data.Function;
import jp.ac.osaka_u.ist.sel.clonedetector.data.Word;

public class CAnalyzer {
    private ArrayList<String> allWordList = new ArrayList();
    private int functionId = 0;

    public void searchFile(File file) throws IOException {
        if (file.isFile() && file.getName().endsWith(".c")) {
            this.extractFunction(file);
        } else if (file.isDirectory()) {
            File[] fileList;
            File[] fileArray = fileList = file.listFiles();
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.searchFile(f);
                ++n2;
            }
        }
    }

    public ArrayList<String> getWordList() {
        return this.allWordList;
    }

    private void extractFunction(File file) {
        try {
            FileReader fr = new FileReader(file.toString());
            StreamTokenizer tokenizer = new StreamTokenizer(fr);
            tokenizer.wordChars(48, 57);
            tokenizer.wordChars(97, 122);
            tokenizer.wordChars(65, 90);
            tokenizer.wordChars(95, 95);
            tokenizer.ordinaryChar(47);
            tokenizer.ordinaryChar(42);
            tokenizer.slashSlashComments(true);
            tokenizer.slashStarComments(true);
            int beforeToken = -1;
            String beforeSval = null;
            String functionName = null;
            int start = 0;
            try {
                int token;
                while ((token = tokenizer.nextToken()) != -1) {
                    switch (token) {
                        case 42: 
                        case 47: {
                            if (beforeToken != 47) break;
                            this.ignoreComment(tokenizer);
                            break;
                        }
                        case 40: {
                            functionName = beforeSval;
                            start = tokenizer.lineno();
                            break;
                        }
                        case -3: {
                            break;
                        }
                        case 123: {
                            if (functionName == null || beforeToken != 41 || functionName.equals("for") || functionName.equals("if") || functionName.equals("switch") || functionName.equals("while")) break;
                            Function function = new Function();
                            function.setId(this.functionId++);
                            function.setName(functionName);
                            function.setFileName(file.toString());
                            function.setStartLine(start);
                            CloneDetector.functionList.add(function);
                            this.extractWordList(tokenizer, function);
                            function.setEndLine(tokenizer.lineno());
                        }
                    }
                    beforeSval = tokenizer.sval;
                    beforeToken = token;
                }
            }
            catch (IOException e) {
                System.err.println("Error: can't analyze source code.");
                System.exit(1);
            }
        }
        catch (FileNotFoundException e1) {
            System.err.println("Error: can't analyze source code.");
            System.exit(1);
        }
    }

    private void ignoreComment(StreamTokenizer tokenizer) throws IOException {
        int beforeToken = 0;
        int token = 0;
        while ((token = tokenizer.nextToken()) != -1) {
            switch (token) {
                case 47: {
                    if (beforeToken != 42 && beforeToken != 47) break;
                    return;
                }
            }
            beforeToken = token;
        }
    }

    private void extractWordList(StreamTokenizer tokenizer, Function function) {
        try {
            int token;
            while ((token = tokenizer.nextToken()) != -1) {
                function.incSize();
                int beforeToken = 0;
                switch (token) {
                    case 42: 
                    case 47: {
                        if (beforeToken != 47) break;
                        this.ignoreComment(tokenizer);
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case -3: {
                        this.separateIdentifier(tokenizer.sval, function.getWordList());
                        break;
                    }
                    case 123: {
                        this.extractWordList(tokenizer, function);
                        break;
                    }
                    case 125: {
                        return;
                    }
                }
                beforeToken = token;
            }
        }
        catch (IOException e) {
            System.err.println("Error: can't analyze source code.");
            System.exit(1);
        }
    }

    private void separateIdentifier(String identifier, ArrayList<Word> wordList) {
        String word = new String("");
        ArrayList<String> identifierWord = new ArrayList<String>();
        if (identifier.length() <= 2) {
            identifierWord.add("word_2");
        } else {
            char[] cArray = identifier.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if ('a' <= c && c <= 'z') {
                    word = String.valueOf(word) + c;
                } else if ('A' <= c && c <= 'Z') {
                    if (!word.isEmpty()) {
                        if ('A' <= word.charAt(word.length() - 1) && word.charAt(word.length() - 1) <= 'Z') {
                            word = String.valueOf(word) + c;
                        } else {
                            if (!word.isEmpty()) {
                                identifierWord.add(word.toLowerCase());
                            }
                            word = "" + c;
                        }
                    } else {
                        word = String.valueOf(word) + c;
                    }
                } else {
                    if (!word.isEmpty()) {
                        identifierWord.add(word.toLowerCase());
                    }
                    word = "";
                }
                ++n2;
            }
            if (!word.isEmpty()) {
                identifierWord.add(word.toLowerCase());
            }
        }
        this.addWord(wordList, identifierWord);
    }

    private void addWord(ArrayList<Word> wordList, ArrayList<String> identifierWord) {
        for (String newWord : identifierWord) {
            if ((newWord = newWord.toLowerCase()).isEmpty()) continue;
            boolean addFlg = true;
            for (Word word : wordList) {
                if (!word.getName().equals(newWord)) continue;
                addFlg = false;
                word.addCount(1.0 / (double)identifierWord.size());
                break;
            }
            if (!addFlg) continue;
            wordList.add(new Word(newWord, 0, 1.0 / (double)identifierWord.size()));
        }
    }
}

