/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.clonedetector.analyze;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.ac.osaka_u.ist.sel.clonedetector.CloneDetector;
import jp.ac.osaka_u.ist.sel.clonedetector.data.Function;
import jp.ac.osaka_u.ist.sel.clonedetector.data.Word;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class JavaAnalyzer {
    private ASTParser parser = ASTParser.newParser(4);
    private ArrayList<String> allWordList = new ArrayList();

    public JavaAnalyzer() {
        this.parser.setBindingsRecovery(true);
        this.parser.setStatementsRecovery(true);
        this.parser.setResolveBindings(true);
    }

    public ArrayList<String> getWordList() {
        return this.allWordList;
    }

    public void searchFile(File file) {
        if (file.isFile() && file.getName().endsWith(".java")) {
            this.parser.setSource(this.getCode(file));
            CompilationUnit unit = (CompilationUnit)this.parser.createAST(null);
            ASTNode node = unit.getRoot();
            this.extractFunction(null, node, null, file.getPath());
        } else if (file.isDirectory()) {
            File[] fileList;
            File[] fileArray = fileList = file.listFiles();
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.searchFile(f);
                ++n2;
            }
        }
    }

    private char[] getCode(File file) {
        String code = "";
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                code = String.valueOf(code) + "\n" + line;
            }
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return code.toCharArray();
    }

    private void extractFunction(Function function, ASTNode node, String className, String fileName) {
        BodyDeclaration n;
        if (node.getNodeType() == 29) {
            return;
        }
        boolean functionDecFlg = false;
        if (node.getNodeType() == 55) {
            n = (TypeDeclaration)node;
            className = className == null ? ((AbstractTypeDeclaration)n).getName().getIdentifier() : String.valueOf(className) + "." + ((AbstractTypeDeclaration)n).getName().getIdentifier();
        }
        if (function == null && node.getNodeType() == 31) {
            functionDecFlg = true;
            function = new Function();
            n = (MethodDeclaration)node;
            function.setName(((MethodDeclaration)n).getName().getIdentifier());
            function.setFileName(fileName);
            function.setClassName(className);
            function.setCode(node.toString());
            CloneDetector.functionList.add(function);
        }
        if (function != null) {
            function.incSize();
            ArrayList<String> list = new ArrayList<String>();
            switch (node.getNodeType()) {
                case 40: 
                case 42: 
                case 43: {
                    this.separateIdentifier(node.toString(), function.getWordList());
                    break;
                }
                case 6: 
                case 10: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 24: 
                case 25: 
                case 30: 
                case 41: 
                case 50: 
                case 51: 
                case 53: 
                case 54: 
                case 56: 
                case 60: 
                case 61: 
                case 70: {
                    list.add("st_" + Integer.toString(node.getNodeType()));
                    this.addWord(function.getWordList(), list, 1);
                    break;
                }
                case 27: {
                    list.add("infixop_" + Integer.toString(node.getNodeType()));
                    this.addWord(function.getWordList(), list, 1);
                    break;
                }
                case 38: {
                    list.add("prefixop_" + Integer.toString(node.getNodeType()));
                    this.addWord(function.getWordList(), list, 1);
                    break;
                }
                case 44: {
                    list.add("type_" + Integer.toString(node.getNodeType()));
                    this.addWord(function.getWordList(), list, 1);
                }
            }
        }
        List properties = node.structuralPropertiesForType();
        ArrayList<ASTNode> children = new ArrayList<ASTNode>();
        for (StructuralPropertyDescriptor descriptor : properties) {
            if (descriptor.isChildProperty()) {
                if ((ASTNode)node.getStructuralProperty(descriptor) == null) continue;
                children.add((ASTNode)node.getStructuralProperty(descriptor));
                continue;
            }
            if (!descriptor.isChildListProperty()) continue;
            List tmpChildren = (List)node.getStructuralProperty(descriptor);
            Iterator j = tmpChildren.iterator();
            while (j.hasNext()) {
                children.add((ASTNode)j.next());
            }
        }
        for (ASTNode n2 : children) {
            this.extractFunction(function, n2, className, fileName);
        }
        if (functionDecFlg) {
            function = null;
        }
    }

    private void separateIdentifier(String identifier, ArrayList<Word> wordList) {
        String word = new String("");
        ArrayList<String> identifierWord = new ArrayList<String>();
        if (identifier.length() <= 2) {
            identifierWord.add("word_2");
        } else {
            char[] cArray = identifier.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if ('a' <= c && c <= 'z') {
                    word = String.valueOf(word) + c;
                } else if ('A' <= c && c <= 'Z') {
                    if (!word.isEmpty()) {
                        if ('A' <= word.charAt(word.length() - 1) && word.charAt(word.length() - 1) <= 'Z') {
                            word = String.valueOf(word) + c;
                        } else {
                            if (!word.isEmpty()) {
                                identifierWord.add(word.toLowerCase());
                            }
                            word = "" + c;
                        }
                    } else {
                        word = String.valueOf(word) + c;
                    }
                } else {
                    if (!word.isEmpty()) {
                        identifierWord.add(word.toLowerCase());
                    }
                    word = "";
                }
                ++n2;
            }
            if (!word.isEmpty()) {
                identifierWord.add(word);
            }
            this.addWord(wordList, identifierWord, 0);
        }
    }

    private void addWord(ArrayList<Word> wordList, ArrayList<String> identifierWord, int type) {
        for (String newWord : identifierWord) {
            if ((newWord = newWord.toLowerCase()).isEmpty()) continue;
            boolean addFlg = true;
            for (Word word : wordList) {
                if (!word.getName().equals(newWord)) continue;
                addFlg = false;
                word.addCount(1.0);
                break;
            }
            if (!addFlg) continue;
            wordList.add(new Word(newWord, type, 1.0));
        }
    }
}

