/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.clonedetector.evaluate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import jp.ac.osaka_u.ist.sel.clonedetector.CloneDetector;
import jp.ac.osaka_u.ist.sel.clonedetector.data.ClonePair;
import jp.ac.osaka_u.ist.sel.clonedetector.data.Function;

public class Evaluator {
    public static final String RESULT = "result.csv";
    public static final String BENCHMARK = "benchmark_argouml.txt";
    public static final String PRECISION_RESULT = "precision_result.csv";
    public static final String RECALL_RESULT = "recall_result.csv";
    public static ArrayList<ClonePair> resultList = new ArrayList();
    public static ArrayList<ClonePair> benchmarkList = new ArrayList();

    public static void evaluate() throws Exception {
        Evaluator.readResultCVS();
        Evaluator.readBenchmark();
        PrintWriter writer01 = new PrintWriter(new FileOutputStream(PRECISION_RESULT));
        PrintWriter writer02 = new PrintWriter(new FileOutputStream(RECALL_RESULT));
        int truePositive = 0;
        for (ClonePair pairA : resultList) {
            boolean f = false;
            for (ClonePair pairB : benchmarkList) {
                if (pairA.getCloneA().getName().equals(pairB.getCloneA().getName()) && pairA.getCloneB().getName().equals(pairB.getCloneB().getName()) || pairA.getCloneA().getName().equals(pairB.getCloneB().getName()) && pairA.getCloneB().getName().equals(pairB.getCloneA().getName())) {
                    ++truePositive;
                    f = true;
                    break;
                }
                pairB.check = f;
            }
            writer01.printf("%s,%s,%f,%s,\r\n", pairA.getCloneA().getName(), pairA.getCloneB().getName(), pairA.getSim(), f);
        }
        for (ClonePair pair : benchmarkList) {
            writer02.printf("%s,%s,%f,%s,\r\n", pair.getCloneA().getName(), pair.getCloneB().getName(), pair.getSim(), pair.check);
        }
        writer01.close();
        writer02.close();
        double precision = (double)truePositive / (double)resultList.size();
        double recall = (double)truePositive / (double)benchmarkList.size();
        System.out.printf("Precision : %f\r\n", precision);
        System.out.printf("Recall : %f\r\n", recall);
        System.out.printf("F : %f\r\n", 2.0 / (1.0 / precision + 1.0 / recall));
    }

    private static void readBenchmark() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(BENCHMARK)));
        String line = null;
        while ((line = reader.readLine()) != null) {
            ClonePair pair = new ClonePair();
            String[] tmp = line.split("\t");
            pair.getCloneA().setName(Evaluator.getName(tmp[1]));
            pair.getCloneB().setName(Evaluator.getName(tmp[5]));
            double diff = Double.valueOf(tmp[9]);
            Function cloneA = null;
            Function cloneB = null;
            for (Function function : CloneDetector.functionList) {
                if ((String.valueOf(new File(function.getFileName()).getParent().replace("\\", ".")) + "." + function.getClassName() + "." + function.getName()).equals(pair.getCloneA().getName())) {
                    cloneA = function;
                }
                if (!(String.valueOf(new File(function.getFileName()).getParent().replace("\\", ".")) + "." + function.getClassName() + "." + function.getName()).equals(pair.getCloneB().getName())) continue;
                cloneB = function;
            }
            if (cloneA == null || cloneB == null || pair.getCloneA().getName().contains("test") || pair.getCloneA().getName().contains("Test") || pair.getCloneB().getName().contains("test") || pair.getCloneB().getName().contains("Test") || !(diff <= 45.0)) continue;
            benchmarkList.add(pair);
        }
        reader.close();
    }

    private static String getName(String str) {
        String name = "";
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '(') break;
            if (c != '\"') {
                name = String.valueOf(name) + c;
            }
            ++n2;
        }
        return name;
    }

    private static void readResultCVS() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(RESULT)));
        String line = null;
        while ((line = reader.readLine()) != null) {
            ClonePair pair = new ClonePair();
            String[] tmp = line.split(",");
            if (tmp.length < 2) continue;
            pair.getCloneA().setName(String.valueOf(new File(tmp[1]).getParent().replace("\\", ".")) + "." + tmp[0]);
            pair.getCloneB().setName(String.valueOf(new File(tmp[4]).getParent().replace("\\", ".")) + "." + tmp[3]);
            if (pair.getCloneA().getName().contains("test") || pair.getCloneA().getName().contains("Test") || pair.getCloneB().getName().contains("test") || pair.getCloneB().getName().contains("Test")) continue;
            resultList.add(pair);
        }
        reader.close();
    }
}

