/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.y_yuuki.cn;

import java.io.File;
import java.io.IOException;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.Logger;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.SettingFileLoader;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.VCSController;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.analyze.AnalyzeManager;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Project;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.generate.OutputGenerator;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.mail.MailSender;

public class Main {
    public static void main(String[] args) {
        try {
            Logger.init();
        }
        catch (IOException e) {
            Logger.printlnConsole("Can't generate log file.", 2);
            System.exit(1);
        }
        if (!new File("file").exists()) {
            Logger.writeln("Create directory 'file'.", 0);
            new File("file").mkdirs();
        }
        int argnum = 1;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            Logger.writeln("--- Analyze Project" + Integer.toString(argnum) + "---", 4);
            Logger.printlnConsole("--- Analyze Project" + Integer.toString(argnum++) + "---", 4);
            Project project = new Project();
            if (SettingFileLoader.loadSettingFile(arg, project)) {
                Logger.writeln("<Success> Load setting file.", 4);
                boolean okFlg = true;
                if (project.isCheckout()) {
                    okFlg = VCSController.checkoutProject(project);
                    if (!okFlg) {
                        Logger.writeln("Can't checkout project.", 2);
                        okFlg = false;
                    } else {
                        Logger.writeln("<Success> Checkout new version of " + project.getName() + ".", 4);
                    }
                }
                if (okFlg) {
                    if (AnalyzeManager.getCloneInf(project)) {
                        Logger.writeln("<Success> Extract code clone information.", 4);
                        if (AnalyzeManager.categorizeClone(project)) {
                            Logger.writeln("<Success> Categorize code clones.", 4);
                            OutputGenerator generator = new OutputGenerator(project);
                            if (project.isGenerateText()) {
                                generator.generateTextFile();
                                MailSender.sendMail(project);
                            }
                            if (project.isGenerateCSV()) {
                                generator.generateCSVFile();
                            }
                            if (project.isGenerateHtml()) {
                                generator.generateHTMLFile();
                            }
                        }
                    } else {
                        Logger.writeln("Can't extract code clone information.", 2);
                    }
                }
            } else {
                Logger.writeln("Can't load setting file.", 2);
            }
            ++n2;
        }
        Logger.finish("End.", 4);
    }
}

