/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.y_yuuki.cn;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.Logger;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Project;

public class VCSController {
    public static boolean checkoutProject(Project project) {
        if (!VCSController.deleteDir(project.getOldDir())) {
            Logger.writeln("Can't delete old directory.", 2);
        }
        if (!VCSController.changeDir(project.getNewDir(), project.getOldDir())) {
            Logger.writeln("Can't move old directory.", 2);
        }
        if (!VCSController.deleteDir(String.valueOf(project.getOldDir()) + "\\.ccfxprepdir")) {
            Logger.writeln("Can't delete '.ccfxprepdir' directory.", 2);
        }
        String[] cmdarray = project.getCheckoutCmd().split(" ");
        ProcessBuilder pb = new ProcessBuilder(cmdarray);
        try {
            String line;
            Process p = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            Logger.writeln("Start checkout command.", 4);
            while ((line = reader.readLine()) != null) {
                Logger.writeln("\t" + line, 4);
            }
            reader.close();
        }
        catch (IOException e1) {
            return false;
        }
        if (!new File(project.getNewDir()).exists()) {
            new File(project.getNewDir()).mkdirs();
            return false;
        }
        if (!new File(project.getOldDir()).exists()) {
            new File(project.getOldDir()).mkdirs();
            return false;
        }
        return true;
    }

    private static boolean changeDir(String dirA, String dirB) {
        File fileA = new File(dirA);
        File fileB = new File(dirB);
        if (fileA.exists()) {
            return fileA.renameTo(fileB);
        }
        return true;
    }

    public static boolean deleteDir(String dir) {
        File file = new File(dir);
        if (file.exists() && file.isDirectory()) {
            File[] f = file.listFiles();
            int i = 0;
            while (i < f.length) {
                VCSController.deleteDir(f[i].toString());
                ++i;
            }
        }
        boolean result = false;
        try {
            file.setWritable(true);
            result = Files.deleteIfExists(file.toPath());
        }
        catch (DirectoryNotEmptyException e) {
            Logger.writeln("<DirectoryNotEmptyException> Can't delete " + file.toString(), 3);
            result = false;
        }
        catch (IOException e) {
            Logger.writeln("<IOException> Can't delete " + file.toString(), 3);
            Logger.writeln("\tWritable: " + file.canWrite(), -1);
            Logger.writeln("\tReadable: " + file.canRead(), -1);
        }
        return result;
    }
}

