/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.y_yuuki.cn.analyze;

import jp.ac.osaka_u.ist.sel.y_yuuki.cn.Logger;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.analyze.CCFXController;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.analyze.CloneCategorizer;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.analyze.CloneDetectorController;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.analyze.CloneSetCategorizer;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.analyze.DiffDetector;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Project;

public class AnalyzeManager {
    public static boolean getCloneInf(Project project) {
        if (project.getTool().equals("CCFinderX")) {
            CCFXController controller = new CCFXController(project);
            if (!controller.execute()) {
                Logger.writeln("Can't execute CCFinder.", 2);
                return false;
            }
            if (!controller.readCloneDataFile()) {
                Logger.writeln("Can't read clone data file.", 2);
                return false;
            }
            try {
                if (!controller.readPrepFile()) {
                    Logger.writeln("Can't read preprocess files.", 2);
                    return false;
                }
            }
            catch (Exception e) {
                Logger.writeln("<Exception> Can't read preprocess files.", 2);
                return false;
            }
            if (!controller.getCloneMetrics()) {
                Logger.writeln("Can't read clone metrics file.", 2);
                return false;
            }
        } else if (project.getTool().equals("CloneDetector")) {
            CloneDetectorController controller = new CloneDetectorController(project);
            if (!controller.execute()) {
                Logger.writeln("Can't execute clonedetector.", 2);
                return false;
            }
            if (!controller.readCloneDataFile()) {
                Logger.writeln("Can't read clone data file.", 2);
                return false;
            }
        } else {
            Logger.writeln("Can't execute unknown tool '" + project.getTool() + "'.", 3);
            return false;
        }
        return true;
    }

    public static boolean categorizeClone(Project project) {
        if (!DiffDetector.getDiff(project.getFileList())) {
            Logger.writeln("Can't get diff of source code.", 2);
            return false;
        }
        CloneCategorizer.categorizeClone(project.getFileList());
        CloneSetCategorizer.categorizeClone(project.getCloneSetList(), project);
        return true;
    }
}

