/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.y_yuuki.cn.analyze;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import jp.ac.osaka_u.ist.sel.m_sano.extractor.CMethodExtractor;
import jp.ac.osaka_u.ist.sel.m_sano.extractor.JavaMethodExtractor;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.Logger;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Clone;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.CloneSet;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Method;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Project;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.SourceFile;
import jp.ac.osaka_u.ist.sel.y_yuuki.visitor.CFileVistor;
import jp.ac.osaka_u.ist.sel.y_yuuki.visitor.JavaFileVistor;

public class CloneDetectorController {
    private Project project = null;

    public CloneDetectorController(Project project) {
        this.project = project;
    }

    public boolean execute() {
        File dir = new File("clonedetector");
        String[] cmdArray1 = new String[]{"java", "-jar", "clonedetector_ver1.0.jar", "-d", String.valueOf(this.project.getNewDir()) + "\\src", "-l", this.project.getLang(), "-oc", "..\\file/result.csv", "-ot", "..\\file/result.txt"};
        File odir = new File(this.project.getOldDir());
        String abstOldPath = odir.getAbsolutePath();
        String[] cmdArray2 = new String[]{"java", "-jar", "clonedetector_ver1.0.jar", "-d", String.valueOf(abstOldPath) + "\\src", "-l", this.project.getLang(), "-oc", "..\\file/result-old.csv", "-ot", "..\\file/result-old.txt"};
        ProcessBuilder pb1 = new ProcessBuilder(cmdArray1);
        pb1.directory(dir);
        ProcessBuilder pb2 = new ProcessBuilder(cmdArray2);
        pb2.directory(dir);
        try {
            String line;
            Process pr1 = pb1.start();
            Logger.writeln("Extract new code clone.", 4);
            Logger.printlnConsole("Extract new code clone.", 4);
            BufferedReader reader = new BufferedReader(new InputStreamReader(pr1.getInputStream()));
            while ((line = reader.readLine()) != null) {
                Logger.writeln(line, 4);
            }
            reader.close();
            Process pr2 = pb2.start();
            Logger.writeln("Extract old code clone.", 4);
            Logger.printlnConsole("Extract old code clone.", 4);
            reader = new BufferedReader(new InputStreamReader(pr2.getInputStream()));
            while ((line = reader.readLine()) != null) {
                Logger.writeln(line, 4);
            }
            reader.close();
        }
        catch (IOException e) {
            return false;
        }
        File nf = new File("file/result.txt");
        File of = new File("file/result-old.txt");
        if (!nf.exists() || !of.exists()) {
            Logger.writeln("Can't find result file.", 2);
            return false;
        }
        if (nf.length() == 0L || of.length() == 0L) {
            Logger.writeln("Result file is empty.", 2);
            return false;
        }
        return true;
    }

    public boolean readCloneDataFile() {
        BufferedReader readFile = null;
        ArrayList<SourceFile> fileList = new ArrayList<SourceFile>();
        ArrayList<CloneSet> cloneSetList = new ArrayList<CloneSet>();
        ArrayList<Object> newFileList = new ArrayList();
        ArrayList<Object> oldFileList = new ArrayList();
        Logger.writeln("Read clone data file.", 4);
        try {
            if (this.project.getLang().equals("java")) {
                newFileList = this.getFileList(this.project.getNewDir(), true);
                oldFileList = this.getFileList(this.project.getOldDir(), true);
            } else if (this.project.getLang().equals("c")) {
                newFileList = this.getFileList(this.project.getNewDir(), false);
                oldFileList = this.getFileList(this.project.getOldDir(), false);
            } else {
                Logger.writeln("Invalid programming langage.", 3);
                return false;
            }
            try {
                SourceFile file;
                Logger.writeln("Get source file status.", 0);
                Logger.writeln("\t Analyze add & stay files.", -1);
                Iterator<Object> it = newFileList.iterator();
                int fileId = 0;
                while (it.hasNext()) {
                    String string = (String)it.next();
                    file = new SourceFile();
                    file.setName(string);
                    file.setNewPath(String.valueOf(this.project.getNewDir()) + "\\" + string);
                    file.setOldPath(String.valueOf(this.project.getOldDir()) + "\\" + string);
                    file.setId(fileId++);
                    int index = oldFileList.indexOf(string);
                    if (index > -1) {
                        file.setState(0);
                        oldFileList.remove(string);
                    } else {
                        file.setState(1);
                    }
                    fileList.add(file);
                }
                Logger.writeln("\t Analyze delete files.", -1);
                for (String string : oldFileList) {
                    file = new SourceFile();
                    file.setName(string);
                    file.setOldPath(String.valueOf(this.project.getOldDir()) + "\\" + string);
                    file.setId(fileId++);
                    file.setState(2);
                    fileList.add(file);
                }
                Logger.writeln("<Success> Get source file status.", 0);
                if (this.project.getLang().equals("java")) {
                    Logger.writeln("Analyze new clone result file.", 0);
                    this.analyzeResultFileForJava("file/result.txt", cloneSetList, fileList, true);
                    Logger.writeln("Analyze old clone result file.", 0);
                    this.analyzeResultFileForJava("file/result-old.txt", cloneSetList, fileList, false);
                } else {
                    this.analyzeResultFileForC("file/result.txt", cloneSetList, fileList, true);
                    this.analyzeResultFileForC("file/result-old.txt", cloneSetList, fileList, false);
                }
            }
            catch (FileNotFoundException e) {
                Logger.writeln("Can't found read clone file.", 2);
                return false;
            }
            catch (IOException e) {
                Logger.writeln("<IOException> Can't read clone file.", 2);
                return false;
            }
        }
        finally {
            if (readFile != null) {
                try {
                    readFile.close();
                }
                catch (IOException e) {
                    Logger.writeln("<IOException> Can't close buffer.", 2);
                }
            }
        }
        Logger.writeln("Check error detection.", 0);
        ArrayList tmpCloneSetList = (ArrayList)cloneSetList.clone();
        for (CloneSet cloneSet : tmpCloneSetList) {
            if (cloneSet.getNewCloneList().size() == 1) {
                cloneSet.getNewCloneList().remove(0);
            }
            if (cloneSet.getOldCloneList().size() == 1) {
                cloneSet.getOldCloneList().remove(0);
            }
            if (!cloneSet.getNewCloneList().isEmpty() || !cloneSet.getOldCloneList().isEmpty()) continue;
            cloneSetList.remove(cloneSet);
        }
        for (CloneSet cloneSet : cloneSetList) {
            for (Clone clone : cloneSet.getNewCloneList()) {
                clone.getFile().getNewCloneList().add(clone);
            }
            for (Clone clone : cloneSet.getOldCloneList()) {
                clone.getFile().getOldCloneList().add(clone);
            }
        }
        for (SourceFile file : fileList) {
            file.sortCloneListbyMethod();
        }
        this.project.getCloneSetList().addAll(cloneSetList);
        this.project.getFileList().addAll(fileList);
        Logger.writeln("<Success> Read clone data file.", 0);
        return true;
    }

    private void analyzeResultFileForJava(String result, ArrayList<CloneSet> cloneSetList, ArrayList<SourceFile> fileList, boolean isNew) throws IOException {
        String line;
        BufferedReader readFile = new BufferedReader(new FileReader(result));
        int cloneId = 0;
        CloneSet cloneSet = null;
        CloneSet tmpCloneSet = null;
        Clone clone = null;
        String methodName = null;
        String modifiedMethodName = null;
        while ((line = readFile.readLine()) != null) {
            if (line.startsWith("cloneset:") && clone == null) {
                int id = Integer.valueOf(line.substring("cloneset:".length()));
                cloneSet = null;
                tmpCloneSet = new CloneSet();
                tmpCloneSet.setId(id);
            }
            if (line.startsWith("filename : ") && clone == null) {
                clone = new Clone();
                clone.setId(cloneId++);
                Path path = new File(line.substring("filename : ".length(), line.length() - 1)).toPath();
                String abstPath = path.toAbsolutePath().toString();
                String relPath = isNew ? abstPath.substring(new File(this.project.getNewDir()).getAbsolutePath().length() + 1) : abstPath.substring(new File(this.project.getOldDir()).getAbsolutePath().length() + 1);
                SourceFile sfile = Project.getFileObj(fileList, relPath);
                Logger.writeln("Start extracting method '" + relPath + "'.", -1);
                Logger.writeln("SourceFile is " + (sfile != null ? sfile.getName() : "null"), -1);
                Logger.writeln("NewFlag is " + isNew, -1);
                this.extractMethodForJava(sfile, abstPath, isNew);
                clone.setFile(sfile);
            }
            if (line.startsWith("methodname : ") && clone != null && methodName == null) {
                String[] mname = line.substring("methodname : ".length(), line.indexOf("(") - 1).split("\\.");
                methodName = mname[mname.length - 1];
                modifiedMethodName = line.substring("methodname : ".length(), line.indexOf("(") - 1);
            }
            if (methodName == null || !line.contains(String.valueOf(methodName) + "(") || !line.endsWith("{")) continue;
            String paramStart = String.valueOf(methodName) + "(";
            String paramPart = line.substring(line.indexOf(paramStart) + paramStart.length(), line.lastIndexOf(")"));
            clone.setMethodName(String.valueOf(modifiedMethodName) + "(" + paramPart + ")");
            Method parentMd = clone.getFile().getMethod(modifiedMethodName, methodName, paramPart, isNew, true);
            Logger.writeln("<CloneDetectorController.analyzeResultFileForJava> success: get Method.", -1);
            if (parentMd == null) {
                Logger.writeln("Can't find method belonging clone.\n\tMethod name <" + clone.getMethodName() + ">.", 3);
                if (isNew) {
                    ArrayList<Method> mdlist = isNew ? clone.getFile().getNewMethodList() : clone.getFile().getOldMethodList();
                    for (Method md : mdlist) {
                        Logger.writeln(String.valueOf(md.getModifiedName()) + md.getParams(), 4);
                    }
                }
            } else {
                clone.setStartLine(parentMd.getStartLine());
                clone.setStartColumn(parentMd.getStartColumn());
                clone.setEndLine(parentMd.getEndLine());
                clone.setEndColumn(parentMd.getEndColumn());
            }
            Logger.writeln("<CloneDetectorController.analyzeResultFileForJava> clone.getMethodName() is " + clone.getMethodName(), -1);
            Logger.writeln("<CloneDetectorController.analyzeResultFileForJava> parentMd.getName() is " + parentMd.getName(), -1);
            if (cloneSet == null) {
                for (CloneSet pCloneSet : cloneSetList) {
                    if (!pCloneSet.equalsForCloneDetector(clone.getMethodName(), clone.getFile().getName())) continue;
                    cloneSet = pCloneSet;
                }
                if (cloneSet == null) {
                    cloneSet = new CloneSet();
                    cloneSetList.add(cloneSet);
                }
                if (isNew) {
                    cloneSet.setId(tmpCloneSet.getId());
                } else {
                    cloneSet.setOldId(tmpCloneSet.getId());
                }
            }
            clone.setCloneSet(cloneSet);
            if (isNew) {
                Logger.writeln("<CloneDetectorController.analyzeResultFileForJava> clone.getFile().getName() is " + clone.getFile().getName(), -1);
                Logger.writeln("<CloneDetectorController.analyzeResultFileForJava> clone.getMethodName() is " + clone.getMethodName(), -1);
                if (!this.addClone(cloneSet.getNewCloneList(), clone)) {
                    --cloneId;
                }
            } else if (!this.addClone(cloneSet.getOldCloneList(), clone)) {
                --cloneId;
            }
            clone = null;
            methodName = null;
        }
        readFile.close();
    }

    private void analyzeResultFileForC(String result, ArrayList<CloneSet> cloneSetList, ArrayList<SourceFile> fileList, boolean isNew) throws IOException {
        String line;
        BufferedReader readFile = new BufferedReader(new FileReader(result));
        int cloneId = 0;
        CloneSet cloneSet = null;
        CloneSet tmpCloneSet = null;
        Clone clone = null;
        while ((line = readFile.readLine()) != null) {
            if (line.startsWith("=================================================")) {
                cloneSet = null;
                tmpCloneSet = null;
                clone = null;
            }
            if (line.startsWith("cloneset:") && tmpCloneSet == null) {
                int id = Integer.valueOf(line.substring("cloneset:".length()));
                tmpCloneSet = new CloneSet();
                tmpCloneSet.setId(id);
            }
            if (!line.startsWith("\t ") || tmpCloneSet == null) continue;
            clone = new Clone();
            clone.setId(cloneId++);
            String[] str = line.split(" ");
            Path path = new File(str[3]).toPath();
            String abstPath = path.toAbsolutePath().toString();
            String relPath = isNew ? abstPath.substring(new File(this.project.getNewDir()).getAbsolutePath().length() + 1) : abstPath.substring(new File(this.project.getOldDir()).getAbsolutePath().length() + 1);
            SourceFile sfile = Project.getFileObj(fileList, relPath);
            Logger.writeln("SourceFile is " + (sfile != null ? sfile.getName() : "null"), -1);
            Logger.writeln("relPath is " + relPath, -1);
            this.extractMethodForC(sfile, abstPath, isNew);
            clone.setFile(sfile);
            clone.setMethodName(str[1]);
            Method parentMd = clone.getFile().getMethod(path.getFileName().toString(), str[1], null, isNew, false);
            if (parentMd == null) {
                Logger.writeln("Can't find method belonging clone.", 3);
                Logger.writeln("Method name is " + clone.getMethodName(), -1);
                Logger.writeln("path.getFileName().toString() is " + path.getFileName().toString(), -1);
                Logger.writeln("str[1] is " + str[1], -1);
            } else {
                clone.setStartLine(parentMd.getStartLine());
                clone.setStartColumn(parentMd.getStartColumn());
                clone.setEndLine(parentMd.getEndLine());
                clone.setEndColumn(parentMd.getEndColumn());
            }
            if (cloneSet == null) {
                for (CloneSet pCloneSet : cloneSetList) {
                    if (!pCloneSet.equalsForCloneDetector(clone.getMethodName(), clone.getFile().getName())) continue;
                    cloneSet = pCloneSet;
                }
                if (cloneSet == null) {
                    cloneSet = new CloneSet();
                    cloneSetList.add(cloneSet);
                }
                if (isNew) {
                    cloneSet.setId(tmpCloneSet.getId());
                } else {
                    cloneSet.setOldId(tmpCloneSet.getId());
                }
            }
            clone.setCloneSet(cloneSet);
            if (isNew) {
                if (this.addClone(cloneSet.getNewCloneList(), clone)) continue;
                --cloneId;
                continue;
            }
            if (this.addClone(cloneSet.getOldCloneList(), clone)) continue;
            --cloneId;
        }
        readFile.close();
    }

    public ArrayList<String> getFileList(String root, boolean javaMode) throws IOException {
        File rootFile = new File(root);
        if (javaMode) {
            JavaFileVistor jfv = new JavaFileVistor(rootFile.getAbsolutePath());
            Files.walkFileTree(rootFile.toPath(), jfv);
            return jfv.getFileList();
        }
        CFileVistor cfv = new CFileVistor(rootFile.getAbsolutePath());
        Files.walkFileTree(rootFile.toPath(), cfv);
        return cfv.getFileList();
    }

    private boolean addClone(ArrayList<Clone> cloneList, Clone clone) {
        for (Clone pClone : cloneList) {
            if (!clone.equals(pClone)) continue;
            return false;
        }
        cloneList.add(clone);
        return true;
    }

    private void extractMethodForJava(SourceFile sfile, String abstPath, boolean isNew) throws FileNotFoundException, IOException {
        Logger.writeln("<extractMethodForJava> SouceFile is " + sfile.getName(), -1);
        if (isNew ? sfile.getNewMethodList().size() > 0 : sfile.getOldMethodList().size() > 0) {
            return;
        }
        Logger.writeln("Start extract method for " + sfile.getName(), -1);
        JavaMethodExtractor jme = new JavaMethodExtractor(abstPath);
        if (isNew) {
            sfile.setNewMethodList(jme.extractMethod());
        } else {
            sfile.setOldMethodList(jme.extractMethod());
        }
    }

    private void extractMethodForC(SourceFile sfile, String abstPath, boolean isNew) throws FileNotFoundException, IOException {
        Logger.writeln("<extractMethodForC> SouceFile is " + sfile.getName(), -1);
        if (isNew ? sfile.getNewMethodList().size() > 0 : sfile.getOldMethodList().size() > 0) {
            return;
        }
        Logger.writeln("Start extract method for " + sfile.getName(), -1);
        CMethodExtractor cme = new CMethodExtractor(abstPath);
        if (isNew) {
            sfile.setNewMethodList(cme.extractMethod());
        } else {
            sfile.setOldMethodList(cme.extractMethod());
        }
    }
}

