/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.y_yuuki.cn.generate;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.Logger;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Clone;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.CloneSet;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Project;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.SourceFile;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.generate.OutputGenerator;

public class HTMLFileGenerater {
    private static final String SCRIPT = "script.js";
    private static final String INDEX_PAGE = "index.html";
    private static final String CLONESETLIST_PAGE = "cloneset.html";
    private static final String PACKAGELIST_PAGE = "packagelist.html";
    private static final int STACK = 100;

    public static boolean generateHTMLFile(OutputGenerator g, Project project) {
        if (!HTMLFileGenerater.copyImageFiles(project.getGenerateHTMLDir())) {
            return false;
        }
        if (!HTMLFileGenerater.generateScript(project.getGenerateHTMLDir())) {
            return false;
        }
        File dir = new File(String.valueOf(project.getGenerateHTMLDir()) + "\\" + g.getYear() + g.getMonth() + g.getDay());
        dir.mkdirs();
        if (!HTMLFileGenerater.generateProjectPage(g, dir.getAbsolutePath(), project)) {
            return false;
        }
        if (!HTMLFileGenerater.generateCloneSetListPage(g, dir.toString(), project)) {
            return false;
        }
        if (!HTMLFileGenerater.generatePackageListPage(g, dir.getAbsolutePath(), project)) {
            return false;
        }
        File tmp = new File(String.valueOf(dir.toString()) + "\\src");
        if (tmp.exists()) {
            if (!HTMLFileGenerater.generateFileListPage(g, new File(String.valueOf(dir.getAbsolutePath()) + "\\" + "src"), 1, dir.getAbsolutePath(), project)) {
                return false;
            }
            return HTMLFileGenerater.generateDateListPage(project);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean copyImageFiles(String generateHTMLDir) {
        String[] images;
        File dir = new File(String.valueOf(generateHTMLDir) + "\\" + "res");
        if (dir.exists()) {
            return true;
        }
        dir.mkdirs();
        String[] stringArray = images = new String[]{"asc.gif", "desc.gif", "sort.gif"};
        int n = images.length;
        int n2 = 0;
        while (n2 < n) {
            String image = stringArray[n2];
            try {
                FileInputStream src = new FileInputStream("res/" + image);
                FileOutputStream dest = new FileOutputStream(String.valueOf(dir.toString()) + "/" + image);
                FileChannel srcChannel = src.getChannel();
                FileChannel destChannel = dest.getChannel();
                try {
                    try {
                        srcChannel.transferTo(0L, srcChannel.size(), destChannel);
                    }
                    catch (IOException e) {
                        try {
                            srcChannel.close();
                            destChannel.close();
                            src.close();
                            dest.close();
                            return false;
                        }
                        catch (IOException e2) {
                            return false;
                        }
                    }
                }
                finally {
                    try {
                        srcChannel.close();
                        destChannel.close();
                        src.close();
                        dest.close();
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
            }
            catch (FileNotFoundException e) {
                Logger.writeln("Can't find image files.", 2);
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean generateScript(String dir) {
        try {
            if (!new File(String.valueOf(dir) + "\\" + SCRIPT).exists()) {
                PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(dir) + "\\" + SCRIPT)));
                writer.println("var table=function(){");
                writer.println("\tfunction sorter(n){");
                writer.println("\t\tthis.n=n; this.t; this.b; this.r; this.d; this.p; this.w; this.a=[]; this.l=0");
                writer.println("\t}");
                writer.println("\tsorter.prototype.init=function(t,f){");
                writer.println("\t\tthis.t=document.getElementById(t);");
                writer.println("\t\tthis.b=this.t.getElementsByTagName('tbody')[0];");
                writer.println("\t\tthis.r=this.b.rows; var l=this.r.length;");
                writer.println("\t\tfor(var i=0;i<l;i++){");
                writer.println("\t\t\tif(i==0){");
                writer.println("\t\t\t\tvar c=this.r[i].cells; this.w=c.length;");
                writer.println("\t\t\t\tfor(var x=0;x<this.w;x++){");
                writer.println("\t\t\t\t\tif(c[x].className!='nosort'){");
                writer.println("\t\t\t\t\t\tc[x].className='head';");
                writer.println("\t\t\t\t\t\tc[x].onclick=new Function(this.n+'.work(this.cellIndex)')");
                writer.println("\t\t\t\t\t}");
                writer.println("\t\t\t\t}");
                writer.println("\t\t\t}else{");
                writer.println("\t\t\t\tthis.a[i-1]={}; this.l++;");
                writer.println("\t\t\t}");
                writer.println("\t\t}");
                writer.println("\t\tif(f!=null){");
                writer.println("\t\t\tvar a=new Function(this.n+'.work('+f+')'); a()");
                writer.println("\t\t}");
                writer.println("\t}");
                writer.println("\tsorter.prototype.work=function(y){");
                writer.println("\t\tthis.b=this.t.getElementsByTagName('tbody')[0]; this.r=this.b.rows;");
                writer.println("\t\tvar x=this.r[0].cells[y],i;");
                writer.println("\t\tfor(i=0;i<this.l;i++){");
                writer.println("\t\t\tthis.a[i].o=i+1; var v=this.r[i+1].cells[y].firstChild;");
                writer.println("\t\t\tthis.a[i].value=(v!=null)?v.nodeValue:''");
                writer.println("\t\t}");
                writer.println("\t\tfor(i=0;i<this.w;i++){");
                writer.println("\t\t\tvar c=this.r[0].cells[i];");
                writer.println("\t\t\tif(c.className!='nosort'){c.className='head'}");
                writer.println("\t\t}");
                writer.println("\t\tif(this.p==y){");
                writer.println("\t\t\tthis.a.reverse(); x.className=(this.d)?'asc':'desc';");
                writer.println("\t\t\tthis.d=(this.d)?false:true");
                writer.println("\t\t}else{");
                writer.println("\t\t\tthis.p=y; this.a.sort(compare); x.className='asc'; this.d=false");
                writer.println("\t\t}");
                writer.println("\t\tvar n=document.createElement('tbody');");
                writer.println("\t\tn.appendChild(this.r[0]);");
                writer.println("\t\tfor(i=0;i<this.l;i++){");
                writer.println("\t\t\tvar r=this.r[this.a[i].o-1].cloneNode(true);");
                writer.println("\t\t\tn.appendChild(r); r.className=(i%2==0)?'even':'odd'");
                writer.println("\t\t}");
                writer.println("\t\tthis.t.replaceChild(n,this.b)");
                writer.println("\t}");
                writer.println("\tfunction compare(f,c){");
                writer.println("\t\tf=f.value,c=c.value;");
                writer.println("\t\tvar i=parseFloat(f.replace(/(\\$|\\,)/g,'')),n=parseFloat(c.replace(/(\\$|\\,)/g,''));");
                writer.println("\t\tif(!isNaN(i)&&!isNaN(n)){f=i,c=n}");
                writer.println("\t\treturn (f>c?1:(f<c?-1:0))");
                writer.println("\t}");
                writer.println("\treturn{sorter:sorter}");
                writer.println("}();");
                writer.close();
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean generateProjectPage(OutputGenerator g, String dir, Project project) {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(dir) + "\\" + INDEX_PAGE)));
            HTMLFileGenerater.outputHtmlHead(writer, project.getName());
            writer.printf("<a href=\"../%s\">%s\u5e74%s\u6708%s\u65e5</a>\r\n", INDEX_PAGE, g.getYear(), g.getMonth(), g.getDay());
            writer.printf("<h1> \u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u540d\uff1a %s </h1>\r\n", project.getName());
            writer.printf("<hr>\r\n", new Object[0]);
            writer.printf("<center>\r\n", new Object[0]);
            writer.printf("<h2><a href=\"%s\">\u30af\u30ed\u30fc\u30f3\u30bb\u30c3\u30c8\u4e00\u89a7</a></h2>\r\n", CLONESETLIST_PAGE);
            writer.printf("<hr>\r\n", new Object[0]);
            writer.printf("<h2><a href=\"%s\">\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff08\u30d1\u30c3\u30b1\u30fc\u30b8\uff09\u4e00\u89a7</a></h2>\r\n", PACKAGELIST_PAGE);
            writer.printf("<hr>\r\n", new Object[0]);
            writer.printf("<table border=\"1\">\r\n", new Object[0]);
            writer.printf("<tr><th bgcolor=\"lightgrey\" colspan=\"2\">\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u60c5\u5831</th></tr>\r\n", new Object[0]);
            writer.printf("<tr bgcolor=\"#D1D168\"><th colspan=\"2\">\u30bd\u30fc\u30b9\u30d5\u30a1\u30a4\u30eb\u60c5\u5831</th></tr>\r\n", new Object[0]);
            writer.printf("<tr><th width=\"400\">\u7dcf\u30d5\u30a1\u30a4\u30eb\u6570</th><td width=\"200\">%d</td></tr>\r\n", g.getFileNum());
            writer.printf("<tr><th width=\"400\">\u8ffd\u52a0\u30d5\u30a1\u30a4\u30eb\u6570</th><td width=\"200\">%d</td></tr>\r\n", g.getAddedFileNum());
            writer.printf("<tr><th width=\"400\">\u524a\u9664\u30d5\u30a1\u30a4\u30eb\u6570</th><td width=\"200\">%d</td></tr>\r\n", g.getDeletedFileNum());
            writer.printf("<tr><th width=\"400\">\u30af\u30ed\u30fc\u30f3\u3092\u542b\u3080\u30d5\u30a1\u30a4\u30eb\u6570</th><td width=\"200\">%d</td></tr>\r\n", g.getCloneFileNum());
            writer.printf("<tr bgcolor=\"#D1D168\"><th colspan=\"2\">\u30af\u30ed\u30fc\u30f3\u30bb\u30c3\u30c8\u5206\u985e\u60c5\u5831</th></tr>\r\n", new Object[0]);
            writer.printf("<tr><th width=\"400\">\u7dcf\u30af\u30ed\u30fc\u30f3\u30bb\u30c3\u30c8\u6570</th><td width=\"200\">%d</td></tr>\r\n", g.getCloneSetNum());
            writer.printf("<tr><th width=\"400\"><a href=\"%s#stable\">STABLE\u30af\u30ed\u30fc\u30f3\u30bb\u30c3\u30c8\u6570</a></th><td width=\"200\">%d</td></tr>\r\n", CLONESETLIST_PAGE, g.getStableCloneSetNum());
            writer.printf("<tr><th width=\"400\"><a href=\"%s#changed\">CHANGED\u30af\u30ed\u30fc\u30f3\u30bb\u30c3\u30c8\u6570</a></th><td width=\"200\">%d</td></tr>\r\n", CLONESETLIST_PAGE, g.getChangedCloneSetNum());
            writer.printf("<tr><th width=\"400\"><a href=\"%s#new\">NEW\u30af\u30ed\u30fc\u30f3\u30bb\u30c3\u30c8\u6570</a></th><td width=\"200\">%d</td></tr>\r\n", CLONESETLIST_PAGE, g.getNewCloneSetNum());
            writer.printf("<tr><th width=\"400\"><a href=\"%s#deleted\">DELETED\u30af\u30ed\u30fc\u30f3\u30bb\u30c3\u30c8\u6570</a></th><td width=\"200\">%d</td></tr>\r\n", CLONESETLIST_PAGE, g.getDeletedCloneSetNum());
            writer.printf("<tr bgcolor=\"D1D168\"><th colspan=\"2\">\u30b3\u30fc\u30c9\u30af\u30ed\u30fc\u30f3\u5206\u985e\u60c5\u5831</th></tr>\r\n", new Object[0]);
            writer.printf("<tr><th width=\"400\">\u7dcf\u30b3\u30fc\u30c9\u30af\u30ed\u30fc\u30f3\u6570</th><td width=\"200\">%d</td></tr>\r\n", g.getCloneNum());
            writer.printf("<tr><th width=\"400\">STABLE\u30af\u30ed\u30fc\u30f3\u6570</th><td width=\"200\">%d</td></tr>\r\n", g.getStableCloneNum());
            writer.printf("<tr><th width=\"400\">MODIFIED\u30af\u30ed\u30fc\u30f3\u6570</th><td width=\"200\">%d</td></tr>\r\n", g.getModifiedCloneNum());
            writer.printf("<tr><th width=\"400\">MOVED\u30af\u30ed\u30fc\u30f3\u6570</th><td width=\"200\">%d</td></tr>\r\n", g.getMovedCloneNum());
            writer.printf("<tr><th width=\"400\">ADDED\u30af\u30ed\u30fc\u30f3\u6570</th><td width=\"200\">%d</td></tr>\r\n", g.getAddedCloneNum());
            writer.printf("<tr><th width=\"400\">DELETED\u30af\u30ed\u30fc\u30f3\u6570</th><td width=\"200\">%d</td></tr>\r\n", g.getDeletedCloneNum());
            writer.printf("</table>\n", new Object[0]);
            writer.printf("</body>\n", new Object[0]);
            writer.printf("</html>\n", new Object[0]);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static boolean generateCloneSetListPage(OutputGenerator g, String dir, Project project) {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(dir) + "\\" + CLONESETLIST_PAGE)));
            HTMLFileGenerater.outputHtmlHead(writer, String.valueOf(project.getName()) + "-\u30af\u30ed\u30fc\u30f3\u30bb\u30c3\u30c8\u4e00\u89a7");
            writer.printf("<a href=\"../%s\">%s\u5e74%s\u6708%s\u65e5</a>\r\n", INDEX_PAGE, g.getYear(), g.getMonth(), g.getDay());
            writer.printf("<h1>\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u540d\uff1a<a href=\"%s\">%s</a></h1>\r\n", INDEX_PAGE, project.getName());
            writer.printf("<h2>\u30af\u30ed\u30fc\u30f3\u30bb\u30c3\u30c8\u30ea\u30b9\u30c8</h2>\r\n", new Object[0]);
            writer.printf("<center>\r\n", new Object[0]);
            if (project.getCloneSetList().isEmpty()) {
                writer.printf("<hr>\r\n", new Object[0]);
                writer.printf("\u30af\u30ed\u30fc\u30f3\u30bb\u30c3\u30c8\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\r\n ", new Object[0]);
            } else {
                writer.printf("<hr>\r\n", new Object[0]);
                writer.printf("<table border=\"1\" class=\"sortable\" id=\"sorter\">\r\n", new Object[0]);
                writer.printf("<tr>\r\n", new Object[0]);
                writer.printf("<th bgcolor=\"gainsboro\" class=\"nosort\">ID</th>\r\n", new Object[0]);
                writer.printf("<th >\u5206\u985e</th>\r\n", new Object[0]);
                if (project.getTool().equals("CCFinderX")) {
                    writer.printf("<th >LEN</th>\r\n", new Object[0]);
                    writer.printf("<th>POP</th>\r\n", new Object[0]);
                    writer.printf("<th>NIF</th>\r\n", new Object[0]);
                    writer.printf("<th>RAD</th>\r\n", new Object[0]);
                    writer.printf("<th>RNR</th>\r\n", new Object[0]);
                    writer.printf("<th>TKS</th>\r\n", new Object[0]);
                    writer.printf("<th>LOOP</th>\r\n", new Object[0]);
                    writer.printf("<th>COND</th>\r\n", new Object[0]);
                    writer.printf("<th>McCabe</th>\r\n", new Object[0]);
                }
                writer.printf("</tr>\r\n", new Object[0]);
                for (CloneSet cloneSet : project.getCloneSetList()) {
                    writer.printf("<tr bgcolor=\"%s\">\r\n", HTMLFileGenerater.getCloneSetColor(cloneSet));
                    writer.printf("<td><a href=\"cloneset.html#cloneset%d\">%d</a></td>\r\n", cloneSet.getOutputId(), cloneSet.getOutputId());
                    writer.printf("<td>%s</td>\r\n", cloneSet.getCategoryString());
                    if (project.getTool().equals("CCFinderX")) {
                        writer.printf("<td>%d</td>\r\n", cloneSet.getLEN());
                        writer.printf("<td>%d</td>\r\n", cloneSet.getPOP());
                        writer.printf("<td>%d</td>\r\n", cloneSet.getNIF());
                        writer.printf("<td>%d</td>\r\n", cloneSet.getRAD());
                        writer.printf("<td>%f</td>\r\n", cloneSet.getRNR());
                        writer.printf("<td>%d</td>\r\n", cloneSet.getTKS());
                        writer.printf("<td>%d</td>\r\n", cloneSet.getLOOP());
                        writer.printf("<td>%d</td>\r\n", cloneSet.getCOND());
                        writer.printf("<td>%d</td>\r\n", cloneSet.getMcCabe());
                    }
                    writer.printf("</tr>\r\n", new Object[0]);
                }
                writer.printf("</table>\r\n", new Object[0]);
                writer.printf("<hr>\r\n", new Object[0]);
                writer.printf("<h2 id=\"new\">New Clone Set</h2>\r\n", new Object[0]);
                if (g.getNewCloneSetNum() == 0) {
                    writer.printf("New Clone Set \u306f\u5b58\u5728\u3057\u307e\u305b\u3093\r\n ", new Object[0]);
                } else {
                    for (CloneSet cloneSet : project.getCloneSetList()) {
                        if (cloneSet.getCategory() != 0) continue;
                        HTMLFileGenerater.outputCloneSet(writer, project, cloneSet);
                    }
                }
                writer.printf("<hr>\r\n", new Object[0]);
                writer.printf("<h2 id=\"changed\">Changed Clone Set</h2>\r\n", new Object[0]);
                if (g.getChangedCloneSetNum() == 0) {
                    writer.printf("Changed Clone Set \u306f\u5b58\u5728\u3057\u307e\u305b\u3093\r\n ", new Object[0]);
                } else {
                    for (CloneSet cloneSet : project.getCloneSetList()) {
                        if (cloneSet.getCategory() != 1) continue;
                        HTMLFileGenerater.outputCloneSet(writer, project, cloneSet);
                    }
                }
                writer.printf("<hr>\r\n", new Object[0]);
                writer.printf("<h2 id=\"deleted\">Deleted Clone Set</h2>\r\n", new Object[0]);
                if (g.getDeletedCloneSetNum() == 0) {
                    writer.printf("Deleted Clone Set  \u306f\u5b58\u5728\u3057\u307e\u305b\u3093\r\n ", new Object[0]);
                } else {
                    for (CloneSet cloneSet : project.getCloneSetList()) {
                        if (cloneSet.getCategory() != 2) continue;
                        HTMLFileGenerater.outputCloneSet(writer, project, cloneSet);
                    }
                }
                writer.printf("<hr>\r\n", new Object[0]);
                writer.printf("<h2 id=\"stable\">Stable Clone Set</h2>\r\n", new Object[0]);
                if (g.getStableCloneSetNum() == 0) {
                    writer.printf("Stable Clone Set\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\r\n ", new Object[0]);
                } else {
                    for (CloneSet cloneSet : project.getCloneSetList()) {
                        if (cloneSet.getCategory() != 3) continue;
                        HTMLFileGenerater.outputCloneSet(writer, project, cloneSet);
                    }
                }
            }
            writer.printf("\t <script type=\"text/javascript\"> \r\n", new Object[0]);
            writer.printf("\t var sorter=new table.sorter(\"sorter\");\r\n", new Object[0]);
            writer.printf("\t sorter.init(\"sorter\",1); \r\n", new Object[0]);
            writer.printf("\t </script> \r\n", new Object[0]);
            writer.printf("</body>\r\n", new Object[0]);
            writer.printf("</html>\r\n", new Object[0]);
            writer.flush();
            writer.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static void outputCloneSet(PrintWriter writer, Project project, CloneSet cloneSet) {
        writer.printf("<hr>\r\n", new Object[0]);
        writer.printf("<table id=\"cloneset%d\" border=\"1\">\r\n", cloneSet.getOutputId());
        writer.printf("<tr><th bgcolor=\"%s\" colspan=\"4\">\u30af\u30ed\u30fc\u30f3\u30bb\u30c3\u30c8ID:%d</th></tr>\r\n", HTMLFileGenerater.getCloneSetColor(cloneSet), cloneSet.getOutputId());
        writer.printf("<tr bgcolor=\"lightgrey\">\r\n", new Object[0]);
        writer.printf("<th width=\"50\">ID</th>\r\n", new Object[0]);
        writer.printf("<th width=\"100\">\u5206\u985e</th>\r\n", new Object[0]);
        writer.printf("<th width=\"720\">\u30d5\u30a1\u30a4\u30eb\u540d</th>\r\n", new Object[0]);
        writer.printf("<th width=\"120\">\u4f4d\u7f6e</th>\r\n", new Object[0]);
        if (project.getTool().equals("CloneDetector")) {
            writer.printf("<th width=\"200\">\u30e1\u30bd\u30c3\u30c9\u540d</th>\r\n", new Object[0]);
        }
        writer.printf("</tr>\r\n", new Object[0]);
        for (Clone clone : cloneSet.getNewCloneList()) {
            writer.printf("<tr bgcolor=\"%s\">\r\n", HTMLFileGenerater.getCloneColor(clone));
            writer.printf("<td><a href=\"%s#clone%d\">%d.%d</a></td>\r\n", String.valueOf(clone.getFile().getName().replace("\\", "/")) + ".html", clone.getId(), cloneSet.getOutputId(), clone.getOutputId());
            writer.printf("<td>%s</td>\r\n", clone.getCategoryString());
            writer.printf("<td>%s</td>\r\n", clone.getFile().getName());
            writer.printf("<td>%d.%d-%d.%d</td>\n", clone.getStartLine(), clone.getStartColumn(), clone.getEndLine(), clone.getEndColumn());
            if (project.getTool().equals("CloneDetector")) {
                writer.printf("<td>%s</td>", clone.getMethodName());
            }
            writer.printf("</tr>\n", new Object[0]);
        }
        if (cloneSet.containsOldClone()) {
            writer.printf("<tr><th colspan=\"4\">\u524d\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u30b3\u30fc\u30c9\u30af\u30ed\u30fc\u30f3</th></tr>\r\n", new Object[0]);
        }
        for (Clone clone : cloneSet.getOldCloneList()) {
            if (clone.getCategory() != 4 && clone.getCategory() != 2) continue;
            if (clone.getCategory() == 2) {
                clone = clone.getChildClone();
            }
            writer.printf("<tr bgcolor=\"%s\">\r\n", HTMLFileGenerater.getCloneColor(clone));
            writer.printf("<td><a href=\"%s#clone%d\">%d.%d</a></td>\r\n", String.valueOf(clone.getFile().getName().replace("\\", "/")) + ".html", clone.getId(), cloneSet.getOutputId(), clone.getOutputId());
            writer.printf("<td>%s</td>\r\n", clone.getCategoryString());
            writer.printf("<td>%s</td>\r\n", clone.getFile().getName());
            writer.printf("<td>%d.%d-%d.%d</td>\n", clone.getStartLine(), clone.getStartColumn(), clone.getEndLine(), clone.getEndColumn());
            if (project.getTool().equals("CloneDetector")) {
                writer.printf("<td>%s</td>", clone.getMethodName());
            }
            writer.printf("</tr>\n", new Object[0]);
        }
        writer.printf("</table>\n", new Object[0]);
    }

    private static boolean generatePackageListPage(OutputGenerator g, String dir, Project project) {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(dir) + "/" + PACKAGELIST_PAGE)));
            HTMLFileGenerater.outputHtmlHead(writer, String.valueOf(project.getName()) + "-\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff08\u30d1\u30c3\u30b1\u30fc\u30b8\uff09\u4e00\u89a7");
            writer.printf("<a href=\"../%s\">%s\u5e74%s\u6708%s\u65e5</a>\r\n", INDEX_PAGE, g.getYear(), g.getMonth(), g.getDay());
            writer.printf("<h1>\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u540d\uff1a<a href=\"%s\">%s</a></h1>\r\n", INDEX_PAGE, project.getName());
            writer.printf("<h2>\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff08\u30d1\u30c3\u30b1\u30fc\u30b8\uff09\u4e00\u89a7</h2>\r\n", new Object[0]);
            writer.printf("<hr>\r\n", new Object[0]);
            writer.printf("<center>\r\n", new Object[0]);
            writer.printf("<table border=\"1\" width=\"500\">\n", new Object[0]);
            writer.printf("<tr><th bgcolor=\"greenyellow\">\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff08\u30d1\u30c3\u30b1\u30fc\u30b8\uff09\u4e00\u89a7</th></tr>\n", new Object[0]);
            ArrayList<String> packageList = new ArrayList<String>();
            boolean flag = false;
            for (SourceFile file : project.getFileList()) {
                if (file.getNewCloneList().isEmpty() && file.getOldCloneList().isEmpty()) continue;
                flag = true;
                String fileName = file.getState() != 2 ? new File(file.getNewPath()).getName() : new File(file.getOldPath()).getName();
                String packageDirPath = String.valueOf(dir) + "\\" + file.getName();
                packageDirPath = packageDirPath.replace("\\" + fileName, "");
                File packageDir = new File(packageDirPath);
                if (!packageList.contains(packageDirPath.toString())) {
                    packageList.add(packageDirPath.toString());
                    packageDir.mkdirs();
                    writer.printf("<tr><td><a href=\"%s\">%s</a></td></tr>\r\n", String.valueOf(packageDirPath.replace(dir, "").replace("\\", "/").substring(1)) + "/" + INDEX_PAGE, packageDirPath.replace(dir, "").substring(1));
                }
                if (file.getState() == 1) {
                    HTMLFileGenerater.generateAddedSourceFile(g, file, String.valueOf(packageDirPath) + "\\" + fileName + ".html", project.getName());
                    continue;
                }
                if (file.getState() == 0) {
                    HTMLFileGenerater.generateNormalSourceFile(g, file, String.valueOf(packageDirPath) + "\\" + fileName + ".html", project.getName());
                    continue;
                }
                if (file.getState() != 2) continue;
                HTMLFileGenerater.generateDeletedSourceFile(g, file, String.valueOf(packageDirPath) + "\\" + fileName + ".html", project.getName());
            }
            if (!flag) {
                writer.printf("<tr><td>\u30af\u30ed\u30fc\u30f3\u3092\u542b\u3080\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff08\u30d1\u30c3\u30b1\u30fc\u30b8\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\uff09</td></tr>\r\n", new Object[0]);
            }
            writer.printf("</table>\r\n", new Object[0]);
            writer.printf("</body>\r\n", new Object[0]);
            writer.printf("</html>\r\n", new Object[0]);
            writer.flush();
            writer.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean generateNormalSourceFile(OutputGenerator g, SourceFile file, String fileName, String projectName) {
        BufferedReader readerA = null;
        BufferedReader readerB = null;
        try {
            readerA = new BufferedReader(new InputStreamReader(new FileInputStream(file.getNewPath())));
            readerB = new BufferedReader(new InputStreamReader(new FileInputStream(file.getOldPath())));
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            int countClone = 0;
            int lineNumA = 0;
            int lineNumB = 0;
            int addCodeId = 0;
            int deleteCodeId = 0;
            String cloneSetFile = HTMLFileGenerater.outputHtmlHead(g, writer, file, projectName);
            writer.printf("<table cellpadding=\"0\">\r\n", new Object[0]);
            writer.printf("<tr><td width=\"50\"></td><td width=\"50\"></td><td></td></tr>\r\n", new Object[0]);
            while (true) {
                String lineB;
                String lineA;
                if ((lineA = readerA.readLine()) != null) {
                    ++lineNumA;
                }
                if ((lineB = readerB.readLine()) != null) {
                    ++lineNumB;
                }
                while (addCodeId < file.getAddedCodeList().size() && lineNumA == file.getAddedCodeList().get(addCodeId)) {
                    ++addCodeId;
                    HTMLFileGenerater.writeCodeLine(writer, Integer.toString(lineNumA), "+", lineA, countClone += HTMLFileGenerater.outputCloneStartSign(writer, file.getNewCloneList(), lineNumA, false, cloneSetFile));
                    countClone -= HTMLFileGenerater.writeCloneEndSign(writer, file.getNewCloneList(), lineNumA, false);
                    lineA = readerA.readLine();
                    if (lineA == null) continue;
                    ++lineNumA;
                }
                while (deleteCodeId < file.getDeletedCodeList().size() && lineNumB == file.getDeletedCodeList().get(deleteCodeId)) {
                    ++deleteCodeId;
                    HTMLFileGenerater.writeCodeLine(writer, "", "-", lineB, countClone += HTMLFileGenerater.outputCloneStartSign(writer, file.getOldCloneList(), lineNumB, true, cloneSetFile));
                    countClone -= HTMLFileGenerater.writeCloneEndSign(writer, file.getOldCloneList(), lineNumB, true);
                    lineB = readerB.readLine();
                    if (lineB == null) continue;
                    ++lineNumB;
                }
                if (lineA == null && lineB == null) break;
                countClone += HTMLFileGenerater.outputCloneStartSign(writer, file.getNewCloneList(), lineNumA, false, cloneSetFile);
                HTMLFileGenerater.writeCodeLine(writer, Integer.toString(lineNumA), "", lineA, countClone += HTMLFileGenerater.outputCloneStartSign(writer, file.getOldCloneList(), lineNumB, true, cloneSetFile));
                countClone -= HTMLFileGenerater.writeCloneEndSign(writer, file.getNewCloneList(), lineNumA, false);
                countClone -= HTMLFileGenerater.writeCloneEndSign(writer, file.getOldCloneList(), lineNumB, true);
            }
            writer.printf("</table>\n", new Object[0]);
            writer.printf("</body>\n", new Object[0]);
            writer.printf("</html>\n", new Object[0]);
            writer.flush();
            writer.close();
            if (readerA != null) {
                readerA.close();
            }
            if (readerB != null) {
                readerB.close();
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean generateAddedSourceFile(OutputGenerator g, SourceFile file, String fileName, String projectName) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file.getNewPath())));
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            int countClone = 0;
            int lineNum = 0;
            String cloneSetFile = HTMLFileGenerater.outputHtmlHead(g, writer, file, projectName);
            writer.printf("<table cellpadding=\"0\">\r\n", new Object[0]);
            writer.printf("<tr><td width=\"50\"></td><td width=\"50\"></td><td></td></tr>\r\n", new Object[0]);
            while ((line = reader.readLine()) != null) {
                countClone = HTMLFileGenerater.outputCloneStartSign(writer, file.getNewCloneList(), ++lineNum, false, cloneSetFile) + countClone;
                HTMLFileGenerater.writeCodeLine(writer, Integer.toString(lineNum), "+", line, countClone);
                countClone -= HTMLFileGenerater.writeCloneEndSign(writer, file.getNewCloneList(), lineNum, false);
            }
            writer.printf("</table>\r\n", new Object[0]);
            writer.printf("</body>\r\n", new Object[0]);
            writer.printf("</html>\r\n", new Object[0]);
            writer.flush();
            writer.close();
            if (reader != null) {
                reader.close();
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean generateDeletedSourceFile(OutputGenerator g, SourceFile file, String fileName, String projectName) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file.getOldPath())));
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            int lineNum = 0;
            int countClone = 0;
            String cloneSetFile = HTMLFileGenerater.outputHtmlHead(g, writer, file, projectName);
            writer.printf("<table cellpadding=\"0\">\r\n", new Object[0]);
            writer.printf("<tr><td width=\"50\"></td><td width=\"50\"></td><td></td></tr>\r\n", new Object[0]);
            while ((line = reader.readLine()) != null) {
                HTMLFileGenerater.writeCodeLine(writer, Integer.toString(lineNum), "-", line, countClone += HTMLFileGenerater.outputCloneStartSign(writer, file.getOldCloneList(), ++lineNum, true, cloneSetFile));
                countClone -= HTMLFileGenerater.writeCloneEndSign(writer, file.getOldCloneList(), lineNum, true);
            }
            writer.printf("</table>\r\n", new Object[0]);
            writer.printf("</body>\r\n", new Object[0]);
            writer.printf("</html>\r\n", new Object[0]);
            writer.flush();
            writer.close();
            if (reader != null) {
                reader.close();
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean generateDateListPage(Project project) {
        File index = new File(String.valueOf(project.getGenerateHTMLDir()) + "\\" + INDEX_PAGE);
        if (index.exists()) {
            index.delete();
        }
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(project.getGenerateHTMLDir()) + "\\" + INDEX_PAGE)));
            File[] dateList = new File(project.getGenerateHTMLDir()).listFiles();
            HTMLFileGenerater.outputHtmlHead(writer, "\u30b3\u30fc\u30c9\u30af\u30ed\u30fc\u30f3\u5909\u66f4\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0");
            writer.println("<h1>\u30b3\u30fc\u30c9\u30af\u30ed\u30fc\u30f3\u5909\u66f4\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0</h1>");
            writer.println("<h1>\u5206\u6790\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\uff1a" + project.getName() + "</h1>");
            writer.println("<hr>");
            writer.println("<center>");
            writer.println("<table border=\"1\">");
            writer.println("<tr bgcolor=\"greenyellow\"><th>\u5206\u6790\u65e5\u4e00\u89a7</th></tr>");
            int i = 0;
            while (i < dateList.length) {
                String date = dateList[i].getName();
                if (dateList[i].isDirectory() && i < 100 && date.length() == 8) {
                    writer.printf("<tr><td><a href = \"%s\">%c%c%c%c\u5e74%c%c\u6708%c%c\u65e5</a></td></tr>\n", String.valueOf(date) + "/" + INDEX_PAGE, Character.valueOf(date.charAt(0)), Character.valueOf(date.charAt(1)), Character.valueOf(date.charAt(2)), Character.valueOf(date.charAt(3)), Character.valueOf(date.charAt(4)), Character.valueOf(date.charAt(5)), Character.valueOf(date.charAt(6)), Character.valueOf(date.charAt(7)));
                } else if (!dateList[i].getName().equals(SCRIPT) && !dateList[i].getName().equals("res")) {
                    HTMLFileGenerater.deleteDir(dateList[i].toString());
                }
                ++i;
            }
            writer.println("</table>");
            writer.println("</html>");
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static boolean generateFileListPage(OutputGenerator g, File dir, int node, String indexDir, Project project) {
        File[] files = dir.listFiles();
        boolean flag = false;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                flag = true;
            } else if (file.isDirectory()) {
                HTMLFileGenerater.generateFileListPage(g, file, node + 1, indexDir, project);
            }
            ++n2;
        }
        if (flag) {
            try {
                PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(dir + "/" + INDEX_PAGE)));
                HTMLFileGenerater.outputHtmlHead(writer, String.valueOf(project.getName()) + "-" + dir.toString().replace(indexDir, "") + "-\u30bd\u30fc\u30b9\u30d5\u30a1\u30a4\u30eb\u4e00\u89a7");
                String projectFile = INDEX_PAGE;
                String projectListFile = "../index.html";
                int i = 0;
                while (i < node) {
                    projectFile = "../" + projectFile;
                    projectListFile = "../" + projectListFile;
                    ++i;
                }
                writer.printf("<a href=\"%s\">%s\u5e74%s\u6708%s\u65e5</a>\r\n", projectListFile, g.getYear(), g.getMonth(), g.getDay());
                writer.printf("<h1>\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u540d\uff1a<a href=\"%s\">%s</a></h1>\r\n", projectFile, project.getName());
                writer.printf("<h2>\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff08\u30d1\u30c3\u30b1\u30fc\u30b8\uff09\u540d\uff1a%s</h2>\r\n", dir.toString().replace(indexDir, "").substring(1));
                writer.printf("<hr>\r\n", new Object[0]);
                writer.printf("<center>\r\n", new Object[0]);
                writer.printf("<table width=\"650\" border=\"1\">\r\n", new Object[0]);
                writer.printf("<tr><th bgcolor=\"greenyellow\" colspan=\"3\">\u30af\u30ed\u30fc\u30f3\u3092\u542b\u3080\u30bd\u30fc\u30b9\u30d5\u30a1\u30a4\u30eb\u4e00\u89a7</th></tr>\r\n", new Object[0]);
                writer.printf("<tr bgcolor=\"lightgrey\">\r\n", new Object[0]);
                writer.printf("<th width=\"400\">\u30d5\u30a1\u30a4\u30eb\u540d</th>\r\n", new Object[0]);
                writer.printf("<th width=\"100\">\u30af\u30ed\u30fc\u30f3\u6570</th>\r\n", new Object[0]);
                writer.printf("<th width=\"150\">\u5099\u8003</th>\r\n", new Object[0]);
                writer.printf("</tr>\r\n", new Object[0]);
                i = 0;
                while (i < files.length) {
                    if (files[i].isFile() && !files[i].getName().equals(INDEX_PAGE)) {
                        SourceFile file = null;
                        for (SourceFile tmpFile : project.getFileList()) {
                            if (!tmpFile.getName().equals(files[i].toString().replace(indexDir, "").replace(".html", "").substring(1))) continue;
                            file = tmpFile;
                            break;
                        }
                        if (file != null) {
                            writer.printf("<tr bgcolor=\"%s\">\r\n", HTMLFileGenerater.getSourceFileColor(file));
                            writer.printf("<td><a href=\"%s\">%s</a></td>\r\n", files[i].getName(), files[i].getName().replace(".html", ""));
                            writer.printf("<td>%d</td>\r\n", file.getNewCloneList().size());
                            writer.printf("<td>%s</td>\r\n", HTMLFileGenerater.getFileState(file));
                            writer.println("</tr>\n");
                        }
                    }
                    ++i;
                }
                writer.printf("</table>\n", new Object[0]);
                writer.printf("</body>\n", new Object[0]);
                writer.printf("</html>\n", new Object[0]);
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    private static int outputCloneStartSign(PrintWriter writer, ArrayList<Clone> cloneList, int line, boolean oldCloneFlag, String cloneSetFile) {
        int count = 0;
        for (Clone clone : cloneList) {
            if ((!oldCloneFlag || clone.getCategory() != 4) && oldCloneFlag || clone.getStartLine() != line || clone.getOutputId() == -1) continue;
            writer.printf("<tr id=\"clone%d\" ><th></th><th></th>", clone.getId());
            writer.printf("<th align=\"left\">[START CLONE:<a href=\"%s#cloneset%d\">%d.%d(%s\u30af\u30ed\u30fc\u30f3)</a>]</th></tr>", cloneSetFile, clone.getCloneSet().getOutputId(), clone.getCloneSet().getOutputId(), clone.getOutputId(), clone.getCategoryString());
            writer.println();
            ++count;
        }
        return count;
    }

    private static int writeCloneEndSign(PrintWriter writer, ArrayList<Clone> cloneList, int line, boolean oldCloneFlag) {
        int count = 0;
        for (Clone clone : cloneList) {
            if (oldCloneFlag && (!oldCloneFlag || clone.getCategory() != 4) || clone.getEndLine() != line || clone.getOutputId() == -1) continue;
            writer.printf("<tr><th></th><th></th>", new Object[0]);
            writer.printf("<th  align=\"left\">[END ID:%d.%d]</th></tr>", clone.getCloneSet().getOutputId(), clone.getOutputId());
            writer.println();
            ++count;
        }
        return count;
    }

    private static void writeCodeLine(PrintWriter writer, String lineNum, String state, String line, int count) {
        writer.printf("<tr>\r\n", new Object[0]);
        writer.printf("<th align=\"left\">%s</th>\r\n", lineNum);
        writer.printf("<th align=\"left\">%s</th>\r\n", state);
        if (count > 0 && state.equals("-")) {
            writer.printf("<td bgcolor=\"F2D500\"><xmp>%s</xmp></td>\r\n", line);
        } else if (count > 0) {
            writer.printf("<td bgcolor=\"yellow\"><xmp>%s</xmp></td>\r\n", line);
        } else if (state.equals("-")) {
            writer.printf("<td bgcolor=\"tan\"><xmp>%s</xmp></td>\r\n", line);
        } else {
            writer.printf("<td><xmp>%s</xmp></td>\r\n", line);
        }
        writer.println("</tr>");
    }

    private static void deleteDir(String dir) {
        File file = new File(dir);
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] f = file.listFiles();
                int i = 0;
                while (i < f.length) {
                    HTMLFileGenerater.deleteDir(f[i].toString());
                    ++i;
                }
            }
            file.delete();
        }
    }

    private static String getCloneSetColor(CloneSet cloneSet) {
        switch (cloneSet.getCategory()) {
            case 0: {
                return "orange";
            }
            case 1: {
                return "greenyellow";
            }
            case 2: {
                return "tan";
            }
        }
        return "white";
    }

    private static String getCloneColor(Clone clone) {
        switch (clone.getCategory()) {
            case 3: {
                return "#FFCCE5";
            }
            case 4: {
                return "#DBC7AC";
            }
            case 2: {
                return "#EFEFA7";
            }
            case 1: {
                return "#B2D6FF";
            }
        }
        return "white";
    }

    private static String getSourceFileColor(SourceFile file) {
        switch (file.getState()) {
            case 1: {
                return "orange";
            }
            case 2: {
                return "tan";
            }
        }
        return "white";
    }

    private static String getFileState(SourceFile file) {
        switch (file.getState()) {
            case 1: {
                return "\u8ffd\u52a0\u30d5\u30a1\u30a4\u30eb";
            }
            case 2: {
                return "\u524a\u9664\u30d5\u30a1\u30a4\u30eb";
            }
        }
        return " ";
    }

    private static void outputHtmlHead(PrintWriter writer, String title) {
        writer.println("<html>");
        writer.println("<head>");
        writer.println("\t<title>" + title + "</title>");
        writer.printf("\t<style type=\"text/css\">\r\n", new Object[0]);
        writer.printf("\t\t.sortable .head {background:gainsboro url(../image/sort.gif) 6px  center no-repeat; cursor:pointer; padding-left:18px}\r\n", new Object[0]);
        writer.printf("\t\t.sortable .desc {background:darkgray url(../image/desc.gif) 6px   center no-repeat; cursor:pointer; padding-left:18px}\r\n", new Object[0]);
        writer.printf("\t\t.sortable .asc {background:darkgray  url(../image/asc.gif) 6px  center no-repeat; cursor:pointer; padding-left:18px}\r\n", new Object[0]);
        writer.printf("\t\t.sortable .head:hover, .sortable .desc:hover, .sortable .asc:hover {color:white}\r\n", new Object[0]);
        writer.printf("\t</style>\r\n", new Object[0]);
        writer.println("<script type=\"text/javascript\" src=\"../script.js\"></script>");
        writer.println("</head>");
        writer.println("<body>");
    }

    private static String outputHtmlHead(OutputGenerator g, PrintWriter writer, SourceFile file, String projectName) {
        writer.printf("<html>\r\n", new Object[0]);
        writer.printf("<head>\n", new Object[0]);
        writer.printf("\t<title>%s-%s</title>\r\n", projectName, file.getName());
        writer.printf("\t<style type=\"text/css\">\r\n", new Object[0]);
        writer.println("\t\t td,th {font-size:12px}");
        writer.printf("\t\t td xmp {margin:0}\r\n", new Object[0]);
        writer.printf("\t</style>\r\n", new Object[0]);
        writer.printf("</head>\r\n", new Object[0]);
        writer.printf("<body>\r\n", new Object[0]);
        String projectListFile = "../index.html";
        String projectFile = INDEX_PAGE;
        String cloneSetFile = CLONESETLIST_PAGE;
        String[] tmp = file.getName().split("\\\\");
        int i = 0;
        while (i < tmp.length - 1) {
            projectFile = "../" + projectFile;
            cloneSetFile = "../" + cloneSetFile;
            projectListFile = "../" + projectListFile;
            ++i;
        }
        writer.printf("<a href=\"%s\">%s\u5e74%s\u6708%s\u65e5</a>\r\n", projectListFile, g.getYear(), g.getMonth(), g.getDay());
        writer.printf("<h1>\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u540d\uff1a<a href=\"%s\">%s</a></h1>\r\n", projectFile, projectName);
        writer.printf("<h2>\u30bd\u30fc\u30b9\u30d5\u30a1\u30a4\u30eb\uff1a%s</h2>\r\n", file.getName());
        writer.printf("<h4><a href=\"%s\">\u30bd\u30fc\u30b9\u30d5\u30a1\u30a4\u30eb\u4e00\u89a7\u3078\u623b\u308b</a></h4>\r\n", INDEX_PAGE);
        writer.printf("<hr>\r\n", new Object[0]);
        return cloneSetFile;
    }
}

